/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Map;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.GenericFileCollectionSnapshotter;
import org.gradle.api.internal.changedetection.state.SnapshotNormalizationStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertyCompareStrategy;
import org.gradle.api.internal.changedetection.state.TaskFilePropertySnapshotNormalizationStrategy;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.AbstractTaskPropertyBuilder;
import org.gradle.api.internal.tasks.TaskInputFilePropertyBuilderInternal;
import org.gradle.api.internal.tasks.TaskInputPropertySpecAndBuilder;
import org.gradle.api.internal.tasks.TaskPropertyFileCollection;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskInputFilePropertyBuilder;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskInputPropertySpec
extends AbstractTaskPropertyBuilder
implements TaskInputPropertySpecAndBuilder {
    private final TaskInputs taskInputs;
    private final TaskPropertyFileCollection files;
    private boolean skipWhenEmpty;
    private boolean optional;
    private TaskFilePropertyCompareStrategy compareStrategy = TaskFilePropertyCompareStrategy.UNORDERED;
    private SnapshotNormalizationStrategy snapshotNormalizationStrategy = TaskFilePropertySnapshotNormalizationStrategy.ABSOLUTE;
    private Class<? extends FileCollectionSnapshotter> snapshotter = GenericFileCollectionSnapshotter.class;

    public DefaultTaskInputPropertySpec(TaskInputs taskInputs, String taskName, boolean skipWhenEmpty, FileResolver resolver, Object paths) {
        this.taskInputs = taskInputs;
        this.files = new TaskPropertyFileCollection(taskName, "input", this, resolver, paths);
        this.skipWhenEmpty = skipWhenEmpty;
    }

    @Override
    public FileCollection getPropertyFiles() {
        return this.files;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPropertyName(String propertyName) {
        this.setPropertyName(propertyName);
        return this;
    }

    @Override
    public boolean isSkipWhenEmpty() {
        return this.skipWhenEmpty;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty(boolean skipWhenEmpty) {
        this.skipWhenEmpty = skipWhenEmpty;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal skipWhenEmpty() {
        return this.skipWhenEmpty(true);
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional(boolean optional) {
        this.optional = optional;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal optional() {
        return this.optional(true);
    }

    @Override
    public TaskFilePropertyCompareStrategy getCompareStrategy() {
        return this.compareStrategy;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal orderSensitive() {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TaskInputFilePropertyBuilder.orderSensitive()");
        this.setOrderSensitive(true);
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal orderSensitive(boolean orderSensitive) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)"TaskInputFilePropertyBuilder.orderSensitive(boolean)");
        this.setOrderSensitive(orderSensitive);
        return this;
    }

    private void setOrderSensitive(boolean orderSensitive) {
        this.compareStrategy = orderSensitive ? TaskFilePropertyCompareStrategy.ORDERED : TaskFilePropertyCompareStrategy.UNORDERED;
    }

    @Override
    public SnapshotNormalizationStrategy getSnapshotNormalizationStrategy() {
        return this.snapshotNormalizationStrategy;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withPathSensitivity(PathSensitivity sensitivity) {
        return this.withSnapshotNormalizationStrategy(TaskFilePropertySnapshotNormalizationStrategy.valueOf(sensitivity));
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withSnapshotNormalizationStrategy(SnapshotNormalizationStrategy snapshotNormalizationStrategy) {
        this.snapshotNormalizationStrategy = snapshotNormalizationStrategy;
        return this;
    }

    @Override
    public TaskInputFilePropertyBuilderInternal withSnapshotter(Class<? extends FileCollectionSnapshotter> snapshotter) {
        this.snapshotter = snapshotter;
        return this;
    }

    @Override
    public Class<? extends FileCollectionSnapshotter> getSnapshotter() {
        return this.snapshotter;
    }

    @Override
    public String toString() {
        return this.getPropertyName() + " (" + (Object)((Object)this.compareStrategy) + ", " + this.snapshotNormalizationStrategy + ")";
    }

    private TaskInputs getTaskInputs(String method) {
        DeprecationLogger.nagUserOfDiscontinuedMethod((String)("chaining of the " + method), (String)String.format("Please use the %s method on TaskInputs directly instead.", method));
        return this.taskInputs;
    }

    @Override
    public boolean getHasInputs() {
        return this.getTaskInputs("getHasInputs()").getHasInputs();
    }

    @Override
    public FileCollection getFiles() {
        return this.getTaskInputs("getFiles()").getFiles();
    }

    @Override
    public TaskInputFilePropertyBuilder files(Object ... paths) {
        return this.getTaskInputs("files(Object...)").files(paths);
    }

    @Override
    public TaskInputFilePropertyBuilder file(Object path) {
        return this.getTaskInputs("file(Object)").file(path);
    }

    @Override
    public TaskInputFilePropertyBuilder dir(Object dirPath) {
        return this.getTaskInputs("dir(Object)").dir(dirPath);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.getTaskInputs("getProperties()").getProperties();
    }

    @Override
    public TaskInputs property(String name, Object value) {
        return this.getTaskInputs("property(String, Object)").property(name, value);
    }

    @Override
    public TaskInputs properties(Map<String, ?> properties) {
        return this.getTaskInputs("properties(Map)").properties(properties);
    }

    @Override
    public boolean getHasSourceFiles() {
        return this.getTaskInputs("getHasSourceFiles()").getHasSourceFiles();
    }

    @Override
    public FileCollection getSourceFiles() {
        return this.getTaskInputs("getSourceFiles()").getSourceFiles();
    }

    @Override
    @Deprecated
    public TaskInputs source(Object ... paths) {
        return this.getTaskInputs("source(Object...)").source(paths);
    }

    @Override
    @Deprecated
    public TaskInputs source(Object path) {
        return this.getTaskInputs("source(Object)").source(path);
    }

    @Override
    @Deprecated
    public TaskInputs sourceDir(Object path) {
        return this.getTaskInputs("sourceDir(Object)").sourceDir(path);
    }

    @Override
    public int compareTo(TaskPropertySpec o) {
        return this.getPropertyName().compareTo(o.getPropertyName());
    }
}

