/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.AbstractModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ArtifactExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ExcludeAllModulesSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ExcludeNone;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.GroupNameExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.IntersectionExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.IvyPatternMatcherExcludeRuleSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleExclusion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleIdExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.ModuleNameExcludeSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.PatternMatchers;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.excludes.UnionExclusion;
import org.gradle.internal.component.model.Exclude;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.util.CollectionUtils;

public class ModuleExclusions {
    private static final ExcludeNone EXCLUDE_NONE = new ExcludeNone();
    private static final ExcludeAllModulesSpec EXCLUDE_ALL_MODULES_SPEC = new ExcludeAllModulesSpec();

    public static ModuleExclusion excludeNone() {
        return EXCLUDE_NONE;
    }

    public static ModuleExclusion excludeAny(Exclude ... excludes) {
        if (excludes.length == 0) {
            return EXCLUDE_NONE;
        }
        return ModuleExclusions.excludeAny(Arrays.asList(excludes));
    }

    public static ModuleExclusion excludeAny(Collection<Exclude> excludes) {
        if (excludes.isEmpty()) {
            return EXCLUDE_NONE;
        }
        return new IntersectionExclusion(CollectionUtils.collect(excludes, (Transformer)new Transformer<AbstractModuleExclusion, Exclude>(){

            public AbstractModuleExclusion transform(Exclude exclude) {
                return ModuleExclusions.forExclude(exclude);
            }
        }));
    }

    private static AbstractModuleExclusion forExclude(Exclude rule) {
        boolean anyArtifact;
        if (!PatternMatchers.isExactMatcher(rule.getMatcher())) {
            return new IvyPatternMatcherExcludeRuleSpec(rule);
        }
        ModuleIdentifier moduleId = rule.getModuleId();
        IvyArtifactName artifact = rule.getArtifact();
        boolean anyOrganisation = AbstractModuleExclusion.isWildcard(moduleId.getGroup());
        boolean anyModule = AbstractModuleExclusion.isWildcard(moduleId.getName());
        boolean bl = anyArtifact = AbstractModuleExclusion.isWildcard(artifact.getName()) && AbstractModuleExclusion.isWildcard(artifact.getType()) && AbstractModuleExclusion.isWildcard(artifact.getExtension());
        if (anyArtifact) {
            if (!anyOrganisation && !anyModule) {
                return new ModuleIdExcludeSpec(moduleId.getGroup(), moduleId.getName());
            }
            if (!anyModule) {
                return new ModuleNameExcludeSpec(moduleId.getName());
            }
            if (!anyOrganisation) {
                return new GroupNameExcludeSpec(moduleId.getGroup());
            }
            return EXCLUDE_ALL_MODULES_SPEC;
        }
        return new ArtifactExcludeSpec(moduleId, artifact);
    }

    public static ModuleExclusion intersect(ModuleExclusion one, ModuleExclusion two) {
        if (one == two) {
            return one;
        }
        if (one == EXCLUDE_NONE) {
            return two;
        }
        if (two == EXCLUDE_NONE) {
            return one;
        }
        if (one.equals(two)) {
            return one;
        }
        ArrayList<AbstractModuleExclusion> specs = new ArrayList<AbstractModuleExclusion>();
        ((AbstractModuleExclusion)one).unpackIntersection(specs);
        ((AbstractModuleExclusion)two).unpackIntersection(specs);
        return new IntersectionExclusion(specs);
    }

    public static ModuleExclusion union(ModuleExclusion one, ModuleExclusion two) {
        if (one == two) {
            return one;
        }
        if (one == EXCLUDE_NONE || two == EXCLUDE_NONE) {
            return EXCLUDE_NONE;
        }
        if (one.equals(two)) {
            return one;
        }
        ArrayList<AbstractModuleExclusion> specs = new ArrayList<AbstractModuleExclusion>();
        ((AbstractModuleExclusion)one).unpackUnion(specs);
        ((AbstractModuleExclusion)two).unpackUnion(specs);
        int i = 0;
        while (i < specs.size()) {
            AbstractModuleExclusion spec = (AbstractModuleExclusion)specs.get(i);
            AbstractModuleExclusion merged = null;
            for (int j = i + 1; j < specs.size(); ++j) {
                merged = ModuleExclusions.maybeMergeIntoUnion(spec, (ModuleExclusion)specs.get(j));
                if (merged == null) continue;
                specs.remove(j);
                break;
            }
            if (merged != null) {
                specs.set(i, merged);
                continue;
            }
            ++i;
        }
        if (specs.size() == 1) {
            return (ModuleExclusion)specs.get(0);
        }
        return new UnionExclusion(specs);
    }

    private static AbstractModuleExclusion maybeMergeIntoUnion(ModuleExclusion one, ModuleExclusion two) {
        if (one instanceof IntersectionExclusion && two instanceof IntersectionExclusion) {
            return ModuleExclusions.maybeMergeIntoUnion((IntersectionExclusion)one, (IntersectionExclusion)two);
        }
        return null;
    }

    private static AbstractModuleExclusion maybeMergeIntoUnion(IntersectionExclusion one, IntersectionExclusion other) {
        if (one.getFilters().equals(other.getFilters())) {
            return one;
        }
        for (AbstractModuleExclusion excludeSpec : one.getFilters()) {
            if (ModuleExclusions.canMerge(excludeSpec)) continue;
            return null;
        }
        for (AbstractModuleExclusion excludeSpec : other.getFilters()) {
            if (ModuleExclusions.canMerge(excludeSpec)) continue;
            return null;
        }
        ArrayList<AbstractModuleExclusion> merged = new ArrayList<AbstractModuleExclusion>();
        for (AbstractModuleExclusion thisSpec : one.getFilters()) {
            for (AbstractModuleExclusion otherSpec : other.getFilters()) {
                ModuleExclusions.mergeExcludeRules(thisSpec, otherSpec, merged);
            }
        }
        if (merged.isEmpty()) {
            return EXCLUDE_NONE;
        }
        return new IntersectionExclusion(merged);
    }

    private static boolean canMerge(AbstractModuleExclusion excludeSpec) {
        return excludeSpec instanceof ExcludeAllModulesSpec || excludeSpec instanceof ArtifactExcludeSpec || excludeSpec instanceof GroupNameExcludeSpec || excludeSpec instanceof ModuleNameExcludeSpec || excludeSpec instanceof ModuleIdExcludeSpec;
    }

    private static void mergeExcludeRules(AbstractModuleExclusion spec1, AbstractModuleExclusion spec2, List<AbstractModuleExclusion> merged) {
        if (spec1 instanceof ExcludeAllModulesSpec) {
            merged.add(spec2);
        } else if (spec2 instanceof ExcludeAllModulesSpec) {
            merged.add(spec1);
        } else if (spec1 instanceof ArtifactExcludeSpec) {
            merged.add(spec1);
        } else if (spec2 instanceof ArtifactExcludeSpec) {
            merged.add(spec2);
        } else if (spec1 instanceof GroupNameExcludeSpec) {
            ModuleExclusions.mergeExcludeRules((GroupNameExcludeSpec)spec1, spec2, merged);
        } else if (spec2 instanceof GroupNameExcludeSpec) {
            ModuleExclusions.mergeExcludeRules((GroupNameExcludeSpec)spec2, spec1, merged);
        } else if (spec1 instanceof ModuleNameExcludeSpec) {
            ModuleExclusions.mergeExcludeRules((ModuleNameExcludeSpec)spec1, spec2, merged);
        } else if (spec2 instanceof ModuleNameExcludeSpec) {
            ModuleExclusions.mergeExcludeRules((ModuleNameExcludeSpec)spec2, spec1, merged);
        } else if (spec1 instanceof ModuleIdExcludeSpec && spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleSpec1 = (ModuleIdExcludeSpec)spec1;
            ModuleIdExcludeSpec moduleSpec2 = (ModuleIdExcludeSpec)spec2;
            if (moduleSpec1.moduleId.equals(moduleSpec2.moduleId)) {
                merged.add(moduleSpec1);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }

    private static void mergeExcludeRules(GroupNameExcludeSpec spec1, AbstractModuleExclusion spec2, List<AbstractModuleExclusion> merged) {
        if (spec2 instanceof GroupNameExcludeSpec) {
            GroupNameExcludeSpec groupNameExcludeSpec = (GroupNameExcludeSpec)spec2;
            if (spec1.group.equals(groupNameExcludeSpec.group)) {
                merged.add(spec1);
            }
        } else if (spec2 instanceof ModuleNameExcludeSpec) {
            ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)spec2;
            merged.add(new ModuleIdExcludeSpec(spec1.group, moduleNameExcludeSpec.module));
        } else if (spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)spec2;
            if (moduleIdExcludeSpec.moduleId.getGroup().equals(spec1.group)) {
                merged.add(spec2);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }

    private static void mergeExcludeRules(ModuleNameExcludeSpec spec1, AbstractModuleExclusion spec2, List<AbstractModuleExclusion> merged) {
        if (spec2 instanceof ModuleNameExcludeSpec) {
            ModuleNameExcludeSpec moduleNameExcludeSpec = (ModuleNameExcludeSpec)spec2;
            if (spec1.module.equals(moduleNameExcludeSpec.module)) {
                merged.add(spec1);
            }
        } else if (spec2 instanceof ModuleIdExcludeSpec) {
            ModuleIdExcludeSpec moduleIdExcludeSpec = (ModuleIdExcludeSpec)spec2;
            if (moduleIdExcludeSpec.moduleId.getName().equals(spec1.module)) {
                merged.add(spec2);
            }
        } else {
            throw new UnsupportedOperationException(String.format("Cannot calculate intersection of exclude rules: %s, %s", spec1, spec2));
        }
    }
}

