/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.runner.internal;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.output.TeeOutputStream;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.testkit.runner.BuildTask;
import org.gradle.testkit.runner.TaskOutcome;
import org.gradle.testkit.runner.UnsupportedFeatureException;
import org.gradle.testkit.runner.internal.BuildOperationParameters;
import org.gradle.testkit.runner.internal.DefaultBuildTask;
import org.gradle.testkit.runner.internal.GradleExecutionParameters;
import org.gradle.testkit.runner.internal.GradleExecutionResult;
import org.gradle.testkit.runner.internal.GradleExecutor;
import org.gradle.testkit.runner.internal.GradleProvider;
import org.gradle.testkit.runner.internal.feature.TestKitFeature;
import org.gradle.testkit.runner.internal.io.NoCloseOutputStream;
import org.gradle.testkit.runner.internal.io.SynchronizedOutputStream;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.ProgressListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskProgressEvent;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskStartEvent;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.gradle.tooling.internal.consumer.DefaultBuildLauncher;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.GradleUserHomeLookup;

public class ToolingApiGradleExecutor
implements GradleExecutor {
    public static final String TEST_KIT_DAEMON_DIR_NAME = "test-kit-daemon";
    private static final String CLEANUP_THREAD_NAME = "gradle-runner-cleanup";
    private static final AtomicBoolean SHUTDOWN_REGISTERED = new AtomicBoolean();

    private static void maybeRegisterCleanup() {
        if (SHUTDOWN_REGISTERED.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultGradleConnector.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }, CLEANUP_THREAD_NAME));
        }
    }

    @Override
    public GradleExecutionResult run(GradleExecutionParameters parameters) {
        StreamByteBuffer outputBuffer = new StreamByteBuffer();
        SynchronizedOutputStream syncOutput = new SynchronizedOutputStream(outputBuffer.getOutputStream());
        ArrayList<BuildTask> tasks = new ArrayList<BuildTask>();
        ToolingApiGradleExecutor.maybeRegisterCleanup();
        GradleConnector gradleConnector = this.buildConnector(parameters.getGradleUserHome(), parameters.getProjectDir(), parameters.isEmbedded(), parameters.getGradleProvider());
        GradleVersion targetGradleVersion = null;
        try (ProjectConnection connection = null;){
            connection = gradleConnector.connect();
            targetGradleVersion = this.determineTargetGradleVersion(connection);
            if (targetGradleVersion.compareTo(TestKitFeature.RUN_BUILDS.getSince()) < 0) {
                throw new UnsupportedFeatureException(String.format("The version of Gradle you are using (%s) is not supported by TestKit. TestKit supports all Gradle versions 1.2 and later.", targetGradleVersion.getVersion()));
            }
            DefaultBuildLauncher launcher = (DefaultBuildLauncher)connection.newBuild();
            launcher.setStandardOutput((OutputStream)new NoCloseOutputStream(ToolingApiGradleExecutor.teeOutput(syncOutput, parameters.getStandardOutput())));
            launcher.setStandardError((OutputStream)new NoCloseOutputStream(ToolingApiGradleExecutor.teeOutput(syncOutput, parameters.getStandardError())));
            launcher.addProgressListener((ProgressListener)new TaskExecutionProgressListener(tasks), new OperationType[]{OperationType.TASK});
            launcher.withArguments(parameters.getBuildArgs().toArray(new String[0]));
            launcher.setJvmArguments(parameters.getJvmArgs().toArray(new String[0]));
            if (!parameters.getInjectedClassPath().isEmpty()) {
                if (targetGradleVersion.compareTo(TestKitFeature.PLUGIN_CLASSPATH_INJECTION.getSince()) < 0) {
                    throw new UnsupportedFeatureException("support plugin classpath injection", targetGradleVersion, TestKitFeature.PLUGIN_CLASSPATH_INJECTION.getSince());
                }
                launcher.withInjectedClassPath(parameters.getInjectedClassPath());
            }
            launcher.run();
        }
        return new GradleExecutionResult(new BuildOperationParameters(targetGradleVersion, parameters.isEmbedded()), outputBuffer.readAsString(), tasks);
    }

    private GradleVersion determineTargetGradleVersion(ProjectConnection connection) {
        BuildEnvironment buildEnvironment = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        return GradleVersion.version((String)buildEnvironment.getGradle().getGradleVersion());
    }

    private static OutputStream teeOutput(OutputStream capture, OutputStream user) {
        if (user == null) {
            return capture;
        }
        return new TeeOutputStream(capture, user);
    }

    private GradleConnector buildConnector(File gradleUserHome, File projectDir, boolean embedded, GradleProvider gradleProvider) {
        DefaultGradleConnector gradleConnector = (DefaultGradleConnector)GradleConnector.newConnector();
        gradleConnector.useDistributionBaseDir(GradleUserHomeLookup.gradleUserHome());
        gradleProvider.applyTo((GradleConnector)gradleConnector);
        gradleConnector.useGradleUserHomeDir(gradleUserHome);
        gradleConnector.daemonBaseDir(new File(gradleUserHome, TEST_KIT_DAEMON_DIR_NAME));
        gradleConnector.forProjectDirectory(projectDir);
        gradleConnector.searchUpwards(false);
        gradleConnector.daemonMaxIdleTime(120, TimeUnit.SECONDS);
        gradleConnector.embedded(embedded);
        return gradleConnector;
    }

    private class TaskExecutionProgressListener
    implements ProgressListener {
        private final List<BuildTask> tasks;
        private final Map<String, Integer> order = new HashMap<String, Integer>();

        public TaskExecutionProgressListener(List<BuildTask> tasks) {
            this.tasks = tasks;
        }

        public void statusChanged(ProgressEvent event) {
            if (event instanceof TaskStartEvent) {
                TaskStartEvent taskStartEvent = (TaskStartEvent)event;
                if (!this.accept((TaskProgressEvent)taskStartEvent)) {
                    return;
                }
                this.order.put(taskStartEvent.getDescriptor().getTaskPath(), this.tasks.size());
                this.tasks.add(null);
            }
            if (event instanceof TaskFinishEvent) {
                TaskFinishEvent taskFinishEvent = (TaskFinishEvent)event;
                if (!this.accept((TaskProgressEvent)taskFinishEvent)) {
                    return;
                }
                String taskPath = taskFinishEvent.getDescriptor().getTaskPath();
                TaskOperationResult result = taskFinishEvent.getResult();
                Integer index = this.order.get(taskPath);
                if (index == null) {
                    throw new IllegalStateException("Received task finish event for task " + taskPath + " without first receiving task start event");
                }
                this.tasks.set(index, this.determineBuildTask(result, taskPath));
            }
        }

        private boolean accept(TaskProgressEvent event) {
            return !event.getDescriptor().getTaskPath().startsWith(":buildSrc");
        }

        private BuildTask determineBuildTask(TaskOperationResult result, String taskPath) {
            if (this.isFailed(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.FAILED);
            }
            if (this.isSkipped(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.SKIPPED);
            }
            if (this.isFromCache(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.FROM_CACHE);
            }
            if (this.isUpToDate(result)) {
                return this.createBuildTask(taskPath, TaskOutcome.UP_TO_DATE);
            }
            return this.createBuildTask(taskPath, TaskOutcome.SUCCESS);
        }

        private BuildTask createBuildTask(String taskPath, TaskOutcome outcome) {
            return new DefaultBuildTask(taskPath, outcome);
        }

        private boolean isFailed(TaskOperationResult result) {
            return result instanceof TaskFailureResult;
        }

        private boolean isSkipped(TaskOperationResult result) {
            return result instanceof TaskSkippedResult;
        }

        private boolean isUpToDate(TaskOperationResult result) {
            return result instanceof TaskSuccessResult && ((TaskSuccessResult)result).isUpToDate();
        }

        private boolean isFromCache(TaskOperationResult result) {
            return result instanceof TaskSuccessResult && ((TaskSuccessResult)result).isFromCache();
        }
    }
}

