/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.NotNullLazyValue;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;

public class StandardFileSystems {
    public static final String FILE_PROTOCOL = "file";
    public static final String FILE_PROTOCOL_PREFIX = "file://";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_PROTOCOL_PREFIX = "jar://";
    public static final String JRT_PROTOCOL = "jrt";
    private static final NotNullLazyValue<VirtualFileSystem> ourLocal = new NotNullLazyValue<VirtualFileSystem>(){

        @Override
        @NotNull
        protected VirtualFileSystem compute() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.FILE_PROTOCOL);
            if (virtualFileSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/StandardFileSystems$1", "compute"));
            }
            return virtualFileSystem;
        }
    };
    private static final NotNullLazyValue<VirtualFileSystem> ourJar = new NotNullLazyValue<VirtualFileSystem>(){

        @Override
        @NotNull
        protected VirtualFileSystem compute() {
            VirtualFileSystem virtualFileSystem = VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.JAR_PROTOCOL);
            if (virtualFileSystem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/vfs/StandardFileSystems$2", "compute"));
            }
            return virtualFileSystem;
        }
    };

    public static VirtualFileSystem local() {
        return ourLocal.getValue();
    }

    public static VirtualFileSystem jar() {
        return ourJar.getValue();
    }

    @Nullable
    public static VirtualFile getJarRootForLocalFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/kotlin/com/intellij/openapi/vfs/StandardFileSystems", "getJarRootForLocalFile"));
        }
        return StandardFileSystems.jar().findFileByPath(virtualFile.getPath() + "!/");
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path = entryVFile.getPath();
        int separatorIndex = path.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path.substring(0, separatorIndex);
        return StandardFileSystems.local().findFileByPath(localPath);
    }
}

