/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiErrorElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.TokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositePsiElement;
import org.jetbrains.kotlin.com.intellij.psi.templateLanguages.OuterLanguageElement;

public class PsiErrorElementImpl
extends CompositePsiElement
implements PsiErrorElement {
    private final String myErrorDescription;

    public PsiErrorElementImpl(String errorDescription) {
        super(TokenType.ERROR_ELEMENT);
        this.myErrorDescription = errorDescription;
    }

    @Override
    public String getErrorDescription() {
        return this.myErrorDescription;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/PsiErrorElementImpl", "accept"));
        }
        visitor2.visitErrorElement(this);
    }

    @Override
    public String toString() {
        return "PsiErrorElement:" + this.getErrorDescription();
    }

    @Override
    @NotNull
    public Language getLanguage() {
        PsiElement master = this;
        do {
            if ((master = master.getNextSibling()) != null && !(master instanceof OuterLanguageElement)) continue;
            Language language = this.getParent().getLanguage();
            if (language == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/PsiErrorElementImpl", "getLanguage"));
            }
            return language;
        } while (master instanceof PsiWhiteSpace || master instanceof PsiErrorElement);
        Language language = master.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/source/tree/PsiErrorElementImpl", "getLanguage"));
        }
        return language;
    }
}

