/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.CandidateResolver;
import org.jetbrains.kotlin.resolve.calls.GenericCandidateResolverKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemStatus;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariableKt;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.FakeCallResolver;

@Metadata(mv={1, 1, 2}, bv={1, 0, 1}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J(\u0010\u0012\u001a\u00020\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019H\u0002J(\u0010\u001a\u001a\u00020\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019H\u0002J4\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0019\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u001e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J@\u0010$\u001a\u00020\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u000e\u0010%\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010&2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010)\u001a\u00020*H\u0002J(\u0010+\u001a\u00020\u0013\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u00140,H\u0002J6\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010.2\b\u00100\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u00020 2\u0006\u00102\u001a\u0002032\u0006\u0010)\u001a\u00020*H\u0002J,\u00104\u001a\u00020\u0013\"\b\b\u0000\u0010\u0014*\u00020\u0015*\b\u0012\u0004\u0012\u0002H\u00140&2\u0006\u00105\u001a\u00020.2\u0006\u0010)\u001a\u00020*H\u0002J,\u00106\u001a\u00020\u0013\"\b\b\u0000\u0010\u0014*\u00020\u0015*\b\u0012\u0004\u0012\u0002H\u00140&2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "candidateResolver", "Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "callCheckers", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "fakeCallResolver", "Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/CandidateResolver;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/types/expressions/FakeCallResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "completeAllCandidates", "", "D", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "results", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "completeArguments", "completeCall", "tracing", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "completeCallForArgument", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "completeOneArgument", "valueArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "completeResolvedCallAndArguments", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/MutableResolvedCall;", "hasNecessarySafeCall", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "resolveHandleResultCallForCoroutineLambdaExpressions", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "updateRecordedTypeForArgument", "Lorg/jetbrains/kotlin/types/KotlinType;", "updatedType", "recordedType", "argumentExpression", "statementFilter", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "completeConstraintSystem", "expectedType", "updateResolutionStatusFromConstraintSystem", "kotlin-compiler"})
public final class CallCompleter {
    private final ArgumentTypeResolver argumentTypeResolver;
    private final CandidateResolver candidateResolver;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private final Iterable<CallChecker> callCheckers;
    private final KotlinBuiltIns builtIns;
    private final FakeCallResolver fakeCallResolver;
    private final LanguageVersionSettings languageVersionSettings;

    @NotNull
    public final <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> completeCall(@NotNull BasicCallResolutionContext context, @NotNull OverloadResolutionResultsImpl<D> results, @NotNull TracingStrategy tracing) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(results, "results");
        Intrinsics.checkParameterIsNotNull(tracing, "tracing");
        ResolvedCall resolvedCall2 = results.isSingleResult() ? results.getResultingCall() : (MutableResolvedCall)null;
        Call call = context.call;
        Intrinsics.checkExpressionValueIsNotNull(call, "context.call");
        if (!CallResolverUtilKt.isInvokeCallOnVariable(call)) {
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a resulting call");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)context.replaceBindingTrace(temporaryTrace);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "context.replaceBindingTrace(temporaryTrace)");
            this.completeResolvedCallAndArguments((MutableResolvedCall<D>)resolvedCall2, results, basicCallResolutionContext, tracing);
            this.completeAllCandidates(context, results);
            temporaryTrace.commit();
        }
        if (resolvedCall2 != null) {
            KtElement reportOn;
            KtExpression calleeExpression = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCall().getCalleeExpression() : resolvedCall2.getCall().getCalleeExpression();
            KtElement ktElement = reportOn = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : resolvedCall2.getCall().getCallElement();
            if (context.trace.wantsDiagnostics()) {
                CallCheckerContext callCheckerContext = new CallCheckerContext(context, this.languageVersionSettings);
                for (CallChecker callChecker : this.callCheckers) {
                    PsiElement psiElement = reportOn;
                    Intrinsics.checkExpressionValueIsNotNull(psiElement, "reportOn");
                    callChecker.check(resolvedCall2, psiElement, callCheckerContext);
                }
            }
            this.resolveHandleResultCallForCoroutineLambdaExpressions(context, resolvedCall2);
        }
        if (results.isSingleResult() && results.getResultingCall().getStatus().isSuccess()) {
            OverloadResolutionResultsImpl<D> overloadResolutionResultsImpl = results.changeStatusToSuccess();
            Intrinsics.checkExpressionValueIsNotNull(overloadResolutionResultsImpl, "results.changeStatusToSuccess()");
            return overloadResolutionResultsImpl;
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void resolveHandleResultCallForCoroutineLambdaExpressions(BasicCallResolutionContext context, ResolvedCall<D> resolvedCall2) {
        Collection destination$iv$iv;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv = resolvedCall2.getValueArguments().values();
        Iterable iterable = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void destination$iv$iv2;
            void $receiver$iv$iv2;
            void $receiver$iv2;
            ResolvedValueArgument it = (ResolvedValueArgument)element$iv$iv;
            Iterable iterable2 = it.getArguments();
            void var10_10 = $receiver$iv2;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv2, 10));
            for (Object item$iv$iv : $receiver$iv$iv2) {
                void it2;
                ValueArgument valueArgument = (ValueArgument)item$iv$iv;
                void var15_15 = destination$iv$iv2;
                KtExpression ktExpression = it2.getArgumentExpression();
                var15_15.add(ktExpression);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtLambdaExpression)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            KtExpression lastBlockStatement;
            SimpleFunctionDescriptor function2;
            KtLambdaExpression it = (KtLambdaExpression)element$iv;
            if ((SimpleFunctionDescriptor)context.trace.getBindingContext().get(BindingContext.FUNCTION, it.getFunctionLiteral()) == null) {
                continue;
            }
            if (CoroutineUtilKt.getControllerTypeIfCoroutine(function2) == null) {
                continue;
            }
            Object object = it.getFunctionLiteral().getBodyExpression();
            KtExpression ktExpression = object != null && (object = ((KtBlockExpression)object).getStatements()) != null ? (KtExpression)CollectionsKt.lastOrNull(object) : (lastBlockStatement = null);
            if (lastBlockStatement instanceof KtReturnExpression) continue;
            KtExpression ktExpression2 = it.getFunctionLiteral();
            Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "it.functionLiteral");
            FunctionDescriptor functionDescriptor = function2;
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "function");
            CoroutineUtilKt.resolveCoroutineHandleResultCallIfNeeded(this.fakeCallResolver, ktExpression2, lastBlockStatement, functionDescriptor, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeAllCandidates(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Collection<ResolvedCall<D>> collection;
        if (context.collectAllCandidates) {
            Collection<ResolvedCall<D>> collection2 = results.getAllCandidates();
            if (collection2 == null) {
                Intrinsics.throwNpe();
            }
            collection = collection2;
            Intrinsics.checkExpressionValueIsNotNull(collection2, "results.allCandidates!!");
        } else {
            Collection<MutableResolvedCall<D>> collection3 = results.getResultingCalls();
            collection = collection3;
            Intrinsics.checkExpressionValueIsNotNull(collection3, "results.resultingCalls");
        }
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall<D>>");
        }
        Collection<ResolvedCall<D>> candidates = collection;
        Iterable iterable = candidates;
        Iterator iterator2 = $receiver$iv;
        Collection collection4 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            MutableResolvedCall resolvedCall2 = (MutableResolvedCall)element$iv$iv;
            if (resolvedCall2.isCompleted()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            MutableResolvedCall resolvedCall3 = (MutableResolvedCall)element$iv;
            TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(context.trace, "Trace to complete a candidate that is not a resulting call");
            BasicCallResolutionContext basicCallResolutionContext = (BasicCallResolutionContext)context.replaceBindingTrace(temporaryBindingTrace);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "context.replaceBindingTrace(temporaryBindingTrace)");
            TracingStrategy tracingStrategy = TracingStrategy.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull(tracingStrategy, "TracingStrategy.EMPTY");
            this.completeResolvedCallAndArguments(resolvedCall3, results, basicCallResolutionContext, tracingStrategy);
        }
    }

    private final <D extends CallableDescriptor> void completeResolvedCallAndArguments(MutableResolvedCall<D> resolvedCall2, OverloadResolutionResultsImpl<D> results, BasicCallResolutionContext context, TracingStrategy tracing) {
        if (resolvedCall2 == null || resolvedCall2.isCompleted() || resolvedCall2.getConstraintSystem() == null) {
            this.completeArguments(context, results);
            MutableResolvedCall<D> mutableResolvedCall = resolvedCall2;
            if (mutableResolvedCall != null) {
                mutableResolvedCall.markCallAsCompleted();
            }
            return;
        }
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        this.completeConstraintSystem(resolvedCall2, kotlinType, bindingTrace);
        this.completeArguments(context, results);
        this.updateResolutionStatusFromConstraintSystem(resolvedCall2, context, tracing);
        resolvedCall2.markCallAsCompleted();
    }

    private final <D extends CallableDescriptor> void completeConstraintSystem(@NotNull MutableResolvedCall<D> $receiver, KotlinType expectedType, BindingTrace trace) {
        ConstraintSystemCompleter constraintSystemCompleter;
        KotlinType kotlinType;
        KotlinType returnType = $receiver.getCandidateDescriptor().getReturnType();
        if (CallUtilKt.isCallableReference($receiver.getCall())) {
            if (!TypeUtils.noExpectedType(expectedType) && FunctionTypesKt.isFunctionType(expectedType)) {
                kotlinType = FunctionTypesKt.getReturnTypeFromFunctionType(expectedType);
            } else {
                KotlinType kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
                kotlinType = kotlinType2;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.NO_EXPECTED_TYPE");
            }
        } else {
            kotlinType = expectedType;
        }
        KotlinType expectedReturnType = kotlinType;
        Function1<ConstraintSystem.Builder, KotlinType> returnTypeInSystem$ = new Function1<ConstraintSystem.Builder, KotlinType>($receiver, returnType){
            final /* synthetic */ MutableResolvedCall receiver$0;
            final /* synthetic */ KotlinType $returnType;

            @Nullable
            public final KotlinType invoke(@NotNull ConstraintSystem.Builder $receiver) {
                KotlinType kotlinType;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                KotlinType kotlinType2 = this.$returnType;
                if (kotlinType2 != null) {
                    KotlinType kotlinType3 = kotlinType2;
                    KotlinType it = kotlinType3;
                    TypeSubstitutor typeSubstitutor2 = $receiver.getTypeVariableSubstitutors().get(TypeVariableKt.toHandle(this.receiver$0.getCall()));
                    if (typeSubstitutor2 == null) {
                        String string = "No substitutor for call: " + this.receiver$0.getCall();
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    TypeSubstitutor substitutor2 = typeSubstitutor2;
                    kotlinType = substitutor2.substitute(it, Variance.INVARIANT);
                } else {
                    kotlinType = null;
                }
                return kotlinType;
            }
            {
                this.receiver$0 = mutableResolvedCall;
                this.$returnType = kotlinType;
                super(1);
            }
        };
        Function1<Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>, Unit> updateSystemIfNeeded$ = new Function1<Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>, Unit>($receiver){
            final /* synthetic */ MutableResolvedCall receiver$0;

            public final void invoke(@NotNull Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem> buildSystemWithAdditionalConstraints) {
                ConstraintSystem system;
                Intrinsics.checkParameterIsNotNull(buildSystemWithAdditionalConstraints, "buildSystemWithAdditionalConstraints");
                ConstraintSystem constraintSystem = this.receiver$0.getConstraintSystem();
                if (constraintSystem == null) {
                    Intrinsics.throwNpe();
                }
                if ((system = buildSystemWithAdditionalConstraints.invoke(ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem, null, 1, null))) != null) {
                    this.receiver$0.setConstraintSystem(system);
                }
            }
            {
                this.receiver$0 = mutableResolvedCall;
                super(1);
            }
        };
        if (returnType != null && !TypeUtils.noExpectedType(expectedReturnType)) {
            updateSystemIfNeeded$.invoke((Function1<ConstraintSystem.Builder, ConstraintSystem>)((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>(returnTypeInSystem$, expectedReturnType){
                final /* synthetic */ completeConstraintSystem.1 $returnTypeInSystem;
                final /* synthetic */ KotlinType $expectedReturnType;

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkParameterIsNotNull(builder, "builder");
                    KotlinType returnTypeInSystem = this.$returnTypeInSystem.invoke(builder);
                    if (returnTypeInSystem != null) {
                        builder.addSubtypeConstraint(returnTypeInSystem, this.$expectedReturnType, ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        constraintSystem = builder.build();
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
                {
                    this.$returnTypeInSystem = var1_1;
                    this.$expectedReturnType = kotlinType;
                    super(1);
                }
            }));
        }
        if ((constraintSystemCompleter = (ConstraintSystemCompleter)trace.get(BindingContext.CONSTRAINT_SYSTEM_COMPLETER, $receiver.getCall().getCalleeExpression())) != null) {
            updateSystemIfNeeded$.invoke((Function1<ConstraintSystem.Builder, ConstraintSystem>)((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>($receiver, constraintSystemCompleter){
                final /* synthetic */ MutableResolvedCall receiver$0;
                final /* synthetic */ ConstraintSystemCompleter $constraintSystemCompleter;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    void var2_2;
                    Intrinsics.checkParameterIsNotNull(builder, "builder");
                    this.$constraintSystemCompleter.completeConstraintSystem(builder, this.receiver$0);
                    ConstraintSystem system = builder.build();
                    ConstraintSystemStatus status2 = ConstraintSystemUtilsKt.filterConstraintsOut(system, ConstraintPositionKind.TYPE_BOUND_POSITION).getStatus();
                    return status2.hasOnlyErrorsDerivedFrom(ConstraintPositionKind.FROM_COMPLETER) ? (ConstraintSystem)null : var2_2;
                }
                {
                    this.receiver$0 = mutableResolvedCall;
                    this.$constraintSystemCompleter = constraintSystemCompleter;
                    super(1);
                }
            }));
        }
        if (returnType != null && expectedReturnType == TypeUtils.UNIT_EXPECTED_TYPE) {
            updateSystemIfNeeded$.invoke((Function1<ConstraintSystem.Builder, ConstraintSystem>)((Function1<? super ConstraintSystem.Builder, ? extends ConstraintSystem>)new Function1<ConstraintSystem.Builder, ConstraintSystem>(this, returnTypeInSystem$){
                final /* synthetic */ CallCompleter this$0;
                final /* synthetic */ completeConstraintSystem.1 $returnTypeInSystem;

                @Nullable
                public final ConstraintSystem invoke(@NotNull ConstraintSystem.Builder builder) {
                    ConstraintSystem constraintSystem;
                    Intrinsics.checkParameterIsNotNull(builder, "builder");
                    KotlinType returnTypeInSystem = this.$returnTypeInSystem.invoke(builder);
                    if (returnTypeInSystem != null) {
                        builder.addSubtypeConstraint(returnTypeInSystem, CallCompleter.access$getBuiltIns$p(this.this$0).getUnitType(), ConstraintPositionKind.EXPECTED_TYPE_POSITION.position());
                        ConstraintSystem system = builder.build();
                        constraintSystem = system.getStatus().isSuccessful() ? system : (ConstraintSystem)null;
                    } else {
                        constraintSystem = null;
                    }
                    return constraintSystem;
                }
                {
                    this.this$0 = callCompleter;
                    this.$returnTypeInSystem = var2_2;
                    super(1);
                }
            }));
        }
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        ConstraintSystem.Builder builder = ConstraintSystem.DefaultImpls.toBuilder$default(constraintSystem, null, 1, null);
        builder.fixVariables();
        ConstraintSystem system = builder.build();
        $receiver.setConstraintSystem(system);
        $receiver.setResultingSubstitutor(system.getResultingSubstitutor());
    }

    private final <D extends CallableDescriptor> void updateResolutionStatusFromConstraintSystem(@NotNull MutableResolvedCall<D> $receiver, BasicCallResolutionContext context, TracingStrategy tracing) {
        CallCandidateResolutionContext<D> contextWithResolvedCall;
        CallCandidateResolutionContext<D> callCandidateResolutionContext = contextWithResolvedCall = CallCandidateResolutionContext.createForCallBeingAnalyzed($receiver, context, tracing);
        Intrinsics.checkExpressionValueIsNotNull(callCandidateResolutionContext, "contextWithResolvedCall");
        CandidateResolver.ValueArgumentsCheckingResult valueArgumentsCheckingResult = this.candidateResolver.checkAllValueArguments(callCandidateResolutionContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        ResolutionStatus status2 = $receiver.getStatus();
        ConstraintSystem constraintSystem = $receiver.getConstraintSystem();
        if (constraintSystem == null) {
            Intrinsics.throwNpe();
        }
        if (constraintSystem.getStatus().isSuccessful()) {
            if (Intrinsics.areEqual((Object)status2, (Object)ResolutionStatus.UNKNOWN_STATUS) || Intrinsics.areEqual((Object)status2, (Object)ResolutionStatus.INCOMPLETE_TYPE_INFERENCE)) {
                $receiver.setStatusToSuccess();
            }
            return;
        }
        ReceiverValue receiverValue = $receiver.getExtensionReceiver();
        KotlinType receiverType = receiverValue != null ? receiverValue.getType() : null;
        Object d = $receiver.getCandidateDescriptor();
        ConstraintSystem constraintSystem2 = $receiver.getConstraintSystem();
        if (constraintSystem2 == null) {
            Intrinsics.throwNpe();
        }
        InferenceErrorData errorData = InferenceErrorData.create(d, constraintSystem2, valueArgumentsCheckingResult.getArgumentTypes(), receiverType, context.expectedType, context.call);
        tracing.typeInferenceFailed(context, errorData);
        $receiver.addStatus(ResolutionStatus.OTHER_ERROR);
    }

    /*
     * WARNING - void declaration
     */
    private final <D extends CallableDescriptor> void completeArguments(BasicCallResolutionContext context, OverloadResolutionResultsImpl<D> results) {
        Function1 getDataFlowInfoForArgument;
        Function1 getArgumentMapping;
        if (Intrinsics.areEqual((Object)context.checkArguments, (Object)CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) ^ true) {
            return;
        }
        if (results.isSingleResult()) {
            ResolvedCall resolvedCall2 = results.getResultingCall();
            getArgumentMapping = new Function1<ValueArgument, ArgumentMapping>((MutableResolvedCall)resolvedCall2){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final ArgumentMapping invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull(argument, "argument");
                    ArgumentMapping argumentMapping = this.$resolvedCall.getArgumentMapping(argument);
                    Intrinsics.checkExpressionValueIsNotNull(argumentMapping, "resolvedCall.getArgumentMapping(argument)");
                    return argumentMapping;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
            getDataFlowInfoForArgument = new Function1<ValueArgument, DataFlowInfo>((MutableResolvedCall)resolvedCall2){
                final /* synthetic */ MutableResolvedCall $resolvedCall;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument argument) {
                    Intrinsics.checkParameterIsNotNull(argument, "argument");
                    DataFlowInfo dataFlowInfo = this.$resolvedCall.getDataFlowInfoForArguments().getInfo(argument);
                    Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "resolvedCall.dataFlowInf\u2026guments.getInfo(argument)");
                    return dataFlowInfo;
                }
                {
                    this.$resolvedCall = mutableResolvedCall;
                    super(1);
                }
            };
        } else {
            getArgumentMapping = completeArguments.3.INSTANCE;
            getDataFlowInfoForArgument = new Function1<ValueArgument, DataFlowInfo>(context){
                final /* synthetic */ BasicCallResolutionContext $context;

                @NotNull
                public final DataFlowInfo invoke(@NotNull ValueArgument it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    DataFlowInfo dataFlowInfo = this.$context.dataFlowInfo;
                    Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
                    return dataFlowInfo;
                }
                {
                    this.$context = basicCallResolutionContext;
                    super(1);
                }
            };
        }
        Iterator<? extends ValueArgument> iterator2 = context.call.getValueArguments().iterator();
        while (iterator2.hasNext()) {
            void callPosition;
            void expectedType;
            BasicCallResolutionContext newContext;
            Pair<KotlinType, CallPosition.ValueArgumentPosition> pair;
            ArgumentMapping argumentMapping;
            ArgumentMapping argumentMapping2;
            ValueArgument valueArgument;
            ValueArgument valueArgument2 = valueArgument = iterator2.next();
            if (valueArgument2 == null) {
                Intrinsics.throwNpe();
            }
            if ((argumentMapping2 = (argumentMapping = (ArgumentMapping)getArgumentMapping.invoke(valueArgument2))) instanceof ArgumentMatch) {
                KotlinType kotlinType = CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument);
                ResolvedCall resolvedCall3 = results.getResultingCall();
                Intrinsics.checkExpressionValueIsNotNull(resolvedCall3, "results.resultingCall");
                pair = new Pair<KotlinType, CallPosition.ValueArgumentPosition>(kotlinType, new CallPosition.ValueArgumentPosition(resolvedCall3, ((ArgumentMatch)argumentMapping).getValueParameter(), valueArgument));
            } else {
                pair = new Pair<SimpleType, CallPosition.Unknown>(TypeUtils.NO_EXPECTED_TYPE, CallPosition.Unknown.INSTANCE);
            }
            Pair<KotlinType, CallPosition.ValueArgumentPosition> pair2 = pair;
            KotlinType kotlinType = (KotlinType)pair2.component1();
            CallPosition callPosition2 = (CallPosition)pair2.component2();
            pair2 = null;
            BasicCallResolutionContext basicCallResolutionContext = newContext = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)context.replaceDataFlowInfo((DataFlowInfo)getDataFlowInfoForArgument.invoke(valueArgument))).replaceExpectedType((KotlinType)expectedType)).replaceCallPosition((CallPosition)callPosition);
            Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext, "newContext");
            this.completeOneArgument(valueArgument, basicCallResolutionContext);
        }
    }

    private final void completeOneArgument(ValueArgument valueArgument, BasicCallResolutionContext context) {
        KtExpression ktExpression;
        KotlinType recordedType;
        if (valueArgument.isExternal()) {
            return;
        }
        KtExpression ktExpression2 = valueArgument.getArgumentExpression();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression expression = ktExpression2;
        KtExpression ktExpression3 = KtPsiUtil.getLastElementDeparenthesized(expression, context.statementFilter);
        if (ktExpression3 == null) {
            return;
        }
        KtExpression deparenthesized = ktExpression3;
        KotlinType updatedType = recordedType = context.trace.getType(expression);
        KtExpression ktExpression4 = deparenthesized;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression4, "deparenthesized");
        OverloadResolutionResultsImpl<?> results = this.completeCallForArgument(ktExpression4, context);
        if (results != null && results.isSingleResult()) {
            KotlinType kotlinType;
            ResolvedCall resolvedCall2 = results.getResultingCall();
            if (resolvedCall2.hasInferredReturnType()) {
                Object d = resolvedCall2.getResultingDescriptor();
                kotlinType = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver(resolvedCall2, d != null ? d.getReturnType() : null, context);
            } else {
                kotlinType = updatedType = (KotlinType)null;
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable()) {
            KotlinType kotlinType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, expression);
            if (kotlinType == null) {
                kotlinType = updatedType;
            }
            updatedType = kotlinType;
        }
        StatementFilter statementFilter = context.statementFilter;
        Intrinsics.checkExpressionValueIsNotNull(statementFilter, "context.statementFilter");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, expression, statementFilter, bindingTrace);
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context);
        if (ktFunction != null) {
            ktExpression = ktFunction;
            KtFunction functionLiteralArgument = ktExpression;
            this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, functionLiteralArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression, context);
        if (ktCallableReferenceExpression != null) {
            ktExpression = ktCallableReferenceExpression;
            KtCallableReferenceExpression callableReferenceArgument = (KtCallableReferenceExpression)ktExpression;
            this.argumentTypeResolver.getCallableReferenceTypeInfo(expression, callableReferenceArgument, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
        }
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, (ResolutionContext)context);
    }

    /*
     * WARNING - void declaration
     */
    private final OverloadResolutionResultsImpl<?> completeCallForArgument(KtExpression expression, BasicCallResolutionContext context) {
        void tracing;
        void cachedResolutionResults;
        void cachedContext;
        BasicCallResolutionContext contextForArgument;
        ResolutionResultsCache.CachedData cachedData;
        ResolutionResultsCache.CachedData cachedData2 = GenericCandidateResolverKt.getResolutionResultsCachedData(expression, context);
        if (cachedData2 == null) {
            return null;
        }
        ResolutionResultsCache.CachedData cachedData3 = cachedData = cachedData2;
        OverloadResolutionResultsImpl<?> overloadResolutionResultsImpl = cachedData3.component1();
        BasicCallResolutionContext basicCallResolutionContext = cachedData3.component2();
        TracingStrategy tracingStrategy = cachedData3.component3();
        cachedData3 = null;
        BasicCallResolutionContext basicCallResolutionContext2 = contextForArgument = (BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)((BasicCallResolutionContext)cachedContext.replaceBindingTrace(context.trace)).replaceExpectedType(context.expectedType)).replaceCollectAllCandidates(false)).replaceCallPosition(context.callPosition);
        Intrinsics.checkExpressionValueIsNotNull(basicCallResolutionContext2, "contextForArgument");
        return this.completeCall(basicCallResolutionContext2, (OverloadResolutionResultsImpl)cachedResolutionResults, (TracingStrategy)tracing);
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KtExpression argumentExpression, StatementFilter statementFilter, BindingTrace trace) {
        void $receiver$iv;
        if (!ErrorUtils.containsErrorType(recordedType) && Intrinsics.areEqual(recordedType, updatedType) || updatedType == null) {
            return updatedType;
        }
        Function1<KtExpression, KtExpression> deparenthesizeOrGetSelector$ = new Function1<KtExpression, KtExpression>(statementFilter){
            final /* synthetic */ StatementFilter $statementFilter;

            @Nullable
            public final KtExpression invoke(@Nullable KtExpression expression) {
                KtExpression deparenthesized = KtPsiUtil.deparenthesizeOnce(expression);
                if (Intrinsics.areEqual(deparenthesized, expression) ^ true) {
                    return deparenthesized;
                }
                if (expression instanceof KtBlockExpression) {
                    return StatementFilterKt.getLastStatementInABlock(this.$statementFilter, (KtBlockExpression)expression);
                }
                KtExpression ktExpression = expression;
                if (!(ktExpression instanceof KtQualifiedExpression)) {
                    ktExpression = null;
                }
                KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression;
                return ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
            }
            {
                this.$statementFilter = statementFilter;
                super(1);
            }
        };
        ArrayList<KtExpression> expressions = new ArrayList<KtExpression>();
        KtExpression expression = argumentExpression;
        while (expression != null) {
            expressions.add(expression);
            expression = deparenthesizeOrGetSelector$.invoke(expression);
        }
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Iterable iterable = CollectionsKt.asReversedMutable((List)expressions);
        for (Object element$iv : $receiver$iv) {
            void shouldBeMadeNullable;
            KtExpression expression2 = (KtExpression)element$iv;
            if (!(expression2 instanceof KtParenthesizedExpression || expression2 instanceof KtLabeledExpression || expression2 instanceof KtAnnotatedExpression)) {
                shouldBeMadeNullable.element = this.hasNecessarySafeCall(expression2, trace);
            }
            BindingContextUtils.updateRecordedType(updatedType, expression2, trace, shouldBeMadeNullable.element);
        }
        return trace.getType(argumentExpression);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression, BindingTrace trace) {
        if (!(expression instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType = trace.getType(((KtSafeQualifiedExpression)expression).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    public CallCompleter(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull CandidateResolver candidateResolver, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull Iterable<? extends CallChecker> callCheckers, @NotNull KotlinBuiltIns builtIns, @NotNull FakeCallResolver fakeCallResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkParameterIsNotNull(candidateResolver, "candidateResolver");
        Intrinsics.checkParameterIsNotNull(dataFlowAnalyzer, "dataFlowAnalyzer");
        Intrinsics.checkParameterIsNotNull(callCheckers, "callCheckers");
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        Intrinsics.checkParameterIsNotNull(fakeCallResolver, "fakeCallResolver");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        this.argumentTypeResolver = argumentTypeResolver;
        this.candidateResolver = candidateResolver;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.callCheckers = callCheckers;
        this.builtIns = builtIns;
        this.fakeCallResolver = fakeCallResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$p(CallCompleter $this) {
        return $this.builtIns;
    }
}

