/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.impl.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.RequestTrace;
import org.sonatype.aether.SyncContext;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.deployment.DeployRequest;
import org.sonatype.aether.deployment.DeployResult;
import org.sonatype.aether.deployment.DeploymentException;
import org.sonatype.aether.impl.Deployer;
import org.sonatype.aether.impl.MetadataGenerator;
import org.sonatype.aether.impl.MetadataGeneratorFactory;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.impl.RepositoryEventDispatcher;
import org.sonatype.aether.impl.SyncContextFactory;
import org.sonatype.aether.impl.UpdateCheck;
import org.sonatype.aether.impl.UpdateCheckManager;
import org.sonatype.aether.impl.internal.Utils;
import org.sonatype.aether.metadata.MergeableMetadata;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.ArtifactRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.spi.connector.ArtifactUpload;
import org.sonatype.aether.spi.connector.MetadataDownload;
import org.sonatype.aether.spi.connector.MetadataUpload;
import org.sonatype.aether.spi.connector.RepositoryConnector;
import org.sonatype.aether.spi.connector.Transfer;
import org.sonatype.aether.spi.io.FileProcessor;
import org.sonatype.aether.spi.locator.Service;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.spi.log.Logger;
import org.sonatype.aether.spi.log.NullLogger;
import org.sonatype.aether.transfer.ArtifactTransferException;
import org.sonatype.aether.transfer.MetadataNotFoundException;
import org.sonatype.aether.transfer.MetadataTransferException;
import org.sonatype.aether.transfer.NoRepositoryConnectorException;
import org.sonatype.aether.util.DefaultRequestTrace;
import org.sonatype.aether.util.listener.DefaultRepositoryEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=Deployer.class)
public class DefaultDeployer
implements Deployer,
Service {
    @Requirement
    private Logger logger = NullLogger.INSTANCE;
    @Requirement
    private FileProcessor fileProcessor;
    @Requirement
    private RepositoryEventDispatcher repositoryEventDispatcher;
    @Requirement
    private RemoteRepositoryManager remoteRepositoryManager;
    @Requirement
    private UpdateCheckManager updateCheckManager;
    @Requirement(role=MetadataGeneratorFactory.class)
    private List<MetadataGeneratorFactory> metadataFactories = new ArrayList<MetadataGeneratorFactory>();
    @Requirement
    private SyncContextFactory syncContextFactory;

    public DefaultDeployer() {
    }

    public DefaultDeployer(Logger logger, FileProcessor fileProcessor, RepositoryEventDispatcher repositoryEventDispatcher, RemoteRepositoryManager remoteRepositoryManager, UpdateCheckManager updateCheckManager, List<MetadataGeneratorFactory> metadataFactories, SyncContextFactory syncContextFactory) {
        this.setLogger(logger);
        this.setFileProcessor(fileProcessor);
        this.setRepositoryEventDispatcher(repositoryEventDispatcher);
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setUpdateCheckManager(updateCheckManager);
        this.setMetadataFactories(metadataFactories);
        this.setSyncContextFactory(syncContextFactory);
    }

    public void initService(ServiceLocator locator) {
        this.setLogger((Logger)locator.getService(Logger.class));
        this.setFileProcessor((FileProcessor)locator.getService(FileProcessor.class));
        this.setRepositoryEventDispatcher((RepositoryEventDispatcher)locator.getService(RepositoryEventDispatcher.class));
        this.setRemoteRepositoryManager((RemoteRepositoryManager)locator.getService(RemoteRepositoryManager.class));
        this.setUpdateCheckManager((UpdateCheckManager)locator.getService(UpdateCheckManager.class));
        this.setMetadataFactories(locator.getServices(MetadataGeneratorFactory.class));
        this.setSyncContextFactory((SyncContextFactory)locator.getService(SyncContextFactory.class));
    }

    public DefaultDeployer setLogger(Logger logger) {
        this.logger = logger != null ? logger : NullLogger.INSTANCE;
        return this;
    }

    public DefaultDeployer setFileProcessor(FileProcessor fileProcessor) {
        if (fileProcessor == null) {
            throw new IllegalArgumentException("file processor has not been specified");
        }
        this.fileProcessor = fileProcessor;
        return this;
    }

    public DefaultDeployer setRepositoryEventDispatcher(RepositoryEventDispatcher repositoryEventDispatcher) {
        if (repositoryEventDispatcher == null) {
            throw new IllegalArgumentException("repository event dispatcher has not been specified");
        }
        this.repositoryEventDispatcher = repositoryEventDispatcher;
        return this;
    }

    public DefaultDeployer setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        if (remoteRepositoryManager == null) {
            throw new IllegalArgumentException("remote repository manager has not been specified");
        }
        this.remoteRepositoryManager = remoteRepositoryManager;
        return this;
    }

    public DefaultDeployer setUpdateCheckManager(UpdateCheckManager updateCheckManager) {
        if (updateCheckManager == null) {
            throw new IllegalArgumentException("update check manager has not been specified");
        }
        this.updateCheckManager = updateCheckManager;
        return this;
    }

    public DefaultDeployer addMetadataGeneratorFactory(MetadataGeneratorFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("metadata generator factory has not been specified");
        }
        this.metadataFactories.add(factory);
        return this;
    }

    public DefaultDeployer setMetadataFactories(List<MetadataGeneratorFactory> metadataFactories) {
        this.metadataFactories = metadataFactories == null ? new ArrayList<MetadataGeneratorFactory>() : metadataFactories;
        return this;
    }

    public DefaultDeployer setSyncContextFactory(SyncContextFactory syncContextFactory) {
        if (syncContextFactory == null) {
            throw new IllegalArgumentException("sync context factory has not been specified");
        }
        this.syncContextFactory = syncContextFactory;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeployResult deploy(RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        if (session.isOffline()) {
            throw new DeploymentException("The repository system is in offline mode, deployment impossible");
        }
        SyncContext syncContext = this.syncContextFactory.newInstance(session, false);
        try {
            DeployResult deployResult = this.deploy(syncContext, session, request);
            return deployResult;
        }
        finally {
            syncContext.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private DeployResult deploy(SyncContext syncContext, RepositorySystemSession session, DeployRequest request) throws DeploymentException {
        RepositoryConnector connector;
        DeployResult result = new DeployResult(request);
        RequestTrace trace = DefaultRequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        RemoteRepository repository = request.getRepository();
        try {
            connector = this.remoteRepositoryManager.getRepositoryConnector(session, repository);
        }
        catch (NoRepositoryConnectorException e) {
            throw new DeploymentException("Failed to deploy artifacts/metadata: " + e.getMessage(), (Throwable)e);
        }
        List<MetadataGenerator> generators = this.getMetadataGenerators(session, request);
        try {
            ArrayList<ArtifactUploadEx> artifactUploads = new ArrayList<ArtifactUploadEx>();
            ArrayList<MetadataUpload> metadataUploads = new ArrayList<MetadataUpload>();
            IdentityHashMap processedMetadata = new IdentityHashMap();
            EventCatapult catapult = new EventCatapult(session, trace, repository, this.repositoryEventDispatcher);
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(request.getArtifacts());
            List<Metadata> metadatas = Utils.prepareMetadata(generators, artifacts);
            syncContext.acquire(artifacts, Utils.combine(request.getMetadata(), metadatas));
            for (Metadata metadata : metadatas) {
                this.upload(metadataUploads, session, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            for (int i = 0; i < artifacts.size(); ++i) {
                void var16_22;
                Artifact artifact = (Artifact)artifacts.get(i);
                for (MetadataGenerator generator : generators) {
                    Artifact artifact2 = generator.transformArtifact((Artifact)var16_22);
                }
                artifacts.set(i, (Artifact)var16_22);
                artifactUploads.add(new ArtifactUploadEx((Artifact)var16_22, var16_22.getFile(), catapult));
            }
            connector.put(artifactUploads, null);
            for (ArtifactUpload artifactUpload : artifactUploads) {
                if (artifactUpload.getException() != null) {
                    throw new DeploymentException("Failed to deploy artifacts: " + artifactUpload.getException().getMessage(), (Throwable)artifactUpload.getException());
                }
                result.addArtifact(artifactUpload.getArtifact());
            }
            metadatas = Utils.finishMetadata(generators, artifacts);
            syncContext.acquire(null, metadatas);
            for (Metadata metadata : metadatas) {
                this.upload(metadataUploads, session, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            for (Metadata metadata : request.getMetadata()) {
                if (processedMetadata.containsKey(metadata)) continue;
                this.upload(metadataUploads, session, metadata, repository, connector, catapult);
                processedMetadata.put(metadata, null);
            }
            connector.put(null, metadataUploads);
            for (MetadataUpload metadataUpload : metadataUploads) {
                if (metadataUpload.getException() != null) {
                    throw new DeploymentException("Failed to deploy metadata: " + metadataUpload.getException().getMessage(), (Throwable)metadataUpload.getException());
                }
                result.addMetadata(metadataUpload.getMetadata());
            }
        }
        finally {
            connector.close();
        }
        return result;
    }

    private List<MetadataGenerator> getMetadataGenerators(RepositorySystemSession session, DeployRequest request) {
        List<MetadataGeneratorFactory> factories = Utils.sortMetadataGeneratorFactories(this.metadataFactories);
        ArrayList<MetadataGenerator> generators = new ArrayList<MetadataGenerator>();
        for (MetadataGeneratorFactory factory : factories) {
            MetadataGenerator generator = factory.newInstance(session, request);
            if (generator == null) continue;
            generators.add(generator);
        }
        return generators;
    }

    private void upload(Collection<MetadataUpload> metadataUploads, RepositorySystemSession session, Metadata metadata, RemoteRepository repository, RepositoryConnector connector, EventCatapult catapult) throws DeploymentException {
        LocalRepositoryManager lrm = session.getLocalRepositoryManager();
        File basedir = lrm.getRepository().getBasedir();
        File dstFile = new File(basedir, lrm.getPathForRemoteMetadata(metadata, repository, ""));
        if (metadata instanceof MergeableMetadata) {
            if (!((MergeableMetadata)metadata).isMerged()) {
                DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_RESOLVING, session, catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository((ArtifactRepository)repository);
                this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
                event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_DOWNLOADING, session, catapult.getTrace());
                event.setMetadata(metadata);
                event.setRepository((ArtifactRepository)repository);
                this.repositoryEventDispatcher.dispatch((RepositoryEvent)event);
                RepositoryPolicy policy = this.getPolicy(session, repository, metadata.getNature());
                MetadataDownload download = new MetadataDownload();
                download.setMetadata(metadata);
                download.setFile(dstFile);
                download.setChecksumPolicy(policy.getChecksumPolicy());
                connector.get(null, Arrays.asList(download));
                MetadataTransferException error = download.getException();
                if (error instanceof MetadataNotFoundException) {
                    dstFile.delete();
                }
                DefaultRepositoryEvent event2 = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_DOWNLOADED, session, catapult.getTrace());
                event2.setMetadata(metadata);
                event2.setRepository((ArtifactRepository)repository);
                event2.setException((Exception)error);
                event2.setFile(dstFile);
                this.repositoryEventDispatcher.dispatch((RepositoryEvent)event2);
                event2 = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_RESOLVED, session, catapult.getTrace());
                event2.setMetadata(metadata);
                event2.setRepository((ArtifactRepository)repository);
                event2.setException((Exception)error);
                event2.setFile(dstFile);
                this.repositoryEventDispatcher.dispatch((RepositoryEvent)event2);
                if (error != null && !(error instanceof MetadataNotFoundException)) {
                    throw new DeploymentException("Failed to retrieve remote metadata " + metadata + ": " + error.getMessage(), (Throwable)error);
                }
            }
            try {
                ((MergeableMetadata)metadata).merge(dstFile, dstFile);
            }
            catch (RepositoryException e) {
                throw new DeploymentException("Failed to update metadata " + metadata + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (metadata.getFile() == null) {
            throw new DeploymentException("Failed to update metadata " + metadata + ": No file attached.");
        }
        try {
            this.fileProcessor.copy(metadata.getFile(), dstFile, null);
        }
        catch (IOException e) {
            throw new DeploymentException("Failed to update metadata " + metadata + ": " + e.getMessage(), (Throwable)e);
        }
        UpdateCheck<Metadata, MetadataTransferException> check = new UpdateCheck<Metadata, MetadataTransferException>();
        check.setItem(metadata);
        check.setFile(dstFile);
        check.setRepository(repository);
        check.setAuthoritativeRepository(repository);
        this.updateCheckManager.touchMetadata(session, check);
        metadataUploads.add(new MetadataUploadEx(metadata, dstFile, catapult));
    }

    private RepositoryPolicy getPolicy(RepositorySystemSession session, RemoteRepository repository, Metadata.Nature nature) {
        boolean releases = !Metadata.Nature.SNAPSHOT.equals((Object)nature);
        boolean snapshots = !Metadata.Nature.RELEASE.equals((Object)nature);
        return this.remoteRepositoryManager.getPolicy(session, repository, releases, snapshots);
    }

    static class MetadataUploadEx
    extends MetadataUpload {
        private final EventCatapult catapult;

        public MetadataUploadEx(Metadata metadata, File file, EventCatapult catapult) {
            super(metadata, file);
            this.catapult = catapult;
        }

        public Transfer setState(Transfer.State state) {
            super.setState(state);
            if (Transfer.State.ACTIVE.equals((Object)state)) {
                this.catapult.metadataDeploying(this.getMetadata(), this.getFile());
            } else if (Transfer.State.DONE.equals((Object)state)) {
                this.catapult.metadataDeployed(this.getMetadata(), this.getFile(), (Exception)this.getException());
            }
            return this;
        }
    }

    static class ArtifactUploadEx
    extends ArtifactUpload {
        private final EventCatapult catapult;

        public ArtifactUploadEx(Artifact artifact, File file, EventCatapult catapult) {
            super(artifact, file);
            this.catapult = catapult;
        }

        public Transfer setState(Transfer.State state) {
            super.setState(state);
            if (Transfer.State.ACTIVE.equals((Object)state)) {
                this.catapult.artifactDeploying(this.getArtifact(), this.getFile());
            } else if (Transfer.State.DONE.equals((Object)state)) {
                this.catapult.artifactDeployed(this.getArtifact(), this.getFile(), this.getException());
            }
            return this;
        }
    }

    static class EventCatapult {
        private final RepositorySystemSession session;
        private final RequestTrace trace;
        private final RemoteRepository repository;
        private final RepositoryEventDispatcher dispatcher;

        public EventCatapult(RepositorySystemSession session, RequestTrace trace, RemoteRepository repository, RepositoryEventDispatcher dispatcher) {
            this.session = session;
            this.trace = trace;
            this.repository = repository;
            this.dispatcher = dispatcher;
        }

        public RequestTrace getTrace() {
            return this.trace;
        }

        public void artifactDeploying(Artifact artifact, File file) {
            DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_DEPLOYING, this.session, this.trace);
            event.setArtifact(artifact);
            event.setRepository((ArtifactRepository)this.repository);
            event.setFile(file);
            this.dispatcher.dispatch((RepositoryEvent)event);
        }

        public void artifactDeployed(Artifact artifact, File file, ArtifactTransferException exception) {
            DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.ARTIFACT_DEPLOYED, this.session, this.trace);
            event.setArtifact(artifact);
            event.setRepository((ArtifactRepository)this.repository);
            event.setFile(file);
            event.setException((Exception)((Object)exception));
            this.dispatcher.dispatch((RepositoryEvent)event);
        }

        public void metadataDeploying(Metadata metadata, File file) {
            DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_DEPLOYING, this.session, this.trace);
            event.setMetadata(metadata);
            event.setRepository((ArtifactRepository)this.repository);
            event.setFile(file);
            this.dispatcher.dispatch((RepositoryEvent)event);
        }

        public void metadataDeployed(Metadata metadata, File file, Exception exception) {
            DefaultRepositoryEvent event = new DefaultRepositoryEvent(RepositoryEvent.EventType.METADATA_DEPLOYED, this.session, this.trace);
            event.setMetadata(metadata);
            event.setRepository((ArtifactRepository)this.repository);
            event.setFile(file);
            event.setException(exception);
            this.dispatcher.dispatch((RepositoryEvent)event);
        }
    }
}

