/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.artefact.Artefact;
import grails.build.logging.GrailsConsole;
import grails.compiler.ast.AllArtefactClassInjector;
import grails.compiler.ast.ClassInjector;
import grails.compiler.ast.GlobalClassInjector;
import grails.compiler.ast.GrailsArtefactClassInjector;
import groovy.transform.CompilationUnitAware;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.grails.compiler.injection.AbstractArtefactTypeAstTransformation;
import org.grails.compiler.injection.AbstractGrailsArtefactTransformer;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.compiler.injection.GrailsAwareInjectionOperation;
import org.grails.compiler.injection.TraitInjectionUtils;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ArtefactTypeAstTransformation
extends AbstractArtefactTypeAstTransformation
implements CompilationUnitAware {
    private static final ClassNode MY_TYPE = new ClassNode(Artefact.class);
    protected CompilationUnit compilationUnit;

    public void visit(ASTNode[] astNodes, SourceUnit sourceUnit) {
        AnnotatedNode parent = (AnnotatedNode)astNodes[1];
        AnnotationNode node = (AnnotationNode)astNodes[0];
        if (!(node instanceof AnnotationNode) || !(parent instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        if (!this.isArtefactAnnotationNode(node) || !(parent instanceof ClassNode)) {
            return;
        }
        ClassNode cNode = (ClassNode)parent;
        if (cNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cNode.getName() + "'. @" + this.getAnnotationType().getNameWithoutPackage() + " not allowed for interfaces.");
        }
        if (this.isApplied(cNode)) {
            return;
        }
        String artefactType = this.resolveArtefactType(sourceUnit, node, cNode);
        if (artefactType != null) {
            AbstractGrailsArtefactTransformer.addToTransformedClasses(cNode.getName());
        }
        this.performInjectionOnArtefactType(sourceUnit, cNode, artefactType);
        this.performTraitInjectionOnArtefactType(sourceUnit, cNode, artefactType);
        this.postProcess(sourceUnit, node, cNode, artefactType);
        this.markApplied(cNode);
    }

    protected void performTraitInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        if (this.compilationUnit != null) {
            TraitInjectionUtils.processTraitsForNode(sourceUnit, cNode, artefactType, this.compilationUnit);
        }
    }

    protected boolean isApplied(ClassNode cNode) {
        return GrailsASTUtils.isApplied((ASTNode)cNode, this.getAstAppliedMarkerClass());
    }

    protected void markApplied(ClassNode classNode) {
        GrailsASTUtils.markApplied((ASTNode)classNode, this.getAstAppliedMarkerClass());
    }

    protected Class<?> getAstAppliedMarkerClass() {
        return ArtefactTypeAstTransformation.class;
    }

    protected void postProcess(SourceUnit sourceUnit, AnnotationNode annotationNode, ClassNode classNode, String artefactType) {
        if (!this.getAnnotationType().equals((Object)annotationNode.getClassNode())) {
            AnnotationNode annotation = new AnnotationNode(this.getAnnotationType());
            annotation.addMember("value", (Expression)new ConstantExpression((Object)artefactType));
            classNode.addAnnotation(annotation);
        }
    }

    protected String resolveArtefactType(SourceUnit sourceUnit, AnnotationNode annotationNode, ClassNode classNode) {
        Expression value = annotationNode.getMember("value");
        if (value != null) {
            PropertyExpression pe;
            Expression objectExpression;
            if (value instanceof ConstantExpression) {
                ConstantExpression ce = (ConstantExpression)value;
                return ce.getText();
            }
            if (value instanceof PropertyExpression && (objectExpression = (pe = (PropertyExpression)value).getObjectExpression()) instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)objectExpression;
                try {
                    Field field = ce.getType().getTypeClass().getDeclaredField(pe.getPropertyAsString());
                    return (String)field.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        throw new RuntimeException("Class [" + classNode.getName() + "] contains an invalid @Artefact annotation. No artefact found for value specified.");
    }

    protected boolean isArtefactAnnotationNode(AnnotationNode annotationNode) {
        return this.getAnnotationType().equals((Object)annotationNode.getClassNode());
    }

    protected ClassNode getAnnotationType() {
        return new ClassNode(this.getAnnotationTypeClass());
    }

    protected Class getAnnotationTypeClass() {
        return MY_TYPE.getTypeClass();
    }

    @Override
    public void performInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        List<ClassInjector> injectors = ArtefactTypeAstTransformation.findInjectors(artefactType, GrailsAwareInjectionOperation.getClassInjectors());
        for (ClassInjector injector : injectors) {
            if (!(injector instanceof CompilationUnitAware)) continue;
            ((CompilationUnitAware)injector).setCompilationUnit(this.compilationUnit);
        }
        ArtefactTypeAstTransformation.performInjection(sourceUnit, cNode, injectors);
    }

    @Deprecated
    public static void doPerformInjectionOnArtefactType(SourceUnit sourceUnit, ClassNode cNode, String artefactType) {
        List<ClassInjector> injectors = ArtefactTypeAstTransformation.findInjectors(artefactType, GrailsAwareInjectionOperation.getClassInjectors());
        ArtefactTypeAstTransformation.performInjection(sourceUnit, cNode, injectors);
    }

    public static void performInjection(SourceUnit sourceUnit, ClassNode cNode, Collection<ClassInjector> injectors) {
        try {
            for (ClassInjector injector : injectors) {
                if (GrailsASTUtils.isApplied((ASTNode)cNode, injector.getClass())) continue;
                GrailsASTUtils.markApplied((ASTNode)cNode, injector.getClass());
                injector.performInjectionOnAnnotatedClass(sourceUnit, cNode);
            }
        }
        catch (RuntimeException e) {
            try {
                GrailsConsole.getInstance().error("Error occurred calling AST injector: " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw e;
        }
    }

    public static List<ClassInjector> findInjectors(String artefactType, ClassInjector[] classInjectors) {
        ArrayList<ClassInjector> injectors = new ArrayList<ClassInjector>();
        for (ClassInjector classInjector : classInjectors) {
            GrailsArtefactClassInjector gace;
            if (classInjector instanceof AllArtefactClassInjector) {
                injectors.add(classInjector);
                continue;
            }
            if (classInjector instanceof GlobalClassInjector) {
                injectors.add(classInjector);
                continue;
            }
            if (!(classInjector instanceof GrailsArtefactClassInjector) || !ArtefactTypeAstTransformation.hasArtefactType(artefactType, gace = (GrailsArtefactClassInjector)classInjector)) continue;
            injectors.add(gace);
        }
        return injectors;
    }

    public static boolean hasArtefactType(String artefactType, GrailsArtefactClassInjector gace) {
        for (String _artefactType : gace.getArtefactTypes()) {
            if (_artefactType.equals("*")) {
                return true;
            }
            if (!_artefactType.equals(artefactType)) continue;
            return true;
        }
        return false;
    }

    public void setCompilationUnit(CompilationUnit unit) {
        this.compilationUnit = unit;
    }
}

