/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.FujifilmMakernoteDirectory;

public class FujifilmMakernoteDescriptor
extends TagDescriptor<FujifilmMakernoteDirectory> {
    public FujifilmMakernoteDescriptor(@NotNull FujifilmMakernoteDirectory fujifilmMakernoteDirectory) {
        super(fujifilmMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 0: {
                return this.getMakernoteVersionDescription();
            }
            case 4097: {
                return this.getSharpnessDescription();
            }
            case 4098: {
                return this.getWhiteBalanceDescription();
            }
            case 4099: {
                return this.getColorSaturationDescription();
            }
            case 4100: {
                return this.getToneDescription();
            }
            case 4102: {
                return this.getContrastDescription();
            }
            case 4107: {
                return this.getNoiseReductionDescription();
            }
            case 4110: {
                return this.getHighIsoNoiseReductionDescription();
            }
            case 4112: {
                return this.getFlashModeDescription();
            }
            case 4113: {
                return this.getFlashExposureValueDescription();
            }
            case 4128: {
                return this.getMacroDescription();
            }
            case 4129: {
                return this.getFocusModeDescription();
            }
            case 4144: {
                return this.getSlowSyncDescription();
            }
            case 4145: {
                return this.getPictureModeDescription();
            }
            case 4147: {
                return this.getExrAutoDescription();
            }
            case 4148: {
                return this.getExrModeDescription();
            }
            case 4352: {
                return this.getAutoBracketingDescription();
            }
            case 4624: {
                return this.getFinePixColorDescription();
            }
            case 4864: {
                return this.getBlurWarningDescription();
            }
            case 4865: {
                return this.getFocusWarningDescription();
            }
            case 4866: {
                return this.getAutoExposureWarningDescription();
            }
            case 5120: {
                return this.getDynamicRangeDescription();
            }
            case 5121: {
                return this.getFilmModeDescription();
            }
            case 5122: {
                return this.getDynamicRangeSettingDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    private String getMakernoteVersionDescription() {
        return this.getVersionBytesDescription(0, 2);
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4097);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 1: {
                return "Softest";
            }
            case 2: {
                return "Soft";
            }
            case 3: {
                return "Normal";
            }
            case 4: {
                return "Hard";
            }
            case 5: {
                return "Hardest";
            }
            case 130: {
                return "Medium Soft";
            }
            case 132: {
                return "Medium Hard";
            }
            case 32768: {
                return "Film Simulation";
            }
            case 65535: {
                return "N/A";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4098);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 256: {
                return "Daylight";
            }
            case 512: {
                return "Cloudy";
            }
            case 768: {
                return "Daylight Fluorescent";
            }
            case 769: {
                return "Day White Fluorescent";
            }
            case 770: {
                return "White Fluorescent";
            }
            case 771: {
                return "Warm White Fluorescent";
            }
            case 772: {
                return "Living Room Warm White Fluorescent";
            }
            case 1024: {
                return "Incandescence";
            }
            case 1280: {
                return "Flash";
            }
            case 3840: {
                return "Custom White Balance";
            }
            case 3841: {
                return "Custom White Balance 2";
            }
            case 3842: {
                return "Custom White Balance 3";
            }
            case 3843: {
                return "Custom White Balance 4";
            }
            case 3844: {
                return "Custom White Balance 5";
            }
            case 4080: {
                return "Kelvin";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getColorSaturationDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4099);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 128: {
                return "Medium High";
            }
            case 256: {
                return "High";
            }
            case 384: {
                return "Medium Low";
            }
            case 512: {
                return "Low";
            }
            case 768: {
                return "None (B&W)";
            }
            case 769: {
                return "B&W Green Filter";
            }
            case 770: {
                return "B&W Yellow Filter";
            }
            case 771: {
                return "B&W Blue Filter";
            }
            case 772: {
                return "B&W Sepia";
            }
            case 32768: {
                return "Film Simulation";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getToneDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4100);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 128: {
                return "Medium High";
            }
            case 256: {
                return "High";
            }
            case 384: {
                return "Medium Low";
            }
            case 512: {
                return "Low";
            }
            case 768: {
                return "None (B&W)";
            }
            case 32768: {
                return "Film Simulation";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4102);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 256: {
                return "High";
            }
            case 768: {
                return "Low";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getNoiseReductionDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4107);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 64: {
                return "Low";
            }
            case 128: {
                return "Normal";
            }
            case 256: {
                return "N/A";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getHighIsoNoiseReductionDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4110);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Normal";
            }
            case 256: {
                return "Strong";
            }
            case 512: {
                return "Weak";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        return this.getIndexedDescription(4112, "Auto", "On", "Off", "Red-eye Reduction", "External");
    }

    @Nullable
    public String getFlashExposureValueDescription() {
        Rational rational = ((FujifilmMakernoteDirectory)this._directory).getRational(4113);
        return rational == null ? null : rational.toSimpleString(false) + " EV (Apex)";
    }

    @Nullable
    public String getMacroDescription() {
        return this.getIndexedDescription(4128, "Off", "On");
    }

    @Nullable
    public String getFocusModeDescription() {
        return this.getIndexedDescription(4129, "Auto Focus", "Manual Focus");
    }

    @Nullable
    public String getSlowSyncDescription() {
        return this.getIndexedDescription(4144, "Off", "On");
    }

    @Nullable
    public String getPictureModeDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4145);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Portrait scene";
            }
            case 2: {
                return "Landscape scene";
            }
            case 3: {
                return "Macro";
            }
            case 4: {
                return "Sports scene";
            }
            case 5: {
                return "Night scene";
            }
            case 6: {
                return "Program AE";
            }
            case 7: {
                return "Natural Light";
            }
            case 8: {
                return "Anti-blur";
            }
            case 9: {
                return "Beach & Snow";
            }
            case 10: {
                return "Sunset";
            }
            case 11: {
                return "Museum";
            }
            case 12: {
                return "Party";
            }
            case 13: {
                return "Flower";
            }
            case 14: {
                return "Text";
            }
            case 15: {
                return "Natural Light & Flash";
            }
            case 16: {
                return "Beach";
            }
            case 17: {
                return "Snow";
            }
            case 18: {
                return "Fireworks";
            }
            case 19: {
                return "Underwater";
            }
            case 20: {
                return "Portrait with Skin Correction";
            }
            case 22: {
                return "Panorama";
            }
            case 23: {
                return "Night (Tripod)";
            }
            case 24: {
                return "Pro Low-light";
            }
            case 25: {
                return "Pro Focus";
            }
            case 27: {
                return "Dog Face Detection";
            }
            case 28: {
                return "Cat Face Detection";
            }
            case 256: {
                return "Aperture priority AE";
            }
            case 512: {
                return "Shutter priority AE";
            }
            case 768: {
                return "Manual exposure";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getExrAutoDescription() {
        return this.getIndexedDescription(4147, "Auto", "Manual");
    }

    @Nullable
    public String getExrModeDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4148);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 256: {
                return "HR (High Resolution)";
            }
            case 512: {
                return "SN (Signal to Noise Priority)";
            }
            case 768: {
                return "DR (Dynamic Range Priority)";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getAutoBracketingDescription() {
        return this.getIndexedDescription(4352, "Off", "On", "No Flash & Flash");
    }

    @Nullable
    public String getFinePixColorDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(4624);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Standard";
            }
            case 16: {
                return "Chrome";
            }
            case 48: {
                return "B&W";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getBlurWarningDescription() {
        return this.getIndexedDescription(4864, "No Blur Warning", "Blur warning");
    }

    @Nullable
    public String getFocusWarningDescription() {
        return this.getIndexedDescription(4865, "Good Focus", "Out Of Focus");
    }

    @Nullable
    public String getAutoExposureWarningDescription() {
        return this.getIndexedDescription(4866, "AE Good", "Over Exposed");
    }

    @Nullable
    public String getDynamicRangeDescription() {
        return this.getIndexedDescription(5120, 1, "Standard", null, "Wide");
    }

    @Nullable
    public String getFilmModeDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(5121);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "F0/Standard (Provia) ";
            }
            case 256: {
                return "F1/Studio Portrait";
            }
            case 272: {
                return "F1a/Studio Portrait Enhanced Saturation";
            }
            case 288: {
                return "F1b/Studio Portrait Smooth Skin Tone (Astia)";
            }
            case 304: {
                return "F1c/Studio Portrait Increased Sharpness";
            }
            case 512: {
                return "F2/Fujichrome (Velvia)";
            }
            case 768: {
                return "F3/Studio Portrait Ex";
            }
            case 1024: {
                return "F4/Velvia";
            }
            case 1280: {
                return "Pro Neg. Std";
            }
            case 1281: {
                return "Pro Neg. Hi";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getDynamicRangeSettingDescription() {
        Integer n = ((FujifilmMakernoteDirectory)this._directory).getInteger(5122);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto (100-400%)";
            }
            case 1: {
                return "Manual";
            }
            case 256: {
                return "Standard (100%)";
            }
            case 512: {
                return "Wide 1 (230%)";
            }
            case 513: {
                return "Wide 2 (400%)";
            }
            case 32768: {
                return "Film Simulation";
            }
        }
        return "Unknown (" + n + ")";
    }
}

