/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import org.openstreetmap.josm.actions.search.SearchCompiler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.Tokenizer;

public class ParseError
extends Exception {
    private final transient Tokenizer.Token unexpectedToken;

    public ParseError(Tokenizer.Token token) {
        super(I18n.tr("Unexpected token ({0}) on position {1}", new Object[]{token.getType(), token.getPosition()}));
        this.unexpectedToken = token;
    }

    public ParseError(Tokenizer.Token token, Tokenizer.TokenType tokenType) {
        super(I18n.tr("Unexpected token on position {0}. Expected {1}, found {2}", new Object[]{token.getPosition(), tokenType, token.getType()}));
        this.unexpectedToken = token;
    }

    public ParseError(int n, SearchCompiler.ParseError parseError) {
        super(I18n.tr("Error while parsing search expression on position {0}", n), parseError);
        this.unexpectedToken = null;
    }

    public ParseError(String string) {
        super(string);
        this.unexpectedToken = null;
    }

    public Tokenizer.Token getUnexpectedToken() {
        return this.unexpectedToken;
    }

    public static ParseError unexpectedChar(char c, char c2, int n) {
        return new ParseError(I18n.tr("Unexpected char on {0}. Expected {1} found {2}", n, Character.valueOf(c), Character.valueOf(c2)));
    }
}

