/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.frame;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;

public final class FrameSlot
implements Cloneable {
    private final FrameDescriptor descriptor;
    private final Object identifier;
    private final Object info;
    private final int index;
    @CompilerDirectives.CompilationFinal
    private FrameSlotKind kind;

    @Deprecated
    public FrameSlot(FrameDescriptor descriptor, Object identifier, Object info, int index, FrameSlotKind kind) {
        this(descriptor, identifier, info, kind, index);
    }

    FrameSlot(FrameDescriptor descriptor, Object identifier, Object info, FrameSlotKind kind, int index) {
        this.descriptor = descriptor;
        this.identifier = identifier;
        this.info = info;
        this.index = index;
        this.kind = kind;
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    public Object getInfo() {
        return this.info;
    }

    public int getIndex() {
        return this.index;
    }

    public FrameSlotKind getKind() {
        return this.kind;
    }

    public void setKind(FrameSlotKind kind) {
        if (this.kind != kind) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.kind = kind;
            this.descriptor.updateVersion();
        }
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation("do not call FrameSlot.toString from compiled code");
        return "[" + this.index + "," + this.identifier + "," + (Object)((Object)this.kind) + "]";
    }

    public FrameDescriptor getFrameDescriptor() {
        return this.descriptor;
    }
}

