/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInterop;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.MethodMessage;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.TypeAndClass;
import com.oracle.truffle.api.nodes.Node;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;

final class JavaInteropReflect {
    private static final Object[] EMPTY = new Object[0];

    @CompilerDirectives.TruffleBoundary
    static Object readField(JavaObject object, String name) throws NoSuchFieldError, SecurityException, IllegalArgumentException, IllegalAccessException {
        Object val;
        Object obj = object.obj;
        boolean onlyStatic = obj == null;
        try {
            boolean isStatic;
            Field field = object.clazz.getField(name);
            boolean bl = isStatic = (field.getModifiers() & 8) != 0;
            if (onlyStatic != isStatic) {
                throw new NoSuchFieldException();
            }
            val = field.get(obj);
        }
        catch (NoSuchFieldException ex) {
            for (Method m : object.clazz.getMethods()) {
                boolean isStatic;
                boolean bl = isStatic = (m.getModifiers() & 8) != 0;
                if (onlyStatic != isStatic || !m.getName().equals(name)) continue;
                return new JavaFunctionObject(m, obj);
            }
            throw (NoSuchFieldError)new NoSuchFieldError(ex.getMessage()).initCause(ex);
        }
        if (ToJavaNode.isPrimitive(val)) {
            return val;
        }
        return JavaInterop.asTruffleObject(val);
    }

    @CompilerDirectives.TruffleBoundary
    static Method findMethod(JavaObject object, String name, Object[] args) {
        for (Method m : object.clazz.getMethods()) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != args.length && !m.isVarArgs()) continue;
            return m;
        }
        return null;
    }

    private JavaInteropReflect() {
    }

    @CompilerDirectives.TruffleBoundary
    static Object newConstructor(Class<?> clazz, Object[] args) throws IllegalStateException, SecurityException {
        IllegalStateException ex = new IllegalStateException("No suitable constructor found for " + clazz);
        for (Constructor<?> constructor : clazz.getConstructors()) {
            try {
                Object ret = constructor.newInstance(args);
                if (ToJavaNode.isPrimitive(ret)) {
                    return ret;
                }
                return JavaInterop.asTruffleObject(ret);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException instEx) {
                ex = new IllegalStateException(instEx);
            }
        }
        throw ex;
    }

    @CompilerDirectives.TruffleBoundary
    static Field findField(JavaObject receiver, String name) {
        try {
            return receiver.clazz.getField(name);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static void setField(Object obj, Field f, Object convertedValue) {
        try {
            f.set(obj, convertedValue);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function) {
        SingleHandler handler = new SingleHandler(function);
        Object obj = Proxy.newProxyInstance(functionalType.getClassLoader(), new Class[]{functionalType}, (InvocationHandler)handler);
        return functionalType.cast(obj);
    }

    static TruffleObject asTruffleViaReflection(Object obj) throws IllegalArgumentException {
        InvocationHandler h;
        if (Proxy.isProxyClass(obj.getClass()) && (h = Proxy.getInvocationHandler(obj)) instanceof TruffleHandler) {
            return ((TruffleHandler)h).obj;
        }
        return new JavaObject(obj, obj.getClass());
    }

    static Object newProxyInstance(Class<?> clazz, TruffleObject obj) throws IllegalArgumentException {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new TruffleHandler(obj));
    }

    @CompilerDirectives.TruffleBoundary
    static String[] findPublicFieldsNames(Class<?> c) throws SecurityException {
        Class<?> clazz = c;
        while ((clazz.getModifiers() & 1) == 0) {
            clazz = clazz.getSuperclass();
        }
        Field[] fields = clazz.getFields();
        String[] names = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            names[i] = fields[i].getName();
        }
        return names;
    }

    private static Message findMessage(MethodMessage mm) {
        CompilerAsserts.neverPartOfCompilation();
        if (mm == null) {
            return null;
        }
        return Message.valueOf(mm.message());
    }

    private static Object toJava(Object ret, Method method) {
        return ToJavaNode.toJava(ret, TypeAndClass.forReturnType(method));
    }

    private static final class TruffleHandler
    implements InvocationHandler {
        final TruffleObject obj;

        TruffleHandler(TruffleObject obj) {
            this.obj = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            CompilerAsserts.neverPartOfCompilation();
            TypeAndClass<?> convertTo = TypeAndClass.forReturnType(method);
            Object[] args = arguments == null ? EMPTY : arguments;
            for (int i = 0; i < args.length; ++i) {
                args[i] = JavaInterop.asTruffleValue(args[i]);
            }
            if (Object.class == method.getDeclaringClass()) {
                return method.invoke((Object)this.obj, args);
            }
            String name = method.getName();
            Message message = JavaInteropReflect.findMessage(method.getAnnotation(MethodMessage.class));
            if (message == Message.WRITE) {
                if (args.length != 1) {
                    throw new IllegalStateException("Method needs to have a single argument to handle WRITE message " + method);
                }
                ToJavaNode.message(null, Message.WRITE, this.obj, name, args[0]);
                return null;
            }
            if (message == Message.HAS_SIZE || message == Message.IS_BOXED || message == Message.IS_EXECUTABLE || message == Message.IS_NULL || message == Message.GET_SIZE) {
                return ToJavaNode.message(null, message, this.obj, new Object[0]);
            }
            if (message == Message.READ) {
                Object val = ToJavaNode.message(convertTo, Message.READ, this.obj, name);
                return JavaInteropReflect.toJava(val, method);
            }
            if (message == Message.UNBOX) {
                Object val = ToJavaNode.message(null, Message.UNBOX, this.obj, new Object[0]);
                return JavaInteropReflect.toJava(val, method);
            }
            if (Message.createExecute(0).equals(message)) {
                ArrayList<Object> copy = new ArrayList<Object>(args.length);
                copy.addAll(Arrays.asList(args));
                message = Message.createExecute(copy.size());
                Object val = ToJavaNode.message(convertTo, message, this.obj, copy.toArray());
                return JavaInteropReflect.toJava(val, method);
            }
            if (Message.createInvoke(0).equals(message)) {
                ArrayList<Object> copy = new ArrayList<Object>(args.length + 1);
                copy.add(name);
                copy.addAll(Arrays.asList(args));
                message = Message.createInvoke(args.length);
                Object val = ToJavaNode.message(convertTo, message, this.obj, copy.toArray());
                return JavaInteropReflect.toJava(val, method);
            }
            if (Message.createNew(0).equals(message)) {
                message = Message.createNew(args.length);
                Object val = ToJavaNode.message(convertTo, message, this.obj, args);
                return JavaInteropReflect.toJava(val, method);
            }
            if (message == null) {
                Object ret;
                try {
                    ArrayList<Object> callArgs = new ArrayList<Object>(args.length);
                    callArgs.add(name);
                    callArgs.addAll(Arrays.asList(args));
                    ret = ToJavaNode.message(convertTo, Message.createInvoke(args.length), this.obj, callArgs.toArray());
                }
                catch (InteropException ex) {
                    Object val = ToJavaNode.message(null, Message.READ, this.obj, name);
                    Object primitiveVal = ToJavaNode.toPrimitive(val, method.getReturnType());
                    if (primitiveVal != null) {
                        return primitiveVal;
                    }
                    TruffleObject attr = (TruffleObject)val;
                    if (Boolean.FALSE.equals(ToJavaNode.message(null, Message.IS_EXECUTABLE, attr, new Object[0]))) {
                        if (args.length == 0) {
                            return JavaInteropReflect.toJava(attr, method);
                        }
                        throw new IllegalArgumentException(attr + " cannot be invoked with " + args.length + " parameters");
                    }
                    ArrayList<Object> callArgs = new ArrayList<Object>(args.length);
                    callArgs.addAll(Arrays.asList(args));
                    ret = ToJavaNode.message(convertTo, Message.createExecute(callArgs.size()), attr, callArgs.toArray());
                }
                return JavaInteropReflect.toJava(ret, method);
            }
            throw new IllegalArgumentException("Unknown message: " + message);
        }
    }

    private static final class SingleHandler
    implements InvocationHandler {
        private final TruffleObject symbol;
        private CallTarget target;

        SingleHandler(TruffleObject obj) {
            this.symbol = obj;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
            Object ret;
            if (method.isVarArgs()) {
                if (arguments.length == 1) {
                    ret = this.call((Object[])arguments[0], method);
                } else {
                    int allButOne = arguments.length - 1;
                    Object[] last = (Object[])arguments[allButOne];
                    Object[] merge = new Object[allButOne + last.length];
                    System.arraycopy(arguments, 0, merge, 0, allButOne);
                    System.arraycopy(last, 0, merge, allButOne, last.length);
                    ret = this.call(merge, method);
                }
            } else {
                ret = this.call(arguments, method);
            }
            return JavaInteropReflect.toJava(ret, method);
        }

        private Object call(Object[] arguments, Method method) {
            Object[] args;
            CompilerAsserts.neverPartOfCompilation();
            Object[] objectArray = args = arguments == null ? EMPTY : arguments;
            if (this.target == null) {
                Node executeMain = Message.createExecute(args.length).createNode();
                ToJavaNode.TemporaryRoot symbolNode = new ToJavaNode.TemporaryRoot(TruffleLanguage.class, executeMain, this.symbol, TypeAndClass.forReturnType(method));
                this.target = Truffle.getRuntime().createCallTarget(symbolNode);
            }
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof TruffleObject || ToJavaNode.isPrimitive(args[i])) continue;
                arguments[i] = JavaInterop.asTruffleObject(args[i]);
            }
            return this.target.call(args);
        }
    }
}

