/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.platform;

import com.oracle.truffle.api.TruffleOptions;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.platform.NativePlatform;
import org.jruby.truffle.platform.Platform;
import org.jruby.truffle.platform.darwin.DarwinPlatform;
import org.jruby.truffle.platform.java.JavaPlatform;
import org.jruby.truffle.platform.linux.LinuxPlatform;
import org.jruby.truffle.platform.solaris.SolarisPlatform;

public abstract class NativePlatformFactory {
    private static final Platform.OS_TYPE OS = Platform.getPlatform().getOS();

    public static NativePlatform createPlatform(RubyContext context) {
        if (!TruffleOptions.AOT && (context.getOptions().PLATFORM_USE_JAVA || OS == Platform.OS_TYPE.WINDOWS)) {
            return new JavaPlatform(context);
        }
        if (OS == Platform.OS_TYPE.LINUX) {
            return new LinuxPlatform(context);
        }
        if (OS == Platform.OS_TYPE.SOLARIS) {
            return new SolarisPlatform(context);
        }
        if (OS == Platform.OS_TYPE.DARWIN) {
            return new DarwinPlatform(context);
        }
        throw new UnsupportedOperationException();
    }
}

