/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.SinceKotlinInfo;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000b\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/config/ApiVersion;", "", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "versionString", "", "(Lorg/jetbrains/kotlin/config/MavenComparableVersion;Ljava/lang/String;)V", "getVersionString", "()Ljava/lang/String;", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "Companion", "kotlin-compiler"})
public final class ApiVersion
implements Comparable<ApiVersion> {
    private final MavenComparableVersion version;
    @NotNull
    private final String versionString;
    @JvmField
    @NotNull
    public static final ApiVersion LATEST;
    public static final Companion Companion;

    @Override
    public int compareTo(@NotNull ApiVersion other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.version.compareTo(other.version);
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (!(object instanceof ApiVersion)) {
            object = null;
        }
        ApiVersion apiVersion = (ApiVersion)object;
        return Intrinsics.areEqual(apiVersion != null ? apiVersion.version : null, this.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    @NotNull
    public String toString() {
        return this.versionString;
    }

    @NotNull
    public final String getVersionString() {
        return this.versionString;
    }

    private ApiVersion(MavenComparableVersion version, String versionString) {
        this.version = version;
        this.versionString = versionString;
    }

    static {
        Companion = new Companion(null);
        LATEST = Companion.createByLanguageVersion(LanguageVersion.LATEST);
    }

    public /* synthetic */ ApiVersion(@NotNull MavenComparableVersion version, @NotNull String versionString, DefaultConstructorMarker $constructor_marker) {
        this(version, versionString);
    }

    @JvmStatic
    @NotNull
    public static final ApiVersion createByLanguageVersion(@NotNull LanguageVersion version) {
        Intrinsics.checkParameterIsNotNull(version, "version");
        return Companion.createByLanguageVersion(version);
    }

    @JvmStatic
    @NotNull
    public static final ApiVersion createBySinceKotlinInfo(@NotNull SinceKotlinInfo sinceKotlinInfo) {
        Intrinsics.checkParameterIsNotNull(sinceKotlinInfo, "sinceKotlinInfo");
        return Companion.createBySinceKotlinInfo(sinceKotlinInfo);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/config/ApiVersion$Companion;", "", "()V", "LATEST", "Lorg/jetbrains/kotlin/config/ApiVersion;", "createByLanguageVersion", "version", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "createBySinceKotlinInfo", "sinceKotlinInfo", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/SinceKotlinInfo;", "parse", "versionString", "", "kotlin-compiler"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final ApiVersion createByLanguageVersion(@NotNull LanguageVersion version) {
            Intrinsics.checkParameterIsNotNull(version, "version");
            ApiVersion apiVersion = this.parse(version.getVersionString());
            if (apiVersion == null) {
                Intrinsics.throwNpe();
            }
            return apiVersion;
        }

        @JvmStatic
        @NotNull
        public final ApiVersion createBySinceKotlinInfo(@NotNull SinceKotlinInfo sinceKotlinInfo) {
            Intrinsics.checkParameterIsNotNull(sinceKotlinInfo, "sinceKotlinInfo");
            SinceKotlinInfo.Version version = sinceKotlinInfo.getVersion();
            SinceKotlinInfo.Version version2 = version;
            ApiVersion apiVersion = Companion.parse(version2.asString());
            if (apiVersion == null) {
                String string = "Could not parse version: " + version2;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return apiVersion;
        }

        @Nullable
        public final ApiVersion parse(@NotNull String versionString) {
            ApiVersion apiVersion;
            Intrinsics.checkParameterIsNotNull(versionString, "versionString");
            try {
                apiVersion = new ApiVersion(new MavenComparableVersion(versionString), versionString, null);
            }
            catch (Exception e) {
                apiVersion = null;
            }
            return apiVersion;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

