/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileKotlinClassFinder;", "Lorg/jetbrains/kotlin/load/kotlin/JvmVirtualFileFinder;", "()V", "classFileName", "", "jClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "findKotlinClass", "Lorg/jetbrains/kotlin/load/kotlin/KotlinJvmBinaryClass;", "javaClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "kotlin-compiler"})
public abstract class VirtualFileKotlinClassFinder
implements JvmVirtualFileFinder {
    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        VirtualFile virtualFile = this.findVirtualFileWithHeader(classId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClass$default(KotlinBinaryClassCache.Companion, file, null, 2, null);
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass findKotlinClass(@NotNull JavaClass javaClass) {
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        JavaClass javaClass2 = javaClass;
        if (javaClass2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl");
        }
        UserDataHolder userDataHolder = ((PsiClass)((JavaClassImpl)javaClass2).getPsi()).getContainingFile();
        if (userDataHolder == null || (userDataHolder = userDataHolder.getVirtualFile()) == null) {
            return null;
        }
        UserDataHolder file = userDataHolder;
        if (((JavaClassImpl)javaClass).getOuterClass() != null) {
            VirtualFile virtualFile = ((VirtualFile)file).getParent();
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile $receiver$iv = virtualFile.findChild(this.classFileName(javaClass) + ".class");
            VirtualFile virtualFile2 = $receiver$iv;
            if (virtualFile2 == null) {
                AssertionError assertionError;
                AssertionError assertionError2 = assertionError;
                AssertionError assertionError3 = assertionError;
                String string = "Virtual file not found for " + javaClass;
                assertionError2((Object)string);
                throw (Throwable)((Object)assertionError3);
            }
            Intrinsics.checkExpressionValueIsNotNull(virtualFile2, "file.parent!!.findChild(\u2026t found for $javaClass\" }");
            file = virtualFile2;
        }
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClass$default(KotlinBinaryClassCache.Companion, (VirtualFile)file, null, 2, null);
    }

    private final String classFileName(JavaClass jClass) {
        JavaClass javaClass = jClass.getOuterClass();
        if (javaClass == null) {
            String string = jClass.getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "jClass.name.asString()");
            return string;
        }
        JavaClass outerClass = javaClass;
        return this.classFileName(outerClass) + "$" + jClass.getName().asString();
    }
}

