/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747StringTokenizer;
import gps.convert.Conv;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class NMEALogConvert
extends GPSLogConvertInterface {
    private int logFormat;
    private boolean passToFindFieldsActivatedInLog = false;
    private int activeFileFields = 0;
    private int error;

    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        object = (WindowedFile)object;
        Object object2 = GPSRecord.getLogFormatRecord(0);
        int n = 0;
        try {
            int n2;
            int n3 = 0;
            this.logFormat = 0;
            int n4 = 0;
            int n5 = 0;
            ((WindowedFile)object).getSize();
            try {
                n2 = ((WindowedFile)object).getSize();
            }
            catch (Exception exception) {
                Generic.debug("getSize", exception);
                n2 = 0;
            }
            while (!this.stop && n5 < n2) {
                boolean bl;
                byte[] byArray;
                int n6 = 2048;
                if (n5 + 2048 > n2) {
                    n6 = n2 - n5;
                }
                int n7 = 0;
                try {
                    byArray = ((WindowedFile)object).fillBuffer(n5);
                }
                catch (Exception exception) {
                    Generic.debug("Problem reading file", exception);
                    byArray = null;
                }
                if (byArray == null) {
                    this.errorInfo = ((WindowedFile)object).getPath() + "|" + ((WindowedFile)object).getLastError();
                    return -3;
                }
                n5 += n6;
                do {
                    int n8;
                    for (n8 = n7; n8 < n6 && (byArray[n8] == 10 || byArray[n8] == 13); ++n8) {
                    }
                    while (n8 < n6 && byArray[n8] != 10 && byArray[n8] != 13) {
                        ++n8;
                    }
                    bl = n8 < n6;
                    if (!bl) continue;
                    String[] stringArray = new StringBuffer(n8 - n7 + 1);
                    int n9 = 0;
                    String string = "";
                    int n10 = byArray[n7];
                    for (int i = n7 + 1; i < n8 - 3; ++i) {
                        stringArray.append((char)byArray[i]);
                        n9 = (byte)(n9 ^ byArray[i]);
                    }
                    try {
                        string = string + (char)byArray[n8 - 2];
                        string = string + (char)byArray[n8 - 1];
                    }
                    catch (Exception exception) {
                        Generic.debug("eolPos " + n8, exception);
                    }
                    n9 = (byte)(n9 ^ Conv.hex2Int(string));
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(stringArray.toString(), ',');
                    for (n7 = n8; n7 < n6 && (byArray[n7] == 10 || byArray[n7] == 13); ++n7) {
                    }
                    if (n10 != 36 || byArray[n8 - 3] != 42 || n9 != 0 || stringArray.length() == 0 || !bT747StringTokenizer.hasMoreTokens()) continue;
                    Object object3 = bT747StringTokenizer.nextToken();
                    stringArray = new String[bT747StringTokenizer.countTokens() + 1];
                    n9 = 0;
                    ++n9;
                    stringArray[0] = object3;
                    while (bT747StringTokenizer.hasMoreTokens()) {
                        stringArray[n9++] = bT747StringTokenizer.nextToken();
                    }
                    object3 = GPSRecord.getLogFormatRecord(0);
                    n9 = CommonIn.analyzeNMEA(stringArray, (GPSRecord)object3);
                    if ((n9 & 1) != 0 && (n4 & 1) != 0) {
                        n10 = ((GPSRecord)object2).utc % 86400;
                        int n11 = (((GPSRecord)object2).utc - n10) / 86400;
                        int n12 = ((GPSRecord)object3).utc / 86400;
                        if (n10 != 0 && n10 != ((GPSRecord)object3).utc % 86400 || n11 != 0 && n12 != 0 && n11 != n12 || ((GPSRecord)object2).milisecond != ((GPSRecord)object3).milisecond) {
                            ((GPSRecord)object2).recCount = ++n3;
                            if (n11 == 0 && n != 0) {
                                ((GPSRecord)object2).utc += n * 24 * 3600;
                            } else {
                                n = n11;
                            }
                            this.finalizeRecord(gPSFileConverterInterface, (GPSRecord)object2, n4);
                            object2 = object3;
                            n4 = n9;
                            continue;
                        }
                        n4 |= CommonIn.analyzeNMEA(stringArray, (GPSRecord)object2);
                        continue;
                    }
                    n4 |= CommonIn.analyzeNMEA(stringArray, (GPSRecord)object2);
                } while (bl);
                n5 -= n6 - n7;
            }
            if (n4 != 0) {
                ((GPSRecord)object2).recCount = ++n3;
                int n13 = ((GPSRecord)object2).utc % 86400;
                if ((((GPSRecord)object2).utc - n13) / 86400 == 0 && n != 0) {
                    ((GPSRecord)object2).utc += n * 3600 * 24;
                }
                this.finalizeRecord(gPSFileConverterInterface, (GPSRecord)object2, n4);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    private void finalizeRecord(GPSFileConverterInterface gPSFileConverterInterface, GPSRecord gPSRecord, int n) {
        CommonIn.convertHeight(gPSRecord, this.factorConversionWGS84ToMSL);
        if (n != this.logFormat) {
            int n2 = n;
            GPSFileConverterInterface gPSFileConverterInterface2 = gPSFileConverterInterface;
            NMEALogConvert nMEALogConvert = this;
            this.logFormat = n2;
            nMEALogConvert.activeFileFields |= nMEALogConvert.logFormat;
            if (!nMEALogConvert.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface2.writeLogFmtHeader(GPSRecord.getLogFormatRecord(nMEALogConvert.logFormat));
            }
        }
        if (!gPSRecord.hasValid()) {
            gPSRecord.valid = 2;
        }
        if (n != 0 && !this.passToFindFieldsActivatedInLog) {
            gPSFileConverterInterface.addLogRecord(gPSRecord);
        }
    }

    protected final Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(2048);
                this.errorInfo = bT747Path + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    protected final void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    public final int toGPSFile(BT747Path object, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            object = this.getFileObject((BT747Path)object);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    this.activeFileFields = 0;
                    this.error = this.parseFile(object, gPSFileConverterInterface);
                    gPSFileConverterInterface.setActiveFileFields(GPSRecord.getLogFormatRecord(this.activeFileFields));
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    public final int getType() {
        return 5;
    }
}

