/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.FindContextNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class TruffleLanguage<C> {
    static final AccessAPI API = new AccessAPI();

    protected TruffleLanguage() {
    }

    protected abstract C createContext(Env var1);

    protected void initializeContext(C context) throws Exception {
    }

    protected void disposeContext(C context) {
    }

    protected abstract CallTarget parse(Source var1, Node var2, String ... var3) throws Exception;

    protected abstract Object findExportedSymbol(C var1, String var2, boolean var3);

    protected abstract Object getLanguageGlobal(C var1);

    protected abstract boolean isObjectOfLanguage(Object var1);

    protected abstract Object evalInContext(Source var1, Node var2, MaterializedFrame var3) throws Exception;

    protected String toString(C context, Object value) {
        return Objects.toString(value);
    }

    protected final Node createFindContextNode() {
        return AccessAPI.engineAccess().createFindContextNode(this);
    }

    protected final C findContext(Node n) {
        FindContextNode fcn = (FindContextNode)n;
        if (fcn.getTruffleLanguage() != this) {
            throw new ClassCastException();
        }
        return fcn.executeFindContext();
    }

    static final class LanguageImpl
    extends Accessor.LanguageSupport {
        LanguageImpl() {
        }

        @Override
        public Env attachEnv(Object vm, TruffleLanguage<?> language, OutputStream stdOut, OutputStream stdErr, InputStream stdIn, Map<String, Object> config) {
            Env env = new Env(vm, language, stdOut, stdErr, stdIn, config);
            return env;
        }

        @Override
        public CallTarget parse(TruffleLanguage<?> truffleLanguage, Source code, Node context, String ... argumentNames) {
            try {
                return truffleLanguage.parse(code, context, argumentNames);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void postInitEnv(Env env) {
            env.postInit();
        }

        @Override
        public Object evalInContext(Object sourceVM, String code, Node node, MaterializedFrame frame) {
            RootNode rootNode = node.getRootNode();
            Class<? extends TruffleLanguage> languageType = AccessAPI.nodesAccess().findLanguage(rootNode);
            Env env = AccessAPI.engineAccess().findEnv(sourceVM, languageType);
            TruffleLanguage<?> lang = this.findLanguage(env);
            Source source = Source.newBuilder(code).name("eval in context").mimeType("content/unknown").build();
            try {
                return lang.evalInContext(source, node, frame);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }

        @Override
        public Object findExportedSymbol(Env env, String globalName, boolean onlyExplicit) {
            return env.langCtx.findExportedSymbol(globalName, onlyExplicit);
        }

        @Override
        public TruffleLanguage<?> findLanguage(Env env) {
            return env.lang;
        }

        @Override
        public Object languageGlobal(Env env) {
            return env.langCtx.getLanguageGlobal();
        }

        @Override
        public Object findContext(Env env) {
            return ((Env)env).langCtx.ctx;
        }

        @Override
        public void dispose(TruffleLanguage<?> impl, Env env) {
            assert (impl == ((Env)env).langCtx.lang);
            env.langCtx.dispose();
        }

        @Override
        public String toString(TruffleLanguage<?> language, Env env, Object obj) {
            return env.langCtx.toString(language, obj);
        }

        @Override
        public Object getVM(Env env) {
            return env.vm;
        }
    }

    private static final class AccessAPI
    extends Accessor {
        private AccessAPI() {
        }

        static Accessor.Nodes nodesAccess() {
            return API.nodes();
        }

        static Accessor.EngineSupport engineAccess() {
            return API.engineSupport();
        }

        static Accessor.InstrumentSupport instrumentAccess() {
            return API.instrumentSupport();
        }

        @Override
        protected Accessor.LanguageSupport languageSupport() {
            return new LanguageImpl();
        }
    }

    public static final class Env {
        private final Object vm;
        private final TruffleLanguage<?> lang;
        private final LangCtx<?> langCtx;
        private final InputStream in;
        private final OutputStream err;
        private final OutputStream out;
        private final List<Object> services;
        private final Map<String, Object> config;

        Env(Object vm, TruffleLanguage<?> lang, OutputStream out, OutputStream err, InputStream in, Map<String, Object> config) {
            this.vm = vm;
            this.in = in;
            this.err = err;
            this.out = out;
            this.lang = lang;
            LinkedHashSet<Object> collectedServices = new LinkedHashSet<Object>();
            AccessAPI.instrumentAccess().collectEnvServices(collectedServices, vm, lang, this);
            this.services = new ArrayList<Object>(collectedServices);
            this.config = config;
            this.langCtx = new LangCtx(lang, this);
        }

        public Object importSymbol(String globalName) {
            return AccessAPI.engineAccess().importSymbol(this.vm, this.lang, globalName);
        }

        public boolean isMimeTypeSupported(String mimeType) {
            return AccessAPI.engineAccess().isMimeTypeSupported(this.vm, mimeType);
        }

        public CallTarget parse(Source source, String ... argumentNames) {
            TruffleLanguage<?> language = AccessAPI.engineAccess().findLanguageImpl(this.vm, null, source.getMimeType());
            try {
                return language.parse(source, null, argumentNames);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }

        public InputStream in() {
            return this.in;
        }

        public OutputStream out() {
            return this.out;
        }

        public OutputStream err() {
            return this.err;
        }

        public <T> T lookup(Class<T> type) {
            for (Object obj : this.services) {
                if (!type.isInstance(obj)) continue;
                return type.cast(obj);
            }
            return null;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        void postInit() {
            this.langCtx.postInit();
        }
    }

    private static final class LangCtx<C> {
        final TruffleLanguage<C> lang;
        final C ctx;

        LangCtx(TruffleLanguage<C> lang, Env env) {
            this.lang = lang;
            this.ctx = lang.createContext(env);
        }

        Object findExportedSymbol(String globalName, boolean onlyExplicit) {
            return this.lang.findExportedSymbol(this.ctx, globalName, onlyExplicit);
        }

        Object getLanguageGlobal() {
            return this.lang.getLanguageGlobal(this.ctx);
        }

        void dispose() {
            this.lang.disposeContext(this.ctx);
        }

        String toString(TruffleLanguage<?> language, Object obj) {
            assert (this.lang == language);
            return this.lang.toString(this.ctx, obj);
        }

        void postInit() {
            try {
                this.lang.initializeContext(this.ctx);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String name();

        public String version();

        public String[] mimeType();
    }
}

