/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import org.jruby.truffle.Log;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.loader.ReentrantLockFreeingMap;

public class FeatureLoader {
    private final RubyContext context;
    private final ReentrantLockFreeingMap<String> fileLocks = new ReentrantLockFreeingMap();
    private final Object cextImplementationLock = new Object();
    private boolean cextImplementationLoaded = false;
    private final Object loadedFeaturesLock = new Object();

    public FeatureLoader(RubyContext context) {
        this.context = context;
    }

    public ReentrantLockFreeingMap<String> getFileLocks() {
        return this.fileLocks;
    }

    @CompilerDirectives.TruffleBoundary
    public String findFeature(String feature) {
        String currentDirectory = this.context.getNativePlatform().getPosix().getcwd();
        if (feature.startsWith("./")) {
            feature = currentDirectory + "/" + feature.substring(2);
        } else if (feature.startsWith("../")) {
            feature = currentDirectory.substring(0, currentDirectory.lastIndexOf(47)) + "/" + feature.substring(3);
        }
        if (feature.startsWith("truffle:") || feature.startsWith("jruby:") || new File(feature).isAbsolute()) {
            return this.findFeatureWithAndWithoutExtension(feature);
        }
        for (Object pathObject : ArrayOperations.toIterable(this.context.getCoreLibrary().getLoadPath())) {
            String fileWithinPath = new File(pathObject.toString(), feature).getPath();
            String result = this.findFeatureWithAndWithoutExtension(fileWithinPath);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private String findFeatureWithAndWithoutExtension(String path) {
        String base;
        String asSO;
        if (path.endsWith(".so") && (asSO = this.findFeatureWithExactPath((base = path.substring(0, path.length() - 3)) + ".su")) != null) {
            return asSO;
        }
        String withExtension = this.findFeatureWithExactPath(path + ".rb");
        if (withExtension != null) {
            return withExtension;
        }
        String asSU = this.findFeatureWithExactPath(path + ".su");
        if (asSU != null) {
            return asSU;
        }
        String withoutExtension = this.findFeatureWithExactPath(path);
        if (withoutExtension != null) {
            return withoutExtension;
        }
        return null;
    }

    private String findFeatureWithExactPath(String path) {
        if (path.startsWith("truffle:") || path.startsWith("jruby:")) {
            return path;
        }
        File file = new File(path);
        if (!file.isFile()) {
            return null;
        }
        try {
            if (file.isAbsolute()) {
                return file.getCanonicalPath();
            }
            return new File(this.context.getNativePlatform().getPosix().getcwd(), file.getPath()).getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private boolean isSulongAvailable() {
        return this.context.getEnv().isMimeTypeSupported("application/x-sulong-library");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureCExtImplementationLoaded(VirtualFrame frame, String feature, IndirectCallNode callNode) {
        Object object = this.cextImplementationLock;
        synchronized (object) {
            if (this.cextImplementationLoaded) {
                return;
            }
            if (!this.isSulongAvailable()) {
                throw new RaiseException(this.context.getCoreExceptions().loadError("Sulong is required to support C extensions, and it doesn't appear to be available", feature, null));
            }
            CallTarget callTarget = this.getCExtLibRuby(feature);
            callNode.call(frame, callTarget, new Object[0]);
            this.cextImplementationLoaded = true;
        }
    }

    @CompilerDirectives.TruffleBoundary
    private CallTarget getCExtLibRuby(String feature) {
        String path = this.context.getRubyHome() + "/lib/ruby/truffle/cext/ruby.su";
        if (this.context.getOptions().CEXTS_LOG_LOAD) {
            Log.LOGGER.info(() -> String.format("loading cext implementation %s", path));
        }
        if (!new File(path).exists()) {
            throw new RaiseException(this.context.getCoreExceptions().loadError("This JRuby distribution does not have the C extension implementation file ruby.su", feature, null));
        }
        try {
            return this.parseSource(this.context.getSourceLoader().load(path));
        }
        catch (Exception e) {
            throw new JavaException(e);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public CallTarget parseSource(Source source) {
        try {
            return this.context.getEnv().parse(source, new String[0]);
        }
        catch (Exception e) {
            throw new JavaException(e);
        }
    }

    public Object getLoadedFeaturesLock() {
        return this.loadedFeaturesLock;
    }
}

