/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser;

import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.truffle.parser.ParserByteList;

public class ParserByteListBuilder {
    private byte[] bytes = new byte[16];
    private int length = 0;
    private Encoding encoding = ASCIIEncoding.INSTANCE;

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    public void append(int b) {
        this.append((byte)b);
    }

    public void append(byte b) {
        this.grow(1);
        this.bytes[this.length] = b;
        ++this.length;
    }

    public void append(byte[] bytes) {
        this.append(bytes, 0, bytes.length);
    }

    public void append(ParserByteList other) {
        this.append(other.getBytes());
    }

    public void append(byte[] appendBytes, int appendStart, int appendLength) {
        this.grow(appendLength);
        System.arraycopy(appendBytes, appendStart, this.bytes, this.length, appendLength);
        this.length += appendLength;
    }

    public void grow(int extra) {
        if (this.length + extra > this.bytes.length) {
            this.bytes = Arrays.copyOf(this.bytes, (this.length + extra) * 2);
        }
    }

    public byte[] getUnsafeBytes() {
        return this.bytes;
    }

    public ParserByteList toParserByteList() {
        return new ParserByteList(Arrays.copyOf(this.bytes, this.length), 0, this.length, this.encoding);
    }

    public void removeOffset(int offset) {
        System.arraycopy(this.bytes, offset, this.bytes, 0, this.length - offset);
        this.length -= offset;
    }
}

