/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineDecoration;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.IOException;

public class ArrowTip
implements LineDecoration {
    private double fAngle;
    private double fOuterRadius;
    private double fInnerRadius;
    private static final long serialVersionUID = -3459171428373823638L;
    private int arrowTipSerializedDataVersion = 1;

    public ArrowTip() {
        this.fAngle = 0.4;
        this.fOuterRadius = 8.0;
        this.fInnerRadius = 8.0;
    }

    public ArrowTip(double d, double d2, double d3) {
        this.fAngle = d;
        this.fOuterRadius = d2;
        this.fInnerRadius = d3;
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        Polygon polygon = this.outline(n, n2, n3, n4);
        graphics.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public Polygon outline(int n, int n2, int n3, int n4) {
        double d = 1.5707963267948966 - Math.atan2(n3 - n, n2 - n4);
        return this.outline(n, n2, d);
    }

    private Polygon outline(int n, int n2, double d) {
        Polygon polygon = new Polygon();
        polygon.addPoint(n, n2);
        this.addPointRelative(polygon, n, n2, this.fOuterRadius, d - this.fAngle);
        this.addPointRelative(polygon, n, n2, this.fInnerRadius, d);
        this.addPointRelative(polygon, n, n2, this.fOuterRadius, d + this.fAngle);
        polygon.addPoint(n, n2);
        return polygon;
    }

    private void addPointRelative(Polygon polygon, int n, int n2, double d, double d2) {
        polygon.addPoint(n + (int)(d * Math.cos(d2)), n2 - (int)(d * Math.sin(d2)));
    }

    public void write(StorableOutput storableOutput) {
    }

    public String getMap() {
        return "";
    }

    public void read(StorableInput storableInput) throws IOException {
    }
}

