/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.TransformationMethodVisitor;
import org.jetbrains.kotlin.codegen.optimization.DeadCodeEliminationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.FixStackWithLabelNormalizationMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.RedundantGotoMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantBoxingMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantCoercionToUnitTransformer;
import org.jetbrains.kotlin.codegen.optimization.boxing.RedundantNullCheckMethodTransformer;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.codegen.optimization.transformer.MethodTransformer;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

public class OptimizationMethodVisitor
extends TransformationMethodVisitor {
    private static final MethodTransformer MANDATORY_METHOD_TRANSFORMER = new FixStackWithLabelNormalizationMethodTransformer();
    private static final MethodTransformer[] OPTIMIZATION_TRANSFORMERS = new MethodTransformer[]{new RedundantNullCheckMethodTransformer(), new RedundantBoxingMethodTransformer(), new DeadCodeEliminationMethodTransformer(), new RedundantGotoMethodTransformer(), new RedundantCoercionToUnitTransformer()};
    private final boolean disableOptimization;

    public OptimizationMethodVisitor(@NotNull MethodVisitor delegate2, boolean disableOptimization, int access, @NotNull String name2, @NotNull String desc, @Nullable String signature2, @Nullable String[] exceptions) {
        if (delegate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "<init>"));
        }
        if (desc == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "<init>"));
        }
        super(delegate2, access, name2, desc, signature2, exceptions);
        this.disableOptimization = disableOptimization;
    }

    @Override
    protected void performTransformations(@NotNull MethodNode methodNode) {
        if (methodNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodNode", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "performTransformations"));
        }
        MANDATORY_METHOD_TRANSFORMER.transform("fake", methodNode);
        if (OptimizationMethodVisitor.canBeOptimized(methodNode) && !this.disableOptimization) {
            for (MethodTransformer transformer : OPTIMIZATION_TRANSFORMERS) {
                transformer.transform("fake", methodNode);
            }
        }
        UtilKt.prepareForEmitting(methodNode);
    }

    private static boolean canBeOptimized(@NotNull MethodNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/codegen/optimization/OptimizationMethodVisitor", "canBeOptimized"));
        }
        int totalFramesSizeMb = node.instructions.size() * (node.maxLocals + node.maxStack) / 0x100000;
        return totalFramesSizeMb < 50;
    }
}

