/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialog;

class NBOFileHandler
extends JPanel {
    protected static final String sep = System.getProperty("line.separator");
    protected static final String EXTENSIONS = "31;32;33;34;35;36;37;38;39;40;41;42;46;nbo";
    protected static final String[] EXT_ARRAY = PT.split("31;32;33;34;35;36;37;38;39;40;41;42;46;nbo", ";");
    protected JTextField tfDir;
    protected JTextField tfName;
    protected JTextField tfExt;
    protected File inputFile;
    protected String fileDir;
    protected String jobStem;
    protected String useExt;
    protected JButton browse;
    protected NBODialog dialog;
    protected boolean canReRun;
    protected static final int MODE_MODEL_USE = 1;
    protected static final int MODE_RUN = 2;
    protected static final int MODE_VIEW = 3;
    protected static final int MODE_SEARCH = 4;
    protected static final int MODE_MODEL_SAVE = 5;

    public NBOFileHandler(String name, String ext, int mode, String useExt, NBODialog d) {
        this.dialog = d;
        this.canReRun = true;
        Properties props = JmolPanel.historyFile.getProperties();
        this.fileDir = props.getProperty("workingPath", System.getProperty("user.home"));
        this.useExt = useExt;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        this.tfDir = new JTextField();
        this.tfDir.setPreferredSize(new Dimension(110, 20));
        this.tfDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOFileHandler.this.browsePressed();
            }
        });
        this.tfDir.setText(this.fileDir);
        this.add((Component)this.tfDir, c);
        c.gridx = 1;
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(100, 20));
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOFileHandler.this.browsePressed();
            }
        });
        this.tfName.setText(name);
        this.add((Component)this.tfName, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add((Component)new JLabel("         folder"), c);
        c.gridx = 1;
        this.add((Component)new JLabel("          name"), c);
        c.gridx = 2;
        c.gridy = 0;
        this.tfExt = new JTextField();
        this.tfExt.setPreferredSize(new Dimension(40, 20));
        this.tfExt.setText(ext);
        this.tfExt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOFileHandler.this.browsePressed();
            }
        });
        if (mode != 3 && mode != 4) {
            this.add((Component)this.tfExt, c);
            c.gridy = 1;
            this.add((Component)new JLabel("  ext"), c);
        }
        c.gridx = 3;
        c.gridy = 0;
        c.gridheight = 2;
        this.browse = new JButton(mode == 5 ? "Save" : "Browse");
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NBOFileHandler.this.browsePressed();
            }
        });
        this.add((Component)this.browse, c);
        this.jobStem = name;
        this.setInput(this.fileDir, name, ext);
    }

    protected boolean browsePressed() {
        int i;
        if (this.dialog.nboService.isWorking && this.dialog.statusLab.getText().startsWith("Running") && (i = JOptionPane.showConfirmDialog(this.dialog, "Warning, changing jobs while running GenNBO can effect output files.\nContinue anyway?")) == 1) {
            return false;
        }
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt));
        myChooser.setFileHidingEnabled(true);
        String folder = this.tfDir.getText();
        String name = this.tfName.getText();
        if (!folder.equals("")) {
            if (!folder.contains(":")) {
                folder = "C:/" + folder;
            }
            this.fileDir = folder + "/" + (name.equals("") ? " " : name);
        }
        myChooser.setSelectedFile(new File(this.fileDir));
        int button = myChooser.showDialog(this, GT._("Select"));
        if (button == 0) {
            return this.loadSelectedFile(myChooser.getSelectedFile());
        }
        return true;
    }

    private boolean loadSelectedFile(File selectedFile) {
        this.dialog.nboService.restart();
        this.inputFile = selectedFile;
        if (this.dialog.dialogMode == 'm') {
            return true;
        }
        if (!this.useExt.equals("47")) {
            this.jobStem = NBOFileHandler.getJobStem(this.inputFile);
            this.dialog.loadModelFromNBO(this.fileDir, this.jobStem, this.useExt);
            this.tfName.setText(this.jobStem);
            this.tfExt.setText(this.useExt);
            return true;
        }
        this.canReRun = true;
        this.setInputFile(this.inputFile);
        this.dialog.log("Job: " + this.jobStem, 'b');
        this.fileDir = this.inputFile.getParent();
        this.saveWorkHistory();
        return true;
    }

    protected void setInputFile(File inputFile) {
        this.clearInputFile();
        this.dialog.isOpenShell = false;
        this.inputFile = inputFile;
        if (inputFile.getName().indexOf(".") > 0) {
            this.jobStem = NBOFileHandler.getJobStem(inputFile);
        }
        this.setInput(inputFile.getParent(), this.jobStem, this.useExt);
        if (NBOFileHandler.getExt(inputFile).equals("47")) {
            if ((inputFile.getParent() + "/").equals(this.dialog.nboService.serverDir)) {
                JOptionPane.showMessageDialog(this, "Select a directory that does not contain the NBOServe executable,\nor select a new location for your NBOServe executable");
                return;
            }
            this.dialog.isJmolNBO = true;
            this.fileDir = inputFile.getParent();
            boolean canLoad = true;
            for (String x : EXT_ARRAY) {
                File f3 = NBOFileHandler.newNBOFile(inputFile, x);
                if (f3.exists() || this.dialog.dialogMode == 'm') continue;
                if (this.dialog.dialogMode != 'r') {
                    if (this.canReRun) {
                        this.canReRun = false;
                        this.dialog.runJob("PLOT", inputFile, "gennbo");
                    } else {
                        this.dialog.alertError("Error occurred during run");
                    }
                    return;
                }
                canLoad = false;
            }
            if (canLoad) {
                this.dialog.loadFromHandler(new File(this.fileDir + "/" + this.jobStem + ".47"));
            } else if (this.dialog.dialogMode == 'r') {
                this.dialog.loadModelFromNBO(this.fileDir, this.jobStem, this.useExt);
                this.tfName.setText(this.jobStem);
                this.tfExt.setText("47");
            }
        }
    }

    protected String[] read47File() {
        String[] fileData = new String[]{"", "", ""};
        String nboKeywords = "";
        SB data = new SB();
        if (!this.readFileBuffered(this.inputFile, data)) {
            return fileData;
        }
        String s = PT.trim(data.toString(), "\t\r\n ");
        String[] tokens = PT.split(s, "$END");
        if (tokens.length == 0) {
            return fileData;
        }
        SB preParams = new SB();
        SB postParams = new SB();
        SB params = preParams;
        int n = tokens.length - 1;
        for (int i = 0; i < n; ++i) {
            s = PT.trim(tokens[i], "\t\r\n ");
            if (params == preParams && s.indexOf("$NBO") >= 0) {
                String[] prePost = PT.split(s, "$NBO");
                if (prePost[0].length() > 0) {
                    params.append(s).append(sep);
                }
                nboKeywords = prePost[1];
                params = postParams;
                continue;
            }
            params.append(s).append(sep).append("$END").append(sep);
        }
        this.dialog.logInfo("$NBO: " + nboKeywords, 4);
        fileData[0] = preParams.toString();
        fileData[1] = nboKeywords;
        fileData[2] = postParams.toString();
        return fileData;
    }

    private boolean readFileBuffered(File inputFile, SB data) {
        try {
            String line;
            BufferedReader b = null;
            b = new BufferedReader(new FileReader(inputFile));
            while ((line = b.readLine()) != null) {
                data.append(line + sep);
            }
            b.close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected boolean getChooseList() {
        File f = NBOFileHandler.newNBOFile(this.inputFile, "nbo");
        if (!f.exists() || f.length() == 0L) {
            return false;
        }
        String fdata = this.getFileData(f.toString());
        String[] tokens = PT.split(fdata, "\n $CHOOSE");
        int i = 1;
        if (tokens.length < 2) {
            this.dialog.logInfo("$CHOOSE record was not found in " + f, 4);
            return false;
        }
        if (tokens[1].trim().startsWith("keylist")) {
            if (!tokens[1].contains("Structure accepted:")) {
                if (tokens[1].contains("missing END?")) {
                    this.dialog.logInfo("Plot files not found. Have you used RUN yet?", 2);
                    return false;
                }
                if (tokens[2].contains("ignoring")) {
                    this.dialog.alert("Ignoring $CHOOSE list");
                } else {
                    return false;
                }
            }
            i = 3;
        }
        String data = tokens[i].substring(0, tokens[i].indexOf("$END"));
        this.dialog.setChooseList(data);
        return true;
    }

    protected String[] getRSList() {
        String data = this.getFileData(NBOFileHandler.newNBOFile(this.inputFile, "nbo").toString());
        String[] toks = PT.split(data, "TOPO matrix for the leading resonance structure:\n");
        if (toks.length < 2) {
            if (toks[0].contains("0 candidate reference structure(s)")) {
                this.dialog.alertError("0 candidate reference structure(s) calculated by SR LEWISCandidate reference structure taken from NBO search");
            }
            return null;
        }
        String[] toks2 = PT.split(toks[1], "---------------------------------------------------------------------------");
        String[] rsList = new String[2];
        rsList[0] = toks2[0].substring(toks2[0].lastIndexOf(45), toks2[0].indexOf("Res")).trim();
        rsList[0] = rsList[0].replace("-\n", "");
        rsList[1] = toks2[1];
        return rsList;
    }

    public void clear() {
        this.tfName.setText("");
        this.tfExt.setText("");
    }

    protected static File newNBOFile(File f, String ext) {
        return new File(NBOFileHandler.pathWithoutExtension(f.toString().replace('\\', '/')) + "." + ext);
    }

    protected static String pathWithoutExtension(String fname) {
        int pt = fname.lastIndexOf(".");
        return pt < 0 ? fname : fname.substring(0, pt);
    }

    protected void clearInputFile() {
        this.inputFile = null;
        if (this.dialog.dialogMode == 'v') {
            this.dialog.resetView();
        }
    }

    protected static String getJobStem(File inputFile) {
        String fname = inputFile.getName();
        return fname.substring(0, fname.lastIndexOf("."));
    }

    protected void saveWorkHistory() {
        Properties props = new Properties();
        props.setProperty("workingPath", this.fileDir);
        JmolPanel.historyFile.addProperties(props);
    }

    protected void setInput(String dir, String name, String ext) {
        if (dir != null) {
            this.tfDir.setText(dir);
        }
        if (name != null) {
            this.tfName.setText(name);
        }
        if (this.tfExt != null) {
            this.tfExt.setText(ext);
        }
        if (this.dialog.saveFileHandler != null && this != this.dialog.saveFileHandler) {
            this.dialog.saveFileHandler.setInput(dir, name, PT.isOneOf(ext, "adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;mol;xyz;vfi;g09;com") ? ext : "");
        }
        if (dir != null && name != null && ext != null) {
            this.inputFile = new File(dir + "\\" + name + "." + ext);
        }
    }

    protected static String getExt(File newFile) {
        String fname = newFile.toString();
        return fname.substring(fname.lastIndexOf(".") + 1);
    }

    protected String getFileData(String fileName) {
        return this.dialog.vwr.getAsciiFileOrNull(fileName);
    }

    boolean writeToFile(String fileName, String s) {
        String ret = this.dialog.vwr.writeTextFile(fileName, s);
        return ret != null && ret.startsWith("OK");
    }
}

