/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.interop.java.ExecuteNodeSubNodeGen;
import com.oracle.truffle.api.interop.java.JavaFunctionMessageResolution;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

abstract class ExecuteNodeSub
extends JavaFunctionMessageResolution.ExecuteNode {
    ExecuteNodeSub() {
    }

    public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3);

    @Specialization
    protected Object accessWithTarget(VirtualFrame frame, JavaFunctionObject function, Object[] args) {
        return this.access(frame, function, args);
    }

    public static RootNode createRoot(Class<? extends TruffleLanguage<?>> language) {
        return new EXECUTERootNode(language);
    }

    private static final class EXECUTERootNode
    extends RootNode {
        @Node.Child
        private ExecuteNodeSub node = ExecuteNodeSubNodeGen.create();

        protected EXECUTERootNode(Class<? extends TruffleLanguage<?>> language) {
            super(language, null, null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            try {
                TruffleObject receiver = ForeignAccess.getReceiver(frame);
                List<Object> arguments = ForeignAccess.getArguments(frame);
                Object[] args = new Object[arguments.size()];
                for (int i = 0; i < arguments.size(); ++i) {
                    args[i] = arguments.get(i);
                }
                return this.node.executeWithTarget(frame, receiver, args);
            }
            catch (UnsupportedSpecializationException e) {
                if (e.getNode() instanceof ExecuteNodeSub) {
                    throw UnsupportedTypeException.raise(e, e.getSuppliedValues());
                }
                throw e;
            }
        }
    }
}

