/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodNodeManager;
import org.jruby.truffle.language.RubyNode;

public class AmbiguousOptionalArgumentChecker {
    public static boolean SUCCESS = true;
    private static boolean AVAILABLE = true;

    public static void verifyNoAmbiguousOptionalArguments(CoreMethodNodeManager.MethodDetails methodDetails) {
        if (!AVAILABLE) {
            return;
        }
        try {
            AmbiguousOptionalArgumentChecker.verifyNoAmbiguousOptionalArgumentsWithReflection(methodDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            SUCCESS = false;
        }
    }

    private static void verifyNoAmbiguousOptionalArgumentsWithReflection(CoreMethodNodeManager.MethodDetails methodDetails) {
        CoreMethod methodAnnotation = methodDetails.getMethodAnnotation();
        if (methodAnnotation.optional() > 0 || methodAnnotation.needsBlock()) {
            int opt = methodAnnotation.optional();
            if (methodAnnotation.needsBlock()) {
                ++opt;
            }
            Class<? extends RubyNode> node = methodDetails.getNodeFactory().getNodeClass();
            for (int i = 1; i <= opt; ++i) {
                boolean unguardedObjectArgument = false;
                StringBuilder errors = new StringBuilder();
                for (Method method : node.getDeclaredMethods()) {
                    String[] guards;
                    if (!method.isAnnotationPresent(Specialization.class)) continue;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    int n = parameterTypes.length - i;
                    if (methodAnnotation.rest()) {
                        --n;
                    }
                    Class<?> parameterType = parameterTypes[n];
                    Parameter[] parameters = method.getParameters();
                    Parameter parameter = parameters[n];
                    boolean isNamePresent = parameter.isNamePresent();
                    if (!isNamePresent) {
                        SUCCESS = false;
                        AVAILABLE = false;
                        System.err.println("Method parameters names are not available for " + method);
                        return;
                    }
                    String name = parameter.getName();
                    if (parameterType != Object.class || name.startsWith("unused") || name.equals("maybeBlock") || AmbiguousOptionalArgumentChecker.isGuarded(name, guards = method.getAnnotation(Specialization.class).guards())) continue;
                    unguardedObjectArgument = true;
                    errors.append("\"").append(name).append("\" in ").append(AmbiguousOptionalArgumentChecker.methodToString(method, parameterTypes, parameters)).append("\n");
                }
                if (!unguardedObjectArgument) continue;
                SUCCESS = false;
                System.err.println("Ambiguous optional argument in " + node.getCanonicalName() + ":");
                System.err.println(errors);
            }
        }
    }

    private static boolean isGuarded(String name, String[] guards) {
        for (String guard : guards) {
            if (!guard.equals("wasProvided(" + name + ")") && !guard.equals("wasNotProvided(" + name + ")") && !guard.equals("wasNotProvided(" + name + ") || isRubiniusUndefined(" + name + ")") && !guard.equals("isNil(" + name + ")")) continue;
            return true;
        }
        return false;
    }

    private static String methodToString(Method method, Class<?>[] parameterTypes, Parameter[] parameters) {
        StringBuilder str = new StringBuilder();
        str.append(method.getName()).append("(");
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String name = parameter.getName();
            str.append(parameterTypes[i].getSimpleName()).append(" ").append(name);
            if (i >= parameters.length - 1) continue;
            str.append(", ");
        }
        str.append(")");
        return str.toString();
    }
}

