/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.array.ArrayDupNode;
import org.jruby.truffle.core.array.ArrayDupNodeGen;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.SnippetNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.MissingBehavior;

@NodeChild(value="child")
public abstract class SplatCastNode
extends RubyNode {
    private final NilBehavior nilBehavior;
    private final DynamicObject conversionMethod;
    @Node.Child
    private ArrayDupNode dup = ArrayDupNodeGen.create(null);
    @Node.Child
    private CallDispatchHeadNode toA = DispatchHeadNodeFactory.createMethodCall(true, MissingBehavior.RETURN_MISSING);

    public SplatCastNode(NilBehavior nilBehavior, boolean useToAry) {
        this.nilBehavior = nilBehavior;
        String name = useToAry ? "to_ary" : "to_a";
        this.conversionMethod = this.getContext().getSymbolTable().getSymbol(name);
    }

    public abstract RubyNode getChild();

    @Specialization(guards={"isNil(nil)"})
    public Object splatNil(VirtualFrame frame, Object nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return this.createArray(null, 0);
            }
            case ARRAY_WITH_NIL: {
                return this.createArray(new Object[]{this.nil()}, 1);
            }
            case CONVERT: {
                return this.toA.call(frame, nil, "to_a", new Object[0]);
            }
            case NIL: {
                return nil;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Specialization(guards={"isRubyArray(array)"})
    public DynamicObject splat(VirtualFrame frame, DynamicObject array) {
        return this.dup.executeDup(frame, array);
    }

    @Specialization(guards={"!isNil(object)", "!isRubyArray(object)"})
    public DynamicObject splat(VirtualFrame frame, Object object, @Cached(value="create()") BranchProfile errorProfile, @Cached(value="new()") SnippetNode snippetNode) {
        Object array = snippetNode.execute(frame, "Rubinius::Type.rb_check_convert_type(v, Array, method)", "v", object, "method", this.conversionMethod);
        if (RubyGuards.isRubyArray(array)) {
            return (DynamicObject)array;
        }
        if (array == this.nil()) {
            return this.createArray(new Object[]{object}, 1);
        }
        errorProfile.enter();
        throw new RaiseException(this.coreExceptions().typeErrorCantConvertTo(object, "Array", Layouts.SYMBOL.getString(this.conversionMethod), array, this));
    }

    public static enum NilBehavior {
        EMPTY_ARRAY,
        ARRAY_WITH_NIL,
        NIL,
        CONVERT;

    }
}

