/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.application;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.util.Processor;

public abstract class ReadActionProcessor<T>
implements Processor<T> {
    @Override
    public boolean process(final T t) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                return ReadActionProcessor.this.processInReadAction(t);
            }
        });
    }

    public abstract boolean processInReadAction(T var1);

    @NotNull
    public static <T> Processor<T> wrapInReadAction(final @NotNull Processor<T> processor) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/kotlin/com/intellij/openapi/application/ReadActionProcessor", "wrapInReadAction"));
        }
        Processor processor2 = new Processor<T>(){

            @Override
            public boolean process(final T t) {
                return ApplicationManager.getApplication().runReadAction(new Computable<Boolean>(){

                    @Override
                    public Boolean compute() {
                        return processor.process(t);
                    }
                });
            }
        };
        if (processor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/openapi/application/ReadActionProcessor", "wrapInReadAction"));
        }
        return processor2;
    }
}

