/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.util.GUtil;

public class DefaultSourceSet
implements SourceSet {
    private final String name;
    private FileCollection compileClasspath;
    private FileCollection runtimeClasspath;
    private final SourceDirectorySet javaSource;
    private final SourceDirectorySet allJavaSource;
    private final SourceDirectorySet resources;
    private final String displayName;
    private final SourceDirectorySet allSource;
    private final ClassDirectoryBinaryNamingScheme namingScheme;
    private DefaultSourceSetOutput output;

    public DefaultSourceSet(String name, SourceDirectorySetFactory sourceDirectorySetFactory) {
        this.name = name;
        this.displayName = GUtil.toWords((CharSequence)this.name);
        this.namingScheme = new ClassDirectoryBinaryNamingScheme(name);
        String javaSrcDisplayName = this.displayName + " Java source";
        this.javaSource = sourceDirectorySetFactory.create(javaSrcDisplayName);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource = sourceDirectorySetFactory.create(javaSrcDisplayName);
        this.allJavaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource.source(this.javaSource);
        String resourcesDisplayName = this.displayName + " resources";
        this.resources = sourceDirectorySetFactory.create(resourcesDisplayName);
        this.resources.getFilter().exclude((Spec)new Spec<FileTreeElement>(){

            public boolean isSatisfiedBy(FileTreeElement element) {
                return DefaultSourceSet.this.javaSource.contains(element.getFile());
            }
        });
        String allSourceDisplayName = this.displayName + " source";
        this.allSource = sourceDirectorySetFactory.create(allSourceDisplayName);
        this.allSource.source(this.resources);
        this.allSource.source(this.javaSource);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "source set '" + this.getDisplayName() + "'";
    }

    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getClassesTaskName() {
        return this.getTaskName(null, "classes");
    }

    @Override
    public String getCompileTaskName(String language) {
        return this.getTaskName("compile", language);
    }

    @Override
    public String getCompileJavaTaskName() {
        return this.getCompileTaskName("java");
    }

    @Override
    public String getProcessResourcesTaskName() {
        return this.getTaskName("process", "resources");
    }

    @Override
    public String getJarTaskName() {
        return this.getTaskName(null, "jar");
    }

    @Override
    public String getTaskName(String verb, String target) {
        return this.namingScheme.getTaskName(verb, target);
    }

    private String getTaskBaseName() {
        return this.name.equals("main") ? "" : GUtil.toCamelCase((CharSequence)this.name);
    }

    @Override
    public String getCompileConfigurationName() {
        return StringUtils.uncapitalize((String)(this.getTaskBaseName() + "Compile"));
    }

    @Override
    public String getRuntimeConfigurationName() {
        return StringUtils.uncapitalize((String)(this.getTaskBaseName() + "Runtime"));
    }

    @Override
    public String getCompileOnlyConfigurationName() {
        return StringUtils.uncapitalize((String)(this.getTaskBaseName() + "CompileOnly"));
    }

    @Override
    public String getCompileClasspathConfigurationName() {
        return StringUtils.uncapitalize((String)(this.getTaskBaseName() + "CompileClasspath"));
    }

    @Override
    public SourceSetOutput getOutput() {
        return this.output;
    }

    public void setClasses(DefaultSourceSetOutput classes) {
        this.output = classes;
    }

    @Override
    public SourceSet compiledBy(Object ... taskPaths) {
        this.output.builtBy(taskPaths);
        return this;
    }

    @Override
    public FileCollection getCompileClasspath() {
        return this.compileClasspath;
    }

    @Override
    public FileCollection getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    @Override
    public void setCompileClasspath(FileCollection classpath) {
        this.compileClasspath = classpath;
    }

    @Override
    public void setRuntimeClasspath(FileCollection classpath) {
        this.runtimeClasspath = classpath;
    }

    @Override
    public SourceDirectorySet getJava() {
        return this.javaSource;
    }

    @Override
    public SourceSet java(Closure configureClosure) {
        return this.java((Action<? super SourceDirectorySet>)ClosureBackedAction.of((Closure)configureClosure));
    }

    @Override
    public SourceSet java(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute((Object)this.getJava());
        return this;
    }

    @Override
    public SourceDirectorySet getAllJava() {
        return this.allJavaSource;
    }

    @Override
    public SourceDirectorySet getResources() {
        return this.resources;
    }

    @Override
    public SourceSet resources(Closure configureClosure) {
        return this.resources((Action<? super SourceDirectorySet>)ClosureBackedAction.of((Closure)configureClosure));
    }

    @Override
    public SourceSet resources(Action<? super SourceDirectorySet> configureAction) {
        configureAction.execute((Object)this.getResources());
        return this;
    }

    @Override
    public SourceDirectorySet getAllSource() {
        return this.allSource;
    }
}

