/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import java.io.File;
import org.gradle.StartParameter;
import org.gradle.cache.CacheRepository;
import org.gradle.caching.BuildCache;
import org.gradle.caching.internal.BuildCacheConfigurationInternal;
import org.gradle.caching.internal.BuildCacheFactory;
import org.gradle.caching.internal.LenientBuildCacheDecorator;
import org.gradle.caching.internal.LocalDirectoryBuildCache;
import org.gradle.caching.internal.LoggingBuildCacheDecorator;
import org.gradle.caching.internal.ShortCircuitingErrorHandlerBuildCacheDecorator;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.util.SingleMessageLogger;

public class DefaultBuildCacheConfiguration
implements BuildCacheConfigurationInternal,
Stoppable {
    private final boolean pullAllowed;
    private final boolean pushAllowed;
    private final CacheRepository cacheRepository;
    private final StartParameter startParameter;
    private BuildCacheFactory factory;
    private BuildCache cache;

    public DefaultBuildCacheConfiguration(CacheRepository cacheRepository, StartParameter startParameter) {
        this.cacheRepository = cacheRepository;
        this.startParameter = startParameter;
        this.useLocalCache();
        this.pullAllowed = "true".equalsIgnoreCase(System.getProperty("org.gradle.cache.tasks.pull", "true").trim());
        this.pushAllowed = "true".equalsIgnoreCase(System.getProperty("org.gradle.cache.tasks.push", "true").trim());
    }

    public void useLocalCache() {
        this.setFactory(new BuildCacheFactory(){

            public BuildCache createCache(StartParameter startParameter) {
                String cacheDirectoryPath = System.getProperty("org.gradle.cache.tasks.directory");
                return cacheDirectoryPath != null ? new LocalDirectoryBuildCache(DefaultBuildCacheConfiguration.this.cacheRepository, new File(cacheDirectoryPath)) : new LocalDirectoryBuildCache(DefaultBuildCacheConfiguration.this.cacheRepository, "task-cache");
            }
        });
    }

    public void useLocalCache(final File directory) {
        this.setFactory(new BuildCacheFactory(){

            public BuildCache createCache(StartParameter startParameter) {
                return new LocalDirectoryBuildCache(DefaultBuildCacheConfiguration.this.cacheRepository, directory);
            }
        });
    }

    public void useCacheFactory(BuildCacheFactory factory) {
        this.setFactory(factory);
    }

    private void setFactory(BuildCacheFactory factory) {
        this.factory = factory;
    }

    public BuildCache getCache() {
        if (this.cache == null) {
            this.cache = new LenientBuildCacheDecorator(new ShortCircuitingErrorHandlerBuildCacheDecorator(3, new LoggingBuildCacheDecorator(this.factory.createCache(this.startParameter))));
            if (this.isPullAllowed() && this.isPushAllowed()) {
                SingleMessageLogger.incubatingFeatureUsed((String)("Using " + this.cache.getDescription()));
            } else if (this.isPushAllowed()) {
                SingleMessageLogger.incubatingFeatureUsed((String)("Pushing task output to " + this.cache.getDescription()));
            } else if (this.isPullAllowed()) {
                SingleMessageLogger.incubatingFeatureUsed((String)("Retrieving task output from " + this.cache.getDescription()));
            }
        }
        return this.cache;
    }

    public boolean isPullAllowed() {
        return this.pullAllowed;
    }

    public boolean isPushAllowed() {
        return this.pushAllowed;
    }

    public void stop() {
        CompositeStoppable.stoppable((Object[])new Object[]{this.cache}).stop();
    }
}

