/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.remote.ConnectionAcceptor;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.worker.WorkerProcess;

public class DefaultWorkerProcess
implements WorkerProcess {
    private static final Logger LOGGER = Logging.getLogger(DefaultWorkerProcess.class);
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private ObjectConnection connection;
    private ConnectionAcceptor acceptor;
    private ExecHandle execHandle;
    private boolean running;
    private Throwable processFailure;
    private final long connectTimeout;

    public DefaultWorkerProcess(int connectTimeoutValue, TimeUnit connectTimeoutUnits) {
        this.connectTimeout = connectTimeoutUnits.toMillis(connectTimeoutValue);
    }

    public void setExecHandle(ExecHandle execHandle) {
        this.execHandle = execHandle;
        execHandle.addListener(new ExecHandleListener(){

            public void executionStarted(ExecHandle execHandle) {
            }

            public void executionFinished(ExecHandle execHandle, ExecResult execResult) {
                DefaultWorkerProcess.this.onProcessStop(execResult);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAccepting(ConnectionAcceptor acceptor) {
        this.lock.lock();
        try {
            this.acceptor = acceptor;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnect(ObjectConnection connection) {
        ConnectionAcceptor stoppable;
        this.lock.lock();
        try {
            LOGGER.debug("Received connection {} from {}", (Object)connection, (Object)this.execHandle);
            this.connection = connection;
            this.condition.signalAll();
            stoppable = this.acceptor;
        }
        finally {
            this.lock.unlock();
        }
        if (stoppable != null) {
            stoppable.requestStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProcessStop(ExecResult execResult) {
        this.lock.lock();
        try {
            try {
                execResult.rethrowFailure().assertNormalExitValue();
            }
            catch (Throwable e) {
                this.processFailure = e;
            }
            this.running = false;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "DefaultWorkerProcess{running=" + this.running + ", execHandle=" + this.execHandle + '}';
    }

    public ObjectConnection getConnection() {
        return this.connection;
    }

    public WorkerProcess start() {
        try {
            this.doStart();
        }
        catch (Throwable t) {
            this.cleanup();
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStart() {
        this.lock.lock();
        try {
            this.running = true;
        }
        finally {
            this.lock.unlock();
        }
        this.execHandle.start();
        Date connectExpiry = new Date(System.currentTimeMillis() + this.connectTimeout);
        this.lock.lock();
        try {
            while (this.connection == null && this.running) {
                try {
                    if (this.condition.awaitUntil(connectExpiry)) continue;
                    throw new ExecException(String.format("Unable to connect to the child process '%s'.\nIt is likely that the child process have crashed - please find the stack trace in the build log.\nThis exception might occur when the build machine is extremely loaded.\nThe connection attempt hit a timeout after %.1f seconds (last known process state: %s, running: %s).", this.execHandle, (double)this.connectTimeout / 1000.0, this.execHandle.getState(), this.running));
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }
            if (this.processFailure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)this.processFailure);
            }
            if (this.connection == null) {
                throw new ExecException(String.format("Never received a connection from %s.", this.execHandle));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecResult waitForStop() {
        try {
            ExecResult execResult = this.execHandle.waitForFinish().assertNormalExitValue();
            return execResult;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup() {
        CompositeStoppable stoppable;
        this.execHandle.abort();
        this.lock.lock();
        try {
            stoppable = CompositeStoppable.stoppable((Object[])new Object[]{this.acceptor, this.connection});
        }
        finally {
            this.connection = null;
            this.acceptor = null;
            this.lock.unlock();
        }
        stoppable.stop();
    }
}

