/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.tools.AudioUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class ImportAudioAction
extends AbstractAction {
    private final transient GpxLayer layer;

    public ImportAudioAction(GpxLayer gpxLayer) {
        super(I18n.tr("Import Audio", new Object[0]), ImageProvider.get("importaudio"));
        this.layer = gpxLayer;
        this.putValue("help", HelpUtil.ht("/Action/ImportAudio"));
    }

    private static void warnCantImportIntoServerLayer(GpxLayer gpxLayer) {
        String string = I18n.tr("<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with audio data.</html>", gpxLayer.getName());
        HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Import not possible", new Object[0]), 2, HelpUtil.ht("/Action/ImportAudio#CantImportIntoGpxLayerFromServer"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.layer.data.fromServer) {
            ImportAudioAction.warnCantImportIntoServerLayer(this.layer);
            return;
        }
        AbstractFileChooser abstractFileChooser = DiskAccessAction.createAndOpenFileChooser(true, true, null, new AudioFileFilter(), 0, "markers.lastaudiodirectory");
        if (abstractFileChooser != null) {
            File[] fileArray = abstractFileChooser.getSelectedFiles();
            if (fileArray.length > 1) {
                Arrays.sort(fileArray, Comparator.comparingLong(File::lastModified));
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (File file : fileArray) {
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(" (");
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(file.getName());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(')');
            }
            MarkerLayer markerLayer = new MarkerLayer(new GpxData(), I18n.tr("Audio markers from {0}", this.layer.getName()) + stringBuilder, this.layer.getAssociatedFile(), this.layer);
            double d = (double)fileArray[0].lastModified() / 1000.0 - AudioUtil.getCalibratedDuration(fileArray[0]);
            Markers markers = new Markers();
            for (File file : fileArray) {
                this.importAudio(file, markerLayer, d, markers);
            }
            Main.getLayerManager().addLayer(markerLayer);
            Main.map.repaint();
        }
    }

    private void importAudio(File file, MarkerLayer markerLayer, double d, Markers markers) {
        WayPoint wayPoint2;
        WayPoint wayPoint3;
        URL uRL = Utils.fileToURL(file);
        boolean bl = this.layer.data.tracks != null && !this.layer.data.tracks.isEmpty();
        boolean bl2 = this.layer.data.waypoints != null && !this.layer.data.waypoints.isEmpty();
        ArrayList<WayPoint> arrayList = new ArrayList<WayPoint>();
        boolean bl3 = false;
        boolean bl4 = false;
        double d2 = Main.pref.getDouble("marker.audiofromuntimedwaypoints.distance", 0.001);
        WayPoint wayPoint4 = null;
        double d3 = -1.0;
        if (bl) {
            for (GpxTrack object2 : this.layer.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : object2.getSegments()) {
                    Iterator<WayPoint> iterator = gpxTrackSegment.getWayPoints().iterator();
                    if (iterator.hasNext()) {
                        WayPoint wayPoint5 = iterator.next();
                        d3 = wayPoint5.time;
                    }
                    if (!(d3 >= 0.0)) continue;
                    break;
                }
                if (!(d3 >= 0.0)) continue;
                break;
            }
        }
        if (d3 < 0.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No GPX track available in layer to associate audio with.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        if (bl2 && Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true)) {
            for (WayPoint wayPoint6 : this.layer.data.waypoints) {
                if (wayPoint6.time > d3) {
                    arrayList.add(wayPoint6);
                    continue;
                }
                if (!(wayPoint6.time > 0.0)) continue;
                bl3 = true;
            }
        }
        if (bl2 && Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true)) {
            for (WayPoint wayPoint7 : this.layer.data.waypoints) {
                if (arrayList.contains(wayPoint7)) continue;
                WayPoint wayPoint8 = this.layer.data.nearestPointOnTrack(wayPoint7.getEastNorth(), d2);
                if (wayPoint8 != null) {
                    WayPoint wayPoint9 = new WayPoint(wayPoint7.getCoor());
                    wayPoint9.time = wayPoint8.time;
                    if (wayPoint7.attr.containsKey("name")) {
                        wayPoint9.put("name", wayPoint7.getString("name"));
                    }
                    arrayList.add(wayPoint9);
                    continue;
                }
                bl4 = true;
            }
        }
        if (this.layer.data.tracks != null && Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false) && !this.layer.data.tracks.isEmpty()) {
            for (GpxTrack gpxTrack : this.layer.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint10 : gpxTrackSegment.getWayPoints()) {
                        if (!wayPoint10.attr.containsKey("name") && !wayPoint10.attr.containsKey("desc")) continue;
                        arrayList.add(wayPoint10);
                    }
                }
            }
        }
        if (bl && Main.pref.getBoolean("marker.audiofromwavtimestamps", false)) {
            double d4 = (double)file.lastModified() / 1000.0;
            double d5 = AudioUtil.getCalibratedDuration(file);
            double d6 = d4 - d5;
            d6 = d + (d6 - d) / Main.pref.getDouble("audio.calibration", 1.0);
            wayPoint3 = null;
            wayPoint2 = null;
            block7: for (GpxTrack gpxTrack : this.layer.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint11 : gpxTrackSegment.getWayPoints()) {
                        if (d6 < wayPoint11.time) {
                            wayPoint2 = wayPoint11;
                            break;
                        }
                        wayPoint3 = wayPoint11;
                    }
                    if (wayPoint2 == null) continue;
                    continue block7;
                }
            }
            if (wayPoint3 == null || wayPoint2 == null) {
                bl3 = true;
            } else {
                wayPoint4 = new WayPoint(wayPoint3.getCoor().interpolate(wayPoint2.getCoor(), (d6 - wayPoint3.time) / (wayPoint2.time - wayPoint3.time)));
                wayPoint4.time = d6;
                Object object = file.getName();
                int n = ((String)object).lastIndexOf(46);
                if (n > 0) {
                    object = ((String)object).substring(0, n);
                }
                wayPoint4.put("name", object);
                arrayList.add(wayPoint4);
            }
        }
        if ((Main.pref.getBoolean("marker.audiofromstart") || arrayList.isEmpty()) && bl) {
            boolean bl5 = false;
            for (GpxTrack gpxTrack : this.layer.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    Iterator<WayPoint> iterator = gpxTrackSegment.getWayPoints().iterator();
                    if (iterator.hasNext()) {
                        wayPoint3 = iterator.next();
                        wayPoint2 = new WayPoint(wayPoint3.getCoor());
                        wayPoint2.put("name", "start");
                        wayPoint2.time = wayPoint3.time;
                        arrayList.add(wayPoint2);
                        bl5 = true;
                    }
                    if (!bl5) continue;
                    break;
                }
                if (!bl5) continue;
                break;
            }
        }
        arrayList.sort(Comparator.comparingDouble(wayPoint -> wayPoint.time));
        d3 = -1.0;
        for (WayPoint wayPoint12 : arrayList) {
            if (d3 < 0.0) {
                d3 = wayPoint12.time;
            }
            double d7 = wayPoint12.time - d3;
            AudioMarker audioMarker = new AudioMarker(wayPoint12.getCoor(), (TemplateEngineDataProvider)wayPoint12, uRL, markerLayer, wayPoint12.time, d7);
            if (wayPoint12 == wayPoint4) {
                audioMarker.timeFromAudio = true;
            }
            markerLayer.data.add(audioMarker);
        }
        if (bl3 && !markers.timedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints with timestamps from before the start of the track or after the end were omitted or moved to the start.", new Object[0]));
            markers.timedMarkersOmitted = bl3;
        }
        if (bl4 && !markers.untimedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints which were too far from the track to sensibly estimate their time were omitted.", new Object[0]));
            markers.untimedMarkersOmitted = bl4;
        }
    }

    private static class Markers {
        public boolean timedMarkersOmitted;
        public boolean untimedMarkersOmitted;

        private Markers() {
        }
    }

    static final class AudioFileFilter
    extends FileFilter {
        AudioFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory() || Utils.hasExtension(file, "wav");
        }

        @Override
        public String getDescription() {
            return I18n.tr("Wave Audio files (*.wav)", new Object[0]);
        }
    }
}

