/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.dsl.internal;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface DSLOptions {
    public DSLGenerator defaultGenerator() default DSLGenerator.DEFAULT;

    public boolean flatLayoutBoxingElimination() default true;

    public boolean useLazyClassLoading() default true;

    public ImplicitCastOptimization implicitCastOptimization() default ImplicitCastOptimization.DUPLICATE_TAIL;

    public boolean useDisjunctiveMethodGuardOptimization() default true;

    public TypeBoxingOptimization monomorphicTypeBoxingOptimization() default TypeBoxingOptimization.PRIMITIVE;

    public TypeBoxingOptimization polymorphicTypeBoxingElimination() default TypeBoxingOptimization.PRIMITIVE;

    public TypeBoxingOptimization implicitTypeBoxingOptimization() default TypeBoxingOptimization.PRIMITIVE;

    public TypeBoxingOptimization voidBoxingOptimization() default TypeBoxingOptimization.PRIMITIVE;

    public FallbackOptimization optimizeFallback() default FallbackOptimization.DECLARED;

    public static enum FallbackOptimization {
        ALWAYS,
        DECLARED,
        NEVER;

    }

    public static enum TypeBoxingOptimization {
        ALWAYS,
        PRIMITIVE,
        NONE;

    }

    public static enum ImplicitCastOptimization {
        NONE,
        DUPLICATE_TAIL,
        MERGE_CASTS;


        public boolean isNone() {
            return this == NONE;
        }

        public boolean isDuplicateTail() {
            return this == DUPLICATE_TAIL;
        }

        public boolean isMergeCasts() {
            return this == MERGE_CASTS;
        }
    }

    public static enum DSLGenerator {
        DEFAULT,
        FLAT;

    }
}

