/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.numeric;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.math.BigInteger;
import org.jruby.truffle.core.numeric.FixnumOrBignumNode;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.control.RaiseException;

public class GeneralDivModNode
extends RubyBaseNode {
    @Node.Child
    private FixnumOrBignumNode fixnumOrBignumQuotient = new FixnumOrBignumNode();
    @Node.Child
    private FixnumOrBignumNode fixnumOrBignumRemainder = new FixnumOrBignumNode();
    private final BranchProfile bZeroProfile = BranchProfile.create();
    private final BranchProfile bMinusOneProfile = BranchProfile.create();
    private final BranchProfile nanProfile = BranchProfile.create();
    private final BranchProfile bigIntegerFixnumProfile = BranchProfile.create();
    private final BranchProfile useFixnumPairProfile = BranchProfile.create();
    private final BranchProfile useObjectPairProfile = BranchProfile.create();

    public DynamicObject execute(long a, long b) {
        return this.divMod(a, b);
    }

    public DynamicObject execute(long a, BigInteger b) {
        return this.divMod(BigInteger.valueOf(a), b);
    }

    public DynamicObject execute(long a, double b) {
        return this.divMod((double)a, b);
    }

    public DynamicObject execute(BigInteger a, long b) {
        return this.divMod(a, BigInteger.valueOf(b));
    }

    public DynamicObject execute(BigInteger a, BigInteger b) {
        return this.divMod(a, b);
    }

    public DynamicObject execute(BigInteger a, double b) {
        return this.divMod(a.doubleValue(), b);
    }

    public DynamicObject execute(double a, long b) {
        return this.divMod(a, (double)b);
    }

    public DynamicObject execute(double a, BigInteger b) {
        return this.divMod(a, b.doubleValue());
    }

    public DynamicObject execute(double a, double b) {
        return this.divMod(a, b);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject divMod(long a, long b) {
        long mod;
        Number integerDiv;
        if (b == 0L) {
            this.bZeroProfile.enter();
            throw new ArithmeticException("divide by zero");
        }
        if (b == -1L) {
            this.bMinusOneProfile.enter();
            integerDiv = a == Long.MIN_VALUE ? BigInteger.valueOf(a).negate() : Long.valueOf(-a);
            mod = 0L;
        } else {
            long div = a / b;
            mod = a - b * div;
            if (mod < 0L && b > 0L || mod > 0L && b < 0L) {
                --div;
                mod += b;
            }
            integerDiv = div;
        }
        if (integerDiv instanceof Long && (Long)integerDiv >= Integer.MIN_VALUE && (Long)integerDiv <= Integer.MAX_VALUE && mod >= Integer.MIN_VALUE && mod <= Integer.MAX_VALUE) {
            this.useFixnumPairProfile.enter();
            return this.createArray(new int[]{(int)((Long)integerDiv).longValue(), (int)mod}, 2);
        }
        if (integerDiv instanceof Long) {
            this.useObjectPairProfile.enter();
            return this.createArray(new Object[]{integerDiv, mod}, 2);
        }
        this.useObjectPairProfile.enter();
        return this.createArray(new Object[]{this.fixnumOrBignumQuotient.fixnumOrBignum((BigInteger)integerDiv), mod}, 2);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject divMod(double a, double b) {
        if (b == 0.0) {
            this.bZeroProfile.enter();
            throw new ArithmeticException("divide by zero");
        }
        double mod = Math.IEEEremainder(a, b);
        if (Double.isNaN(mod)) {
            this.nanProfile.enter();
            throw new RaiseException(this.coreExceptions().floatDomainError("NaN", this));
        }
        double div = Math.floor(a / b);
        if (b * mod < 0.0) {
            mod += b;
        }
        return this.createArray(new Object[]{this.fixnumOrBignumQuotient.fixnumOrBignum(div), mod}, 2);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject divMod(BigInteger a, BigInteger b) {
        if (b.signum() == 0) {
            this.bZeroProfile.enter();
            throw new ArithmeticException("divide by zero");
        }
        BigInteger[] bigIntegerResults = a.divideAndRemainder(b);
        if (a.signum() * b.signum() == -1 && bigIntegerResults[1].signum() != 0) {
            this.bigIntegerFixnumProfile.enter();
            bigIntegerResults[0] = bigIntegerResults[0].subtract(BigInteger.ONE);
            bigIntegerResults[1] = b.add(bigIntegerResults[1]);
        }
        return this.createArray(new Object[]{this.fixnumOrBignumQuotient.fixnumOrBignum(bigIntegerResults[0]), this.fixnumOrBignumRemainder.fixnumOrBignum(bigIntegerResults[1])}, 2);
    }
}

