/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.core.cast.ToSNode;
import org.jruby.truffle.core.string.StringNodes;
import org.jruby.truffle.core.string.StringNodesFactory;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.IsTaintedNode;
import org.jruby.truffle.language.objects.TaintNode;

public final class InterpolatedStringNode
extends RubyNode {
    @Node.Children
    private final ToSNode[] children;
    @Node.Child
    private StringNodes.StringAppendPrimitiveNode appendNode = StringNodesFactory.StringAppendPrimitiveNodeFactory.create(new RubyNode[0]);
    @Node.Child
    private CallDispatchHeadNode dupNode = DispatchHeadNodeFactory.createMethodCall();
    @Node.Child
    private IsTaintedNode isTaintedNode = IsTaintedNode.create();
    @Node.Child
    private TaintNode taintNode = TaintNode.create();
    private final ConditionProfile taintProfile = ConditionProfile.createCountingProfile();

    public InterpolatedStringNode(ToSNode[] children) {
        this.children = children;
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        Object[] strings = new Object[this.children.length];
        boolean tainted = false;
        for (int n = 0; n < this.children.length; ++n) {
            Object toInterpolate;
            strings[n] = toInterpolate = this.children[n].execute(frame);
            tainted |= this.isTaintedNode.executeIsTainted(toInterpolate);
        }
        Object string = this.concat(frame, strings);
        if (this.taintProfile.profile(tainted)) {
            this.taintNode.executeTaint(string);
        }
        return string;
    }

    private Object concat(VirtualFrame frame, Object[] strings) {
        DynamicObject builder = null;
        for (Object string : strings) {
            assert (RubyGuards.isRubyString(string));
            builder = builder == null ? (DynamicObject)this.dupNode.call(frame, string, "dup", new Object[0]) : this.appendNode.executeStringAppend(builder, (DynamicObject)string);
        }
        return builder;
    }
}

