/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.utilities.CyclicAssumption;
import org.jruby.truffle.options.OptionsBuilder;
import org.jruby.truffle.options.OptionsCatalog;

public class GlobalVariableStorage {
    private static final int GLOBAL_VARIABLE_MAX_INVALIDATIONS = (Integer)OptionsBuilder.readSystemProperty(OptionsCatalog.GLOBAL_VARIABLE_MAX_INVALIDATIONS);
    private final CyclicAssumption unchangedAssumption = new CyclicAssumption("global variable unchanged");
    private int changes = 0;
    @CompilerDirectives.CompilationFinal
    private volatile boolean assumeConstant = true;
    private volatile Object value;

    GlobalVariableStorage(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Assumption getUnchangedAssumption() {
        return this.unchangedAssumption.getAssumption();
    }

    public boolean isAssumeConstant() {
        return this.assumeConstant;
    }

    public void setValueInternal(Object value) {
        this.value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void updateAssumeConstant() {
        GlobalVariableStorage globalVariableStorage = this;
        synchronized (globalVariableStorage) {
            if (!this.assumeConstant) {
                return;
            }
            if (this.changes <= GLOBAL_VARIABLE_MAX_INVALIDATIONS) {
                ++this.changes;
                this.unchangedAssumption.invalidate();
            } else {
                this.unchangedAssumption.getAssumption().invalidate();
                this.assumeConstant = false;
            }
        }
    }
}

