// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Hermit_HeaderFile
#define _Hermit_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Handle_Geom2d_BSplineCurve.hxx>
#include <Handle_Geom_BSplineCurve.hxx>
#include <Standard_Real.hxx>
class Geom2d_BSplineCurve;
class Geom_BSplineCurve;


//! This  is used to  reparameterize Rational  BSpline
//! Curves so that we can   concatenate them later to
//! build C1 Curves  It builds and 1D-reparameterizing
//! function starting from an Hermite interpolation and
//! adding knots and modifying poles of the 1D BSpline
//! obtained that way. The goal is to build a(u) so that
//! if we consider a BSpline curve
//! N(u)
//! f(u) =  -----
//! D(u)
//!
//! the function a(u)D(u) has value 1 at the umin and umax
//! and has 0.0e0 derivative value a umin and umax.
//! The details of the computation occuring in this package
//! can be found by reading :
//! " Etude sur la concatenation de NURBS en vue du
//! balayage de surfaces" PFE n S85 Ensam Lille
class Hermit 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! returns the correct spline a(u) which will
  //! be multiplicated with BS later.
  Standard_EXPORT static   Handle(Geom2d_BSplineCurve) Solution (const Handle(Geom_BSplineCurve)& BS, const Standard_Real TolPoles = 0.000001, const Standard_Real TolKnots = 0.000001) ;
  
  //! returns the correct spline a(u) which will
  //! be multiplicated with BS later.
  Standard_EXPORT static   Handle(Geom2d_BSplineCurve) Solution (const Handle(Geom2d_BSplineCurve)& BS, const Standard_Real TolPoles = 0.000001, const Standard_Real TolKnots = 0.000001) ;
  
  //! returns the knots to insert to a(u) to
  //! stay with a constant sign and in the
  //! tolerances.
  Standard_EXPORT static   void Solutionbis (const Handle(Geom_BSplineCurve)& BS, Standard_Real& Knotmin, Standard_Real& Knotmax, const Standard_Real TolPoles = 0.000001, const Standard_Real TolKnots = 0.000001) ;




protected:





private:





};







#endif // _Hermit_HeaderFile
