/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg.xml;

import com.kitfox.svg.xml.NumberWithUnits;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XMLParseUtil {
    static final Matcher fpMatch = Pattern.compile("([-+]?((\\d*\\.\\d+)|(\\d+))([eE][+-]?\\d+)?)(\\%|in|cm|mm|pt|pc|px|em|ex)?").matcher("");
    static final Matcher intMatch = Pattern.compile("[-+]?\\d+").matcher("");

    private XMLParseUtil() {
    }

    public static String[] parseStringList(String string) {
        Matcher matcher = Pattern.compile("[^\\s]+").matcher("");
        matcher.reset(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (matcher.find()) {
            linkedList.add(matcher.group());
        }
        String[] stringArray = new String[linkedList.size()];
        return linkedList.toArray(stringArray);
    }

    public static double parseDouble(String string) {
        return XMLParseUtil.findDouble(string);
    }

    public static synchronized double findDouble(String string) {
        if (string == null) {
            return 0.0;
        }
        fpMatch.reset(string);
        try {
            if (!fpMatch.find()) {
                return 0.0;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            Logger.getLogger("svgSalamandeLogger").log(Level.WARNING, "XMLParseUtil: regex parse problem: '" + string + "'", stringIndexOutOfBoundsException);
        }
        string = fpMatch.group(1);
        double d = 0.0;
        try {
            float f;
            d = Double.parseDouble(string);
            try {
                f = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                f = 72.0f;
            }
            String string2 = fpMatch.group(6);
            if ("%".equals(string2)) {
                d /= 100.0;
            } else if ("in".equals(string2)) {
                d *= (double)f;
            } else if ("cm".equals(string2)) {
                d *= (double)(0.3936f * f);
            } else if ("mm".equals(string2)) {
                d *= (double)(0.3936f * f * 0.1f);
            } else if ("pt".equals(string2)) {
                d *= (double)(0.013888889f * f);
            } else if ("pc".equals(string2)) {
                d *= (double)(0.16666667f * f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return d;
    }

    public static synchronized double[] parseDoubleList(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        fpMatch.reset(string);
        LinkedList<Double> linkedList = new LinkedList<Double>();
        while (fpMatch.find()) {
            object = fpMatch.group(1);
            linkedList.add(Double.valueOf((String)object));
        }
        object = new double[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object[n++] = (Double)iterator.next();
        }
        return object;
    }

    public static synchronized float findFloat(String string) {
        if (string == null) {
            return 0.0f;
        }
        fpMatch.reset(string);
        if (!fpMatch.find()) {
            return 0.0f;
        }
        string = fpMatch.group(1);
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
            String string2 = fpMatch.group(6);
            if ("%".equals(string2)) {
                f /= 100.0f;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    public static synchronized float[] parseFloatList(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        fpMatch.reset(string);
        LinkedList<Float> linkedList = new LinkedList<Float>();
        while (fpMatch.find()) {
            object = fpMatch.group(1);
            linkedList.add(Float.valueOf((String)object));
        }
        object = new float[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object[n++] = ((Float)iterator.next()).floatValue();
        }
        return object;
    }

    public static int findInt(String string) {
        if (string == null) {
            return 0;
        }
        intMatch.reset(string);
        if (!intMatch.find()) {
            return 0;
        }
        string = intMatch.group();
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public static int[] parseIntList(String string) {
        Object object;
        if (string == null) {
            return null;
        }
        intMatch.reset(string);
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while (intMatch.find()) {
            object = intMatch.group();
            linkedList.add(Integer.valueOf((String)object));
        }
        object = new int[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object[n++] = (Integer)iterator.next();
        }
        return object;
    }

    public static double parseRatio(String string) {
        if (string == null || string.equals("")) {
            return 0.0;
        }
        if (string.charAt(string.length() - 1) == '%') {
            XMLParseUtil.parseDouble(string.substring(0, string.length() - 1));
        }
        return XMLParseUtil.parseDouble(string);
    }

    public static NumberWithUnits parseNumberWithUnits(String string) {
        if (string == null) {
            return null;
        }
        return new NumberWithUnits(string);
    }

    public static HashMap<String, StyleAttribute> parseStyle(String string, HashMap<String, StyleAttribute> hashMap) {
        Pattern pattern = Pattern.compile(";");
        String[] stringArray = pattern.split(string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            if (stringArray[i].length() == 0 || (n = stringArray[i].indexOf(58)) == -1) continue;
            String string2 = stringArray[i].substring(0, n).trim();
            String string3 = stringArray[i].substring(n + 1).trim();
            hashMap.put(string2, new StyleAttribute(string2, string3));
        }
        return hashMap;
    }
}

