/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class Addresses
extends Test {
    protected static final int HOUSE_NUMBER_WITHOUT_STREET = 2601;
    protected static final int DUPLICATE_HOUSE_NUMBER = 2602;
    protected static final int MULTIPLE_STREET_NAMES = 2603;
    protected static final int MULTIPLE_STREET_RELATIONS = 2604;
    protected static final int HOUSE_NUMBER_TOO_FAR = 2605;
    protected static final String ADDR_HOUSE_NUMBER = "addr:housenumber";
    protected static final String ADDR_INTERPOLATION = "addr:interpolation";
    protected static final String ADDR_PLACE = "addr:place";
    protected static final String ADDR_STREET = "addr:street";
    protected static final String ASSOCIATED_STREET = "associatedStreet";

    public Addresses() {
        super(I18n.tr("Addresses", new Object[0]), I18n.tr("Checks for errors in addresses and associatedStreet relations.", new Object[0]));
    }

    protected List<Relation> getAndCheckAssociatedStreets(OsmPrimitive osmPrimitive) {
        List<Relation> list = OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Relation.class);
        list.removeIf(relation -> !relation.hasTag("type", ASSOCIATED_STREET));
        if (list.size() > 1) {
            String string = list.get(0).get("name");
            Severity severity = string == null || SubclassFilteredCollection.filter(list, relation -> string.equals(relation.get("name"))).size() < list.size() ? Severity.WARNING : Severity.OTHER;
            ArrayList<Relation> arrayList = new ArrayList<Relation>(list);
            arrayList.add(0, (Relation)osmPrimitive);
            this.errors.add(TestError.builder(this, severity, 2604).message(I18n.tr("Multiple associatedStreet relations", new Object[0])).primitives(arrayList).build());
        }
        return list;
    }

    protected void checkHouseNumbersWithoutStreet(OsmPrimitive osmPrimitive) {
        List<Relation> list = this.getAndCheckAssociatedStreets(osmPrimitive);
        if (osmPrimitive.hasKey(ADDR_HOUSE_NUMBER) && !osmPrimitive.hasKey(ADDR_STREET) && !osmPrimitive.hasKey(ADDR_PLACE)) {
            for (Relation osmPrimitive2 : list) {
                if (!osmPrimitive2.hasTag("type", ASSOCIATED_STREET)) continue;
                return;
            }
            for (Way way : OsmPrimitive.getFilteredList(osmPrimitive.getReferrers(), Way.class)) {
                if (!way.hasKey(ADDR_INTERPOLATION) || !way.hasKey(ADDR_STREET)) continue;
                return;
            }
            this.errors.add(TestError.builder(this, Severity.WARNING, 2601).message(I18n.tr("House number without street", new Object[0])).primitives(osmPrimitive).build());
        }
    }

    @Override
    public void visit(Node node) {
        this.checkHouseNumbersWithoutStreet(node);
    }

    @Override
    public void visit(Way way) {
        this.checkHouseNumbersWithoutStreet(way);
    }

    @Override
    public void visit(Relation relation) {
        this.checkHouseNumbersWithoutStreet(relation);
        if (relation.hasTag("type", ASSOCIATED_STREET)) {
            Object object;
            HashMap<String, ArrayList<OsmPrimitive>> hashMap = new HashMap<String, ArrayList<OsmPrimitive>>();
            String string = relation.get("name");
            HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
            HashSet<OsmPrimitive> hashSet2 = new HashSet<OsmPrimitive>();
            HashSet<Way> hashSet3 = new HashSet<Way>();
            for (RelationMember object2 : relation.getMembers()) {
                object = object2.getRole();
                OsmPrimitive osmPrimitive = object2.getMember();
                if ("house".equals(object)) {
                    hashSet2.add(osmPrimitive);
                    String string2 = osmPrimitive.get(ADDR_HOUSE_NUMBER);
                    if (string2 != null) {
                        ArrayList<OsmPrimitive> arrayList = (ArrayList<OsmPrimitive>)hashMap.get(string2 = string2.trim().toUpperCase(Locale.ENGLISH));
                        if (arrayList == null) {
                            arrayList = new ArrayList<OsmPrimitive>();
                            hashMap.put(string2, arrayList);
                        }
                        arrayList.add(osmPrimitive);
                    }
                    if (string == null || !osmPrimitive.hasKey(ADDR_STREET) || string.equals(osmPrimitive.get(ADDR_STREET))) continue;
                    if (hashSet.isEmpty()) {
                        hashSet.add(relation);
                    }
                    hashSet.add(osmPrimitive);
                    continue;
                }
                if (!"street".equals(object)) continue;
                if (osmPrimitive instanceof Way) {
                    hashSet3.add((Way)osmPrimitive);
                }
                if (string == null || !osmPrimitive.hasKey("name") || string.equals(osmPrimitive.get("name"))) continue;
                if (hashSet.isEmpty()) {
                    hashSet.add(relation);
                }
                hashSet.add(osmPrimitive);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (List)entry.getValue();
                if (object.size() <= 1) continue;
                this.errors.add(TestError.builder(this, Severity.WARNING, 2602).message(I18n.tr("Duplicate house numbers", new Object[0]), I18n.marktr("House number ''{0}'' duplicated"), entry.getKey()).primitives((Collection<? extends OsmPrimitive>)object).build());
            }
            if (!hashSet.isEmpty()) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 2603).message(I18n.tr("Multiple street names in relation", new Object[0])).primitives(hashSet).build());
            }
            if (!hashSet3.isEmpty()) {
                for (OsmPrimitive osmPrimitive : hashSet2) {
                    if (!osmPrimitive.isUsable()) continue;
                    this.checkDistance(osmPrimitive, hashSet3);
                }
            }
        }
    }

    protected void checkDistance(OsmPrimitive osmPrimitive, Collection<Way> collection) {
        EastNorth eastNorth;
        if (osmPrimitive instanceof Node) {
            eastNorth = ((Node)osmPrimitive).getEastNorth();
        } else if (osmPrimitive instanceof Way) {
            List<Node> list = ((Way)osmPrimitive).getNodes();
            if (osmPrimitive.hasKey(ADDR_INTERPOLATION)) {
                for (Node node : list) {
                    if (!node.hasKey(ADDR_HOUSE_NUMBER)) continue;
                    this.checkDistance(node, collection);
                }
                return;
            }
            eastNorth = Geometry.getCentroid(list);
        } else {
            return;
        }
        if (eastNorth == null) {
            return;
        }
        double d = Main.pref.getDouble("validator.addresses.max_street_distance", 200.0);
        boolean bl = false;
        for (Way way : collection) {
            for (Pair<Node, Node> pair : way.getNodePairs(false)) {
                EastNorth eastNorth2 = ((Node)pair.a).getEastNorth();
                EastNorth eastNorth3 = ((Node)pair.b).getEastNorth();
                if (eastNorth2 != null && eastNorth3 != null) {
                    EastNorth eastNorth4 = Geometry.closestPointToSegment(eastNorth2, eastNorth3, eastNorth);
                    if (!(eastNorth4.distance(eastNorth) <= d)) continue;
                    return;
                }
                Main.warn("Addresses test skipped chunck " + pair + " for street part " + way + " because p1 or p2 is null");
            }
            if (bl || !way.isIncomplete()) continue;
            bl = true;
        }
        if (bl) {
            return;
        }
        ArrayList<Way> arrayList = new ArrayList<Way>(collection);
        arrayList.add(0, (Way)osmPrimitive);
        this.errors.add(TestError.builder(this, Severity.WARNING, 2605).message(I18n.tr("House number too far from street", new Object[0])).primitives((Collection<? extends OsmPrimitive>)arrayList).build());
    }
}

