/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.signature;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.signature.AsmTypeFactory;
import org.jetbrains.kotlin.load.kotlin.JvmDescriptorTypeWriter;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmSignatureWriter
extends JvmDescriptorTypeWriter<Type> {
    private final List<JvmMethodParameterSignature> kotlinParameterTypes = new ArrayList<JvmMethodParameterSignature>();
    private Type jvmReturnType;
    private JvmMethodParameterKind currentParameterKind;
    private int currentSignatureSize = 0;

    public JvmSignatureWriter() {
        super(AsmTypeFactory.INSTANCE);
    }

    @Override
    public void writeClass(@NotNull Type objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectType", "org/jetbrains/kotlin/codegen/signature/JvmSignatureWriter", "writeClass"));
        }
        this.writeClassBegin(objectType);
        this.writeClassEnd();
    }

    public void writeAsmType(@NotNull Type asmType) {
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/signature/JvmSignatureWriter", "writeAsmType"));
        }
        switch (asmType.getSort()) {
            case 10: {
                this.writeClassBegin(asmType);
                this.writeClassEnd();
                return;
            }
            case 9: {
                this.writeArrayType();
                this.writeAsmType(asmType.getElementType());
                this.writeArrayEnd();
                return;
            }
        }
        this.writeJvmTypeAsIs(asmType);
    }

    public void writeClassBegin(Type asmType) {
        this.writeJvmTypeAsIs(asmType);
    }

    public void writeOuterClassBegin(Type resultingAsmType, String outerInternalName) {
        this.writeJvmTypeAsIs(resultingAsmType);
    }

    public void writeInnerClass(String name) {
    }

    public void writeClassEnd() {
    }

    public void writeTypeArgument(@NotNull Variance projectionKind) {
        if (projectionKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectionKind", "org/jetbrains/kotlin/codegen/signature/JvmSignatureWriter", "writeTypeArgument"));
        }
    }

    public void writeUnboundedWildcard() {
    }

    public void writeTypeArgumentEnd() {
    }

    public void writeFormalTypeParameter(String name) {
    }

    public void writeClassBound() {
    }

    public void writeClassBoundEnd() {
    }

    public void writeInterfaceBound() {
    }

    public void writeInterfaceBoundEnd() {
    }

    public void writeParametersStart() {
        this.clearCurrentType();
    }

    public void writeParameterType(JvmMethodParameterKind parameterKind) {
        this.currentParameterKind = parameterKind;
    }

    public void writeParameterTypeEnd() {
        this.kotlinParameterTypes.add(new JvmMethodParameterSignature((Type)this.getJvmCurrentType(), this.currentParameterKind));
        this.currentSignatureSize += ((Type)this.getJvmCurrentType()).getSize();
        this.currentParameterKind = null;
        this.clearCurrentType();
    }

    public void writeReturnType() {
    }

    public void writeReturnTypeEnd() {
        this.jvmReturnType = (Type)this.getJvmCurrentType();
        this.clearCurrentType();
    }

    public void writeSuperclass() {
    }

    public void writeSuperclassEnd() {
    }

    public void writeInterface() {
    }

    public void writeInterfaceEnd() {
    }

    @Nullable
    public String makeJavaGenericSignature() {
        return null;
    }

    @NotNull
    public JvmMethodGenericSignature makeJvmMethodSignature(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/signature/JvmSignatureWriter", "makeJvmMethodSignature"));
        }
        ArrayList<Type> types = new ArrayList<Type>(this.kotlinParameterTypes.size());
        for (JvmMethodParameterSignature parameter : this.kotlinParameterTypes) {
            types.add(parameter.getAsmType());
        }
        Method asmMethod = new Method(name, this.jvmReturnType, types.toArray(new Type[types.size()]));
        JvmMethodGenericSignature jvmMethodGenericSignature = new JvmMethodGenericSignature(asmMethod, this.kotlinParameterTypes, this.makeJavaGenericSignature());
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/signature/JvmSignatureWriter", "makeJvmMethodSignature"));
        }
        return jvmMethodGenericSignature;
    }

    public int getCurrentSignatureSize() {
        return this.currentSignatureSize;
    }

    public boolean skipGenericSignature() {
        return true;
    }

    public String toString() {
        return "empty";
    }
}

