/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import javax.activation.FileTypeMap;

public class FileDataSource
implements DataSource {
    private File file;
    private FileTypeMap typeMap;

    public FileDataSource(File file) {
        this.file = file;
    }

    public FileDataSource(String name) {
        this(new File(name));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public String getContentType() {
        if (this.typeMap == null) {
            FileTypeMap dftm = FileTypeMap.getDefaultFileTypeMap();
            return dftm.getContentType(this.file);
        }
        return this.typeMap.getContentType(this.file);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public void setFileTypeMap(FileTypeMap map) {
        this.typeMap = map;
    }
}

