/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.Flexibility;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;

public final class DynamicTypesKt {
    public static final boolean isDynamic(@NotNull KotlinType $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Flexibility flexibility = $receiver.getCapability(Flexibility.class);
        return Intrinsics.areEqual(flexibility != null ? flexibility.getFactory() : null, DynamicTypeFactory.INSTANCE);
    }

    @NotNull
    public static final KotlinType createDynamicType(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull(builtIns, "builtIns");
        KotlinType kotlinType = builtIns.getNothingType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "builtIns.nothingType");
        KotlinType kotlinType2 = builtIns.getNullableAnyType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "builtIns.nullableAnyType");
        return DynamicTypeFactory.INSTANCE.create(kotlinType, kotlinType2);
    }
}

