/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import org.jetbrains.annotations.NotNull;

public class VisibilityUtil {
    private static final String[] visibilityModifiers = new String[]{"private", "packageLocal", "protected", "public"};

    @PsiModifier.ModifierConstant
    public static String getVisibilityModifier(PsiModifierList list2) {
        if (list2 == null) {
            return "packageLocal";
        }
        for (String modifier : visibilityModifiers) {
            if (!list2.hasModifierProperty(modifier)) continue;
            return modifier;
        }
        return "packageLocal";
    }

    @NotNull
    public static String toPresentableText(@PsiModifier.ModifierConstant @NotNull String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "com/intellij/util/VisibilityUtil", "toPresentableText"));
        }
        String string = PsiBundle.visibilityPresentation(modifier);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/VisibilityUtil", "toPresentableText"));
        }
        return string;
    }
}

