/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.messages;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;

public class XmlMessageRenderer
implements MessageRenderer {
    @Override
    public String renderPreamble() {
        return "<MESSAGES>";
    }

    @Override
    public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location2) {
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "org/jetbrains/kotlin/cli/common/messages/XmlMessageRenderer", "render"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/cli/common/messages/XmlMessageRenderer", "render"));
        }
        if (location2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/kotlin/cli/common/messages/XmlMessageRenderer", "render"));
        }
        StringBuilder out = new StringBuilder();
        out.append("<").append(severity.toString());
        if (location2.getPath() != null) {
            out.append(" path=\"").append(this.e(location2.getPath())).append("\"");
            out.append(" line=\"").append(location2.getLine()).append("\"");
            out.append(" column=\"").append(location2.getColumn()).append("\"");
        }
        out.append(">");
        out.append(this.e(message));
        out.append("</").append(severity.toString()).append(">\n");
        return out.toString();
    }

    private String e(String str) {
        return StringUtil.escapeXml(str);
    }

    @Override
    public String renderConclusion() {
        return "</MESSAGES>";
    }
}

