/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextArea;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.AllBufferSet;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;

public class SearchDialog
extends EnhancedDialog {
    public static final int CURRENT_BUFFER = 0;
    public static final int ALL_BUFFERS = 1;
    public static final int DIRECTORY = 2;
    private static final Map<View, SearchDialog> viewHash = new HashMap<View, SearchDialog>();
    private final View view;
    private HistoryTextArea find;
    private HistoryTextArea replace;
    private JRadioButton stringReplace;
    private JRadioButton beanShellReplace;
    private JCheckBox keepDialog;
    private JCheckBox wholeWord;
    private JCheckBox ignoreCase;
    private JCheckBox regexp;
    private JCheckBox hyperSearch;
    private JCheckBox wrap;
    private JRadioButton searchBack;
    private JRadioButton searchForward;
    private JRadioButton searchSelection;
    private JRadioButton searchCurrentBuffer;
    private JRadioButton searchAllBuffers;
    private JRadioButton searchDirectory;
    private HistoryTextField filter;
    private HistoryTextField directory;
    private JCheckBox searchSubDirectories;
    private JCheckBox skipBinaryFiles;
    private JCheckBox skipHidden;
    private JButton choose;
    private JButton synchronize;
    private JButton findBtn;
    private JButton replaceBtn;
    private JButton replaceAndFindBtn;
    private JButton replaceAllBtn;
    private JButton closeBtn;
    private boolean saving;
    private FocusOrder focusOrder;

    public static SearchDialog getSearchDialog(View view) {
        SearchDialog searchDialog = viewHash.get(view);
        if (searchDialog == null) {
            searchDialog = new SearchDialog(view);
            viewHash.put(view, searchDialog);
        }
        return searchDialog;
    }

    public static void showSearchDialog(View view, String string, int n) {
        final SearchDialog searchDialog = SearchDialog.getSearchDialog(view);
        searchDialog.setSearchString(string, n);
        if (OperatingSystem.isUnix() && !OperatingSystem.isMacOS()) {
            searchDialog.setVisible(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                searchDialog.toFront();
                searchDialog.requestFocus();
                searchDialog.find.requestFocus();
            }
        });
        searchDialog.setVisible(true);
    }

    public void setSearchString(String string, int n) {
        Object object;
        this.find.setText(null);
        this.replace.setText(null);
        if (string == null) {
            this.searchCurrentBuffer.setSelected(true);
            object = this.find.getModel();
            if (!((DefaultListModel)object).isEmpty()) {
                this.find.setText(((HistoryModel)object).getItem(0));
                this.find.selectAll();
            }
        } else if (string.indexOf(10) == -1) {
            if (SearchAndReplace.getRegexp()) {
                this.find.setText(SearchAndReplace.escapeRegexp(string, true));
            } else {
                this.find.setText(string);
            }
            this.find.selectAll();
            this.searchCurrentBuffer.setSelected(true);
        } else if (n == 0) {
            this.searchSelection.setSelected(true);
            this.hyperSearch.setSelected(true);
        }
        if (n == 0) {
            if (!this.searchSelection.isSelected()) {
                this.searchCurrentBuffer.setSelected(true);
                this.hyperSearch.setSelected(jEdit.getBooleanProperty("search.hypersearch.toggle"));
            }
        } else if (n == 1) {
            this.searchAllBuffers.setSelected(true);
            this.hyperSearch.setSelected(true);
        } else if (n == 2) {
            object = SearchAndReplace.getSearchFileSet();
            if (object instanceof DirectoryListSet) {
                this.filter.setText(((DirectoryListSet)object).getFileFilter());
                this.directory.setText(((DirectoryListSet)object).getDirectory());
                this.searchSubDirectories.setSelected(((DirectoryListSet)object).isRecursive());
            }
            this.hyperSearch.setSelected(true);
            this.searchDirectory.setSelected(true);
        }
        this.updateEnabled();
    }

    @Override
    public void ok() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!this.save(false)) {
                return;
            }
            if (this.searchSelection.isSelected() && this.view.getTextArea().getSelectionCount() == 0) {
                GUIUtilities.error(this.view, "search-no-selection", null);
                return;
            }
            if (this.hyperSearch.isSelected() || this.searchSelection.isSelected()) {
                if (SearchAndReplace.hyperSearch(this.view, this.searchSelection.isSelected())) {
                    this.closeOrKeepDialog();
                }
            } else if (SearchAndReplace.find(this.view)) {
                this.closeOrKeepDialog();
            } else {
                this.toFront();
                this.requestFocus();
                this.find.requestFocus();
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public void cancel() {
        this.save(true);
        GUIUtilities.saveGeometry(this, "search");
        this.setVisible(false);
    }

    @EditBus.EBHandler
    public void handleSearchSettingsChanged(EBMessage eBMessage) {
        if (!this.saving) {
            this.load();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!bl && Debug.DISABLE_SEARCH_DIALOG_POOL) {
            this.dispose();
        }
    }

    private void initFocusOrder() {
        this.focusOrder.add(this.find);
        this.focusOrder.add(this.replace);
        this.focusOrder.add(this.findBtn);
        this.focusOrder.add(this.replaceBtn);
        this.focusOrder.add(this.replaceAndFindBtn);
        this.focusOrder.add(this.replaceAllBtn);
        this.focusOrder.add(this.closeBtn);
        this.focusOrder.add(this.stringReplace);
        this.focusOrder.add(this.beanShellReplace);
        this.focusOrder.add(this.searchSelection);
        this.focusOrder.add(this.searchCurrentBuffer);
        this.focusOrder.add(this.searchAllBuffers);
        this.focusOrder.add(this.searchDirectory);
        this.focusOrder.add(this.keepDialog);
        this.focusOrder.add(this.ignoreCase);
        this.focusOrder.add(this.regexp);
        this.focusOrder.add(this.hyperSearch);
        this.focusOrder.add(this.wholeWord);
        this.focusOrder.add(this.searchBack);
        this.focusOrder.add(this.searchForward);
        this.focusOrder.add(this.wrap);
        this.focusOrder.add(this.filter);
        this.focusOrder.add(this.synchronize);
        this.focusOrder.add(this.directory);
        this.focusOrder.add(this.choose);
        this.focusOrder.add(this.searchSubDirectories);
        this.focusOrder.add(this.skipHidden);
        this.focusOrder.add(this.skipBinaryFiles);
    }

    @Override
    public void dispose() {
        EditBus.removeFromBus(this);
        viewHash.remove(this.view);
        super.dispose();
    }

    private SearchDialog(View view) {
        super(view, jEdit.getProperty("search.title"), false);
        this.view = view;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 12, 12, 12));
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("Center", this.createFieldPanel());
        jPanel2.add("South", this.createSearchSettingsPanel());
        jPanel.add("Center", jPanel2);
        jPanel.add("South", this.createMultiFilePanel());
        jPanel.add("East", this.createButtonsPanel());
        this.setFocusTraversalPolicyProvider(true);
        this.focusOrder = new FocusOrder();
        this.initFocusOrder();
        this.setFocusTraversalPolicy(this.focusOrder);
        this.pack();
        jEdit.unsetProperty("search.width");
        jEdit.unsetProperty("search.d-width");
        jEdit.unsetProperty("search.height");
        jEdit.unsetProperty("search.d-height");
        GUIUtilities.loadGeometry(this, "search");
        this.load();
        EditBus.addToBus(this);
    }

    private void createFindLabelAndField(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(jEdit.getProperty("search.find"));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("search.find.mnemonic").charAt(0));
        this.find = new HistoryTextArea("find");
        this.find.setName("find");
        this.find.setColumns(25);
        this.find.setToolTipText(jEdit.getProperty("search.find.tooltip"));
        jLabel.setToolTipText(jEdit.getProperty("search.find.tooltip"));
        jLabel.setLabelFor(this.find);
        jLabel.setBorder(new EmptyBorder(12, 0, 2, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JScrollPane(this.find), gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    private void createReplaceLabelAndField(JPanel jPanel, GridBagConstraints gridBagConstraints) {
        JLabel jLabel = new JLabel(jEdit.getProperty("search.replace"));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("search.replace.mnemonic").charAt(0));
        jLabel.setBorder(new EmptyBorder(12, 0, 0, 0));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.replace = new HistoryTextArea("replace");
        this.replace.setName("replace");
        this.replace.setToolTipText(jEdit.getProperty("search.find.tooltip"));
        jLabel.setLabelFor(this.replace);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JScrollPane(this.replace), gridBagConstraints);
        ++gridBagConstraints.gridy;
        ButtonGroup buttonGroup = new ButtonGroup();
        ReplaceActionHandler replaceActionHandler = new ReplaceActionHandler();
        this.stringReplace = new JRadioButton(jEdit.getProperty("search.string-replace-btn"));
        this.stringReplace.addActionListener(replaceActionHandler);
        buttonGroup.add(this.stringReplace);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.stringReplace, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.beanShellReplace = new JRadioButton(jEdit.getProperty("search.beanshell-replace-btn"));
        this.beanShellReplace.addActionListener(replaceActionHandler);
        buttonGroup.add(this.beanShellReplace);
        jPanel.add((Component)this.beanShellReplace, gridBagConstraints);
        ++gridBagConstraints.gridy;
    }

    private JPanel createFieldPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 12, 12));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        this.createFindLabelAndField(jPanel, gridBagConstraints);
        this.createReplaceLabelAndField(jPanel, gridBagConstraints);
        return jPanel;
    }

    private JPanel createSearchSettingsPanel() {
        JPanel jPanel = new JPanel(new VariableGridLayout(2, 3));
        jPanel.setBorder(new EmptyBorder(0, 0, 12, 12));
        SettingsActionHandler settingsActionHandler = new SettingsActionHandler();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        jPanel.add(new JLabel(jEdit.getProperty("search.fileset")));
        jPanel.add(new JLabel(jEdit.getProperty("search.settings")));
        jPanel.add(new JLabel(jEdit.getProperty("search.direction")));
        this.searchSelection = new JRadioButton(jEdit.getProperty("search.selection"));
        this.searchSelection.setMnemonic(jEdit.getProperty("search.selection.mnemonic").charAt(0));
        buttonGroup.add(this.searchSelection);
        jPanel.add(this.searchSelection);
        this.searchSelection.addActionListener(settingsActionHandler);
        this.keepDialog = new JCheckBox(jEdit.getProperty("search.keep"));
        this.keepDialog.setMnemonic(jEdit.getProperty("search.keep.mnemonic").charAt(0));
        jPanel.add(this.keepDialog);
        this.searchBack = new JRadioButton(jEdit.getProperty("search.back"));
        this.searchBack.setMnemonic(jEdit.getProperty("search.back.mnemonic").charAt(0));
        buttonGroup2.add(this.searchBack);
        jPanel.add(this.searchBack);
        this.searchBack.addActionListener(settingsActionHandler);
        this.searchCurrentBuffer = new JRadioButton(jEdit.getProperty("search.current"));
        this.searchCurrentBuffer.setMnemonic(jEdit.getProperty("search.current.mnemonic").charAt(0));
        buttonGroup.add(this.searchCurrentBuffer);
        jPanel.add(this.searchCurrentBuffer);
        this.searchCurrentBuffer.addActionListener(settingsActionHandler);
        this.ignoreCase = new JCheckBox(jEdit.getProperty("search.case"));
        this.ignoreCase.setMnemonic(jEdit.getProperty("search.case.mnemonic").charAt(0));
        jPanel.add(this.ignoreCase);
        this.ignoreCase.addActionListener(settingsActionHandler);
        this.searchForward = new JRadioButton(jEdit.getProperty("search.forward"));
        this.searchForward.setMnemonic(jEdit.getProperty("search.forward.mnemonic").charAt(0));
        buttonGroup2.add(this.searchForward);
        jPanel.add(this.searchForward);
        this.searchForward.addActionListener(settingsActionHandler);
        this.searchAllBuffers = new JRadioButton(jEdit.getProperty("search.all"));
        this.searchAllBuffers.setMnemonic(jEdit.getProperty("search.all.mnemonic").charAt(0));
        buttonGroup.add(this.searchAllBuffers);
        jPanel.add(this.searchAllBuffers);
        this.searchAllBuffers.addActionListener(settingsActionHandler);
        this.regexp = new JCheckBox(jEdit.getProperty("search.regexp"));
        this.regexp.setMnemonic(jEdit.getProperty("search.regexp.mnemonic").charAt(0));
        jPanel.add(this.regexp);
        this.regexp.addActionListener(settingsActionHandler);
        this.wrap = new JCheckBox(jEdit.getProperty("search.wrap"));
        this.wrap.setMnemonic(jEdit.getProperty("search.wrap.mnemonic").charAt(0));
        jPanel.add(this.wrap);
        this.wrap.addActionListener(settingsActionHandler);
        this.searchDirectory = new JRadioButton(jEdit.getProperty("search.directory"));
        this.searchDirectory.setMnemonic(jEdit.getProperty("search.directory.mnemonic").charAt(0));
        buttonGroup.add(this.searchDirectory);
        jPanel.add(this.searchDirectory);
        this.searchDirectory.addActionListener(settingsActionHandler);
        this.hyperSearch = new JCheckBox(jEdit.getProperty("search.hypersearch"));
        this.hyperSearch.setMnemonic(jEdit.getProperty("search.hypersearch.mnemonic").charAt(0));
        jPanel.add(this.hyperSearch);
        this.hyperSearch.addActionListener(settingsActionHandler);
        jPanel.add(new JLabel(""));
        jPanel.add(new JLabel(""));
        this.wholeWord = new JCheckBox(jEdit.getProperty("search.word"));
        this.wholeWord.setMnemonic(jEdit.getProperty("search.word.mnemonic").charAt(0));
        jPanel.add(this.wholeWord);
        this.wholeWord.addActionListener(settingsActionHandler);
        return jPanel;
    }

    private JPanel createMultiFilePanel() {
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        MultiFileActionHandler multiFileActionHandler = new MultiFileActionHandler();
        this.filter = new HistoryTextField("search.filter");
        this.filter.setToolTipText(jEdit.getProperty("glob.tooltip"));
        this.filter.addActionListener(multiFileActionHandler);
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        JLabel jLabel = new JLabel(jEdit.getProperty("search.filterField"), 4);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("search.filterField.mnemonic").charAt(0));
        jLabel.setLabelFor(this.filter);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 6);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.filter, gridBagConstraints);
        jPanel.add(this.filter);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.synchronize = new JButton(jEdit.getProperty("search.synchronize"));
        this.synchronize.setToolTipText(jEdit.getProperty("search.synchronize.tooltip"));
        this.synchronize.setMnemonic(jEdit.getProperty("search.synchronize.mnemonic").charAt(0));
        this.synchronize.addActionListener(multiFileActionHandler);
        gridBagLayout.setConstraints(this.synchronize, gridBagConstraints);
        jPanel.add(this.synchronize);
        ++gridBagConstraints.gridy;
        this.directory = new HistoryTextField("search.directory");
        this.directory.setColumns(25);
        this.directory.addActionListener(multiFileActionHandler);
        jLabel = new JLabel(jEdit.getProperty("search.directoryField"), 4);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 12));
        jLabel.setDisplayedMnemonic(jEdit.getProperty("search.directoryField.mnemonic").charAt(0));
        jLabel.setLabelFor(this.directory);
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.insets = new Insets(0, 0, 3, 6);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(this.directory, gridBagConstraints);
        jPanel.add(this.directory);
        this.choose = new JButton(jEdit.getProperty("search.choose"));
        this.choose.setMnemonic(jEdit.getProperty("search.choose.mnemonic").charAt(0));
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.choose, gridBagConstraints);
        jPanel.add(this.choose);
        this.choose.addActionListener(multiFileActionHandler);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        JPanel jPanel2 = new JPanel();
        this.searchSubDirectories = new JCheckBox(jEdit.getProperty("search.subdirs"));
        String string = jEdit.getProperty("search.subdirs.mnemonic");
        this.searchSubDirectories.setMnemonic(string.charAt(0));
        this.searchSubDirectories.setSelected(jEdit.getBooleanProperty("search.subdirs.toggle"));
        this.skipHidden = new JCheckBox(jEdit.getProperty("search.skipHidden"));
        this.skipHidden.setSelected(jEdit.getBooleanProperty("search.skipHidden.toggle", true));
        this.skipBinaryFiles = new JCheckBox(jEdit.getProperty("search.skipBinary"));
        this.skipBinaryFiles.setSelected(jEdit.getBooleanProperty("search.skipBinary.toggle", true));
        jPanel2.add(this.searchSubDirectories);
        jPanel2.add(this.skipHidden);
        jPanel2.add(this.skipBinaryFiles);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 4;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        return jPanel;
    }

    private Box createButtonsPanel() {
        Box box = new Box(1);
        ButtonActionHandler buttonActionHandler = new ButtonActionHandler();
        box.add(Box.createVerticalStrut(12));
        JPanel jPanel = new JPanel(new GridLayout(5, 1, 0, 12));
        this.findBtn = new JButton(jEdit.getProperty("search.findBtn"));
        this.getRootPane().setDefaultButton(this.findBtn);
        jPanel.add(this.findBtn);
        this.findBtn.addActionListener(buttonActionHandler);
        this.replaceBtn = new JButton(jEdit.getProperty("search.replaceBtn", "Replace"));
        this.replaceBtn.setMnemonic(jEdit.getProperty("search.replaceBtn.mnemonic", "p").charAt(0));
        jPanel.add(this.replaceBtn);
        this.replaceBtn.addActionListener(buttonActionHandler);
        this.replaceAndFindBtn = new JButton(jEdit.getProperty("search.replaceAndFindBtn"));
        this.replaceAndFindBtn.setMnemonic(jEdit.getProperty("search.replaceAndFindBtn.mnemonic", "R").charAt(0));
        jPanel.add(this.replaceAndFindBtn);
        this.replaceAndFindBtn.addActionListener(buttonActionHandler);
        this.replaceAllBtn = new JButton(jEdit.getProperty("search.replaceAllBtn"));
        this.replaceAllBtn.setMnemonic(jEdit.getProperty("search.replaceAllBtn.mnemonic", "a").charAt(0));
        jPanel.add(this.replaceAllBtn);
        this.replaceAllBtn.addActionListener(buttonActionHandler);
        this.closeBtn = new JButton(jEdit.getProperty("common.close"));
        jPanel.add(this.closeBtn);
        this.closeBtn.addActionListener(buttonActionHandler);
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        box.add(jPanel);
        box.add(Box.createGlue());
        return box;
    }

    private void updateEnabled() {
        this.wrap.setEnabled(!this.hyperSearch.isSelected() && !this.searchSelection.isSelected());
        boolean bl = !this.hyperSearch.isSelected() && this.searchCurrentBuffer.isSelected();
        this.searchBack.setEnabled(bl);
        this.searchForward.setEnabled(bl);
        if (!bl) {
            this.searchForward.setSelected(true);
        }
        this.filter.setEnabled(this.searchAllBuffers.isSelected() || this.searchDirectory.isSelected());
        boolean bl2 = this.searchDirectory.isSelected();
        this.directory.setEnabled(bl2);
        this.choose.setEnabled(bl2);
        this.searchSubDirectories.setEnabled(bl2);
        this.skipHidden.setEnabled(bl2);
        this.skipBinaryFiles.setEnabled(bl2);
        this.synchronize.setEnabled(this.searchAllBuffers.isSelected() || this.searchDirectory.isSelected());
        this.findBtn.setEnabled(!this.searchSelection.isSelected() || this.hyperSearch.isSelected());
        this.replaceBtn.setEnabled(!this.hyperSearch.isSelected() && !this.searchSelection.isSelected());
        this.replaceAndFindBtn.setEnabled(!this.hyperSearch.isSelected() && !this.searchSelection.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(boolean bl) {
        try {
            this.saving = true;
            SearchAndReplace.setWholeWord(this.wholeWord.isSelected());
            SearchAndReplace.setIgnoreCase(this.ignoreCase.isSelected());
            SearchAndReplace.setRegexp(this.regexp.isSelected());
            SearchAndReplace.setReverseSearch(this.searchBack.isSelected());
            SearchAndReplace.setAutoWrapAround(this.wrap.isSelected());
            jEdit.setBooleanProperty("search.subdirs.toggle", this.searchSubDirectories.isSelected());
            jEdit.setBooleanProperty("search.skipHidden.toggle", this.skipHidden.isSelected());
            jEdit.setBooleanProperty("search.skipBinary.toggle", this.skipBinaryFiles.isSelected());
            String string = this.filter.getText();
            this.filter.addCurrentToHistory();
            if (string.length() == 0) {
                string = "*";
            }
            SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
            boolean bl2 = this.searchSubDirectories.isSelected();
            if (this.searchSelection.isSelected()) {
                searchFileSet = new CurrentBufferSet();
            } else if (this.searchCurrentBuffer.isSelected()) {
                searchFileSet = new CurrentBufferSet();
                jEdit.setBooleanProperty("search.hypersearch.toggle", this.hyperSearch.isSelected());
            } else if (this.searchAllBuffers.isSelected()) {
                searchFileSet = new AllBufferSet(string, this.view);
            } else if (this.searchDirectory.isSelected()) {
                String string2 = this.directory.getText();
                this.directory.addCurrentToHistory();
                string2 = MiscUtilities.constructPath(this.view.getBuffer().getDirectory(), string2);
                if ((VFSManager.getVFSForPath(string2).getCapabilities() & 0x40) == 0) {
                    if (bl) {
                        boolean bl3 = false;
                        return bl3;
                    }
                    int n = GUIUtilities.confirm(this, "remote-dir-search", null, 0, 2);
                    if (n != 0) {
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                if (searchFileSet instanceof DirectoryListSet) {
                    DirectoryListSet directoryListSet = (DirectoryListSet)searchFileSet;
                    directoryListSet.setDirectory(string2);
                    directoryListSet.setFileFilter(string);
                    directoryListSet.setRecursive(bl2);
                } else {
                    searchFileSet = new DirectoryListSet(string2, string, bl2);
                }
            } else {
                searchFileSet = null;
                throw new IllegalStateException("One of search Selection, current Buffer, directory, all buffers must be selected!");
            }
            jEdit.setBooleanProperty("search.subdirs.toggle", bl2);
            jEdit.setBooleanProperty("search.keepDialog.toggle", this.keepDialog.isSelected());
            SearchAndReplace.setSearchFileSet(searchFileSet);
            this.replace.addCurrentToHistory();
            SearchAndReplace.setReplaceString(this.replace.getText());
            if (this.find.getText().length() == 0) {
                if (!bl) {
                    this.getToolkit().beep();
                }
                boolean bl5 = false;
                return bl5;
            }
            this.find.addCurrentToHistory();
            SearchAndReplace.setSearchString(this.find.getText());
            boolean bl6 = true;
            return bl6;
        }
        finally {
            this.saving = false;
        }
    }

    private void closeOrKeepDialog() {
        if (this.keepDialog.isSelected()) {
            if (!this.hyperSearch.isSelected()) {
                this.toFront();
                this.requestFocus();
                this.find.requestFocus();
            }
        } else {
            GUIUtilities.saveGeometry(this, "search");
            this.setVisible(false);
        }
    }

    private void load() {
        this.wholeWord.setSelected(SearchAndReplace.getWholeWord());
        this.ignoreCase.setSelected(SearchAndReplace.getIgnoreCase());
        this.regexp.setSelected(SearchAndReplace.getRegexp());
        this.wrap.setSelected(SearchAndReplace.getAutoWrapAround());
        if (SearchAndReplace.getReverseSearch()) {
            this.searchBack.setSelected(true);
        } else {
            this.searchForward.setSelected(true);
        }
        if (SearchAndReplace.getBeanShellReplace()) {
            this.replace.setModel("replace.script");
            this.beanShellReplace.setSelected(true);
        } else {
            this.replace.setModel("replace");
            this.stringReplace.setSelected(true);
        }
        SearchFileSet searchFileSet = SearchAndReplace.getSearchFileSet();
        HistoryModel historyModel = this.filter.getModel();
        if (historyModel.getSize() != 0) {
            this.filter.setText(historyModel.getItem(0));
        } else {
            this.filter.setText('*' + MiscUtilities.getFileExtension(this.view.getBuffer().getName()));
        }
        historyModel = this.directory.getModel();
        if (historyModel.getSize() != 0) {
            this.directory.setText(historyModel.getItem(0));
        } else {
            this.directory.setText(this.view.getBuffer().getDirectory());
        }
        this.searchSubDirectories.setSelected(jEdit.getBooleanProperty("search.subdirs.toggle"));
        if (searchFileSet instanceof DirectoryListSet) {
            this.filter.setText(((DirectoryListSet)searchFileSet).getFileFilter());
            this.directory.setText(((DirectoryListSet)searchFileSet).getDirectory());
            this.searchSubDirectories.setSelected(((DirectoryListSet)searchFileSet).isRecursive());
        } else if (searchFileSet instanceof AllBufferSet) {
            this.filter.setText(((AllBufferSet)searchFileSet).getFileFilter());
        }
        this.directory.addCurrentToHistory();
        this.keepDialog.setSelected(jEdit.getBooleanProperty("search.keepDialog.toggle"));
    }

    class FocusOrder
    extends FocusTraversalPolicy {
        private List<Component> components = new ArrayList<Component>();

        FocusOrder() {
        }

        public void add(Component component) {
            this.components.add(component);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n = this.components.indexOf(component);
            if (n == -1) {
                return null;
            }
            Component component2 = this.components.get(n = n >= this.components.size() - 1 ? 0 : n + 1);
            if (!component2.isEnabled() || !component2.isFocusable()) {
                return this.getComponentAfter(container, component2);
            }
            return this.components.get(n);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int n = this.components.indexOf(component);
            if (n == -1) {
                return null;
            }
            Component component2 = this.components.get(n = n == 0 ? this.components.size() - 1 : n - 1);
            if (!component2.isEnabled() || !component2.isFocusable()) {
                return this.getComponentBefore(container, component2);
            }
            return this.components.get(n);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.components.size() > 0 ? this.components.get(0) : null;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.components.size() > 0 ? this.components.get(0) : null;
        }

        @Override
        public Component getInitialComponent(Window window) {
            return this.components.size() > 0 ? this.components.get(0) : null;
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.components.size() > 0 ? this.components.get(this.components.size() - 1) : null;
        }
    }

    class ButtonActionHandler
    implements ActionListener {
        ButtonActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SearchDialog.this.closeBtn) {
                SearchDialog.this.cancel();
            } else if (object == SearchDialog.this.findBtn || object == SearchDialog.this.find || object == SearchDialog.this.replace) {
                SearchDialog.this.ok();
            } else if (object == SearchDialog.this.replaceBtn) {
                SearchDialog.this.save(false);
                SearchAndReplace.replace(SearchDialog.this.view);
            } else if (object == SearchDialog.this.replaceAndFindBtn) {
                SearchDialog.this.save(false);
                if (SearchAndReplace.replace(SearchDialog.this.view)) {
                    SearchDialog.this.ok();
                } else {
                    SearchDialog.this.getToolkit().beep();
                }
            } else if (object == SearchDialog.this.replaceAllBtn) {
                if (SearchDialog.this.searchSelection.isSelected() && SearchDialog.this.view.getTextArea().getSelectionCount() == 0) {
                    GUIUtilities.error(SearchDialog.this.view, "search-no-selection", null);
                    return;
                }
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                if (!SearchDialog.this.save(false)) {
                    SearchDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    SearchDialog.this.getToolkit().beep();
                    return;
                }
                if (SearchDialog.this.searchSelection.isSelected()) {
                    if (SearchAndReplace.replace(SearchDialog.this.view)) {
                        SearchDialog.this.closeOrKeepDialog();
                    } else {
                        SearchDialog.this.getToolkit().beep();
                    }
                } else if (SearchAndReplace.replaceAll(SearchDialog.this.view)) {
                    SearchDialog.this.closeOrKeepDialog();
                } else {
                    SearchDialog.this.getToolkit().beep();
                }
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class MultiFileActionHandler
    implements ActionListener {
        MultiFileActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SearchDialog.this.choose) {
                String[] stringArray = GUIUtilities.showVFSFileDialog(SearchDialog.this, SearchDialog.this.view, SearchDialog.this.directory.getText(), 3, false);
                if (stringArray != null) {
                    SearchDialog.this.directory.setText(stringArray[0]);
                }
            } else if (actionEvent.getSource() == SearchDialog.this.synchronize) {
                this.synchronizeMultiFileSettings();
            } else {
                SearchDialog.this.ok();
            }
        }

        private void synchronizeMultiFileSettings() {
            if (SearchDialog.this.searchDirectory.isSelected()) {
                SearchDialog.this.directory.setText(SearchDialog.this.view.getBuffer().getDirectory());
            }
            if (!jEdit.getBooleanProperty("search.dontSyncFilter", false)) {
                SearchDialog.this.filter.setText('*' + MiscUtilities.getFileExtension(SearchDialog.this.view.getBuffer().getName()));
            }
        }
    }

    class SettingsActionHandler
    implements ActionListener {
        SettingsActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SearchDialog.this.searchCurrentBuffer) {
                SearchDialog.this.hyperSearch.setSelected(false);
            } else if (object == SearchDialog.this.searchSelection || object == SearchDialog.this.searchAllBuffers || object == SearchDialog.this.searchDirectory) {
                SearchDialog.this.hyperSearch.setSelected(true);
            }
            SearchDialog.this.save(true);
            SearchDialog.this.updateEnabled();
        }
    }

    class ReplaceActionHandler
    implements ActionListener {
        ReplaceActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SearchDialog.this.replace.setModel(SearchDialog.this.beanShellReplace.isSelected() ? "replace.script" : "replace");
            SearchAndReplace.setBeanShellReplace(SearchDialog.this.beanShellReplace.isSelected());
        }
    }
}

