/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javajs.util.JSJSONParser;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.openscience.jmol.app.nbo.NBODialog;
import org.openscience.jmol.app.nbo.NBODialogConfig;
import org.openscience.jmol.app.nbo.NBODialogModel;
import org.openscience.jmol.app.nbo.NBOFileHandler;

abstract class NBODialogRun
extends NBODialogModel {
    protected static boolean ALLOW_SELECT_ALL = false;
    protected static final String ARCHIVE_DIR = "http://nbo6.chem.wisc.edu/jmol_nborxiv/";
    protected static final String RUN_EXTENSIONS = "47;gau;gms";
    protected static final String[] keywordList = new String[]{"CMO: Bonding character of canonical MO's", "DIPOLE: Dipole moment analysis", "NBBP: Natural bond-bond polarizability indices", "NBCP: Natural bond critical point analysis", "NCE: Natural coulomb electrostatics analysis", "NCU: Natural cluster unit analysis", "NRT: Natural resonance theory analysis", "PLOT: Write files for orbital plotting", "STERIC: Natural steric analysis"};
    protected Box editBox;
    protected JRadioButton rbLocal;
    protected JRadioButton[] keywordButtons;
    protected JButton run;
    private String[] fileData;
    protected String nboKeywords;
    protected JTextField plotFileName;
    protected boolean isOpenShell;
    protected ChooseList chooseList;

    protected NBODialogRun(JFrame f) {
        super(f);
    }

    protected JPanel buildRunPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(NBODialogRun.titleBox(" Select Job ", new NBODialogConfig.HelpBtn("run_job_help.htm")));
        Box inputBox = this.borderBox(true);
        this.panel.add(inputBox);
        if (this.inputFileHandler == null) {
            this.inputFileHandler = new NBOFileHandler("", "47", 2, "47", (NBODialog)this);
            this.inputFileHandler.browse.setEnabled(false);
        } else {
            this.inputFileHandler = new NBOFileHandler(this.inputFileHandler.jobStem, this.inputFileHandler.tfExt.getText(), 2, "47", (NBODialog)this);
        }
        this.inputFileHandler.browse.setEnabled(false);
        Box box = Box.createHorizontalBox();
        ButtonGroup bg = new ButtonGroup();
        this.rbLocal = new JRadioButton("Local");
        this.rbLocal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.inputFileHandler.browse.setEnabled(true);
            }
        });
        box.add(this.rbLocal);
        bg.add(this.rbLocal);
        JRadioButton btn = new JRadioButton("NBOrXiv");
        final NBODialogRun d = this;
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArchiveViewer aView = new ArchiveViewer((NBODialog)d, NBODialogRun.ARCHIVE_DIR);
                aView.setVisible(true);
            }
        });
        box.add(btn);
        bg.add(btn);
        btn = new JRadioButton("WebMO");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = "http://www.webmo.net/demoserver/cgi-bin/webmo/jobmgr.cgi";
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception e1) {
                    NBODialogRun.this.alertError("Could not open WebMO");
                }
            }
        });
        box.add(btn);
        bg.add(btn);
        inputBox.add(box);
        inputBox.add(this.inputFileHandler);
        inputBox.setMaximumSize(new Dimension(355, 80));
        this.panel.add(NBODialogRun.titleBox(" Choose $NBO Keywords ", new NBODialogConfig.HelpBtn("run_keywords_help.htm"))).setVisible(false);
        this.editBox = this.borderBox(true);
        this.editBox.setMinimumSize(new Dimension(350, 400));
        this.plotFileName = new JTextField();
        this.editBox.setVisible(false);
        this.panel.add(this.editBox);
        this.run = new JButton("Run");
        this.run.setVisible(false);
        this.panel.add(this.run).setFont(new Font("Arial", 0, 20));
        this.run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialogRun.this.runJob("", NBODialogRun.this.inputFileHandler.inputFile, "gennbo");
            }
        });
        String ext = this.inputFileHandler.tfExt.getText();
        if (ext.equals("47")) {
            this.notifyLoad_r();
        }
        return this.panel;
    }

    @Override
    protected void showAtomNums(boolean alpha) {
        if (!this.showAtNum) {
            this.runScriptNow("select {*};label off; select remove {*}");
            return;
        }
        SB sb = new SB();
        sb.append("select {*};label %a;");
        if (this.chooseList != null) {
            Hashtable<String, String> lonePairs = alpha ? this.chooseList.lonePairs : this.chooseList.lonePairs_b;
            Hashtable<String, String> loneV = this.chooseList.lv;
            for (int i = 1; i <= this.vwr.ms.ac; ++i) {
                String lv;
                sb.append("select (atomno=" + i + ");label ");
                String atNum = new Integer(i).toString();
                String lp = lonePairs.get(atNum);
                if (lp != null && !lp.equals("0")) {
                    sb.append("<sup>(" + lp + ")</sup>");
                }
                if ((lv = loneV.get(atNum)) != null && !lv.equals("0")) {
                    sb.append("<sub>[" + lv + "]</sub>");
                }
                sb.append("%a;");
            }
        }
        String color = this.nboView ? "black" : "gray";
        sb.append("select {*};color labels white;");
        sb.append("select {H*};color labels " + color + ";" + "set labeloffset 0 0 {*}; select remove {*};");
        this.runScriptNow(sb.toString());
    }

    protected String cleanNBOKeylist(String params) {
        String[] tokens = PT.getTokens(PT.rep(PT.clean(params), "file=", "FILE="));
        String tmp = "";
        for (String s : tokens) {
            if (s.length() <= 0) continue;
            if (s.toLowerCase().contains("file=") && this.plotFileName != null) {
                this.plotFileName.setText(s.substring(s.indexOf("=") + 1));
                continue;
            }
            if (tmp.length() + s.length() - tmp.lastIndexOf(sep) >= 80) {
                tmp = tmp + sep + " ";
            }
            tmp = tmp + s.toUpperCase() + " ";
        }
        if (this.plotFileName != null && this.plotFileName.getText().equals("")) {
            this.plotFileName.setText(this.inputFileHandler.jobStem);
        }
        return tmp;
    }

    protected void setBonds(boolean alpha) {
        SB tmp;
        if (this.chooseList == null) {
            return;
        }
        SB sB = tmp = alpha ? this.chooseList.bonds : this.chooseList.bonds_b;
        if (tmp == null) {
            return;
        }
        String bonds = tmp.toString();
        if (!bonds.trim().equals("")) {
            this.vwr.ms.deleteAllBonds();
            for (String s : bonds.split("\n")) {
                String[] tokens = s.split(":");
                String key = tokens[0];
                String[] atoms = tokens[1].split(" ");
                int at1 = Integer.parseInt(atoms[0]);
                int at2 = Integer.parseInt(atoms[1]);
                int order = 0;
                short mag = 250;
                switch (key.charAt(0)) {
                    case 'S': {
                        order = 1;
                        break;
                    }
                    case 'D': {
                        order = 2;
                        break;
                    }
                    case 'T': {
                        order = 3;
                        mag = 150;
                        break;
                    }
                    case 'Q': {
                        order = 4;
                        mag = 100;
                        break;
                    }
                    default: {
                        order = Integer.parseInt(key);
                        mag = 100;
                    }
                }
                this.vwr.ms.bondAtoms(this.vwr.ms.at[at1 - 1], this.vwr.ms.at[at2 - 1], order, mag, this.vwr.ms.bsVisible, 0.0f, true, true);
            }
        }
        if (this.nboView) {
            String s2 = this.runScriptNow("print {*}.bonds");
            this.runScriptNow("select " + s2 + ";color bonds lightgrey");
        }
    }

    protected void setChooseList(String data) {
        this.chooseList = new ChooseList();
        String[] tokens = PT.split(data, "END");
        int ind = 0;
        SB bonds = this.chooseList.bonds;
        SB bonds3c = this.chooseList.bonds3c;
        Hashtable<String, String> lonePairs = this.chooseList.lonePairs;
        if (data.trim().contains("ALPHA")) {
            this.isOpenShell = true;
            ind = 1;
        }
        for (String x : tokens) {
            int j;
            String[] list = x.trim().split("\\s+");
            if (list[0].trim().equals("BETA")) {
                bonds = this.chooseList.bonds_b;
                bonds3c = this.chooseList.bonds3c_b;
                lonePairs = this.chooseList.lonePairs_b;
                ind = 1;
            }
            if (list[ind].trim().equals("LONE")) {
                for (j = 1 + ind; j < list.length; j += 2) {
                    lonePairs.put(list[j], list[j + 1]);
                }
            } else if (list[ind].trim().equals("BOND")) {
                for (j = 1 + ind; j < list.length; j += 3) {
                    bonds.append(list[j] + ":" + list[j + 1] + " " + list[j + 2] + "\n");
                }
            } else if (list[ind].equals("3C")) {
                for (j = 1 + ind; j < list.length; j += 4) {
                    bonds3c.append(list[j] + ":" + list[j + 1] + " " + list[j + 2] + " " + list[j + 3] + "\n");
                }
            }
            ind = 0;
        }
    }

    protected String getFileContents(String jobName) {
        String fileContents = this.fileData[0] + "$NBO\n " + "FILE=" + jobName + " " + this.nboKeywords + "  $END" + sep;
        return fileContents + this.fileData[2];
    }

    protected void addNBOKeylist() {
        if (this.inputFileHandler.inputFile != null) {
            this.editBox.removeAll();
            this.editBox.add(Box.createRigidArea(new Dimension(350, 0)));
            final DefaultListModel<String> sList = new DefaultListModel<String>();
            String tmp = "";
            for (String s : this.nboKeywords.split("\\s+")) {
                if (s.length() <= 0 || s.toUpperCase().contains("FILE=")) continue;
                sList.addElement(s);
                tmp = tmp + s + " ";
            }
            this.nboKeywords = tmp;
            final JList keywords = new JList(sList);
            keywords.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        NBODialogRun.this.removeListParams(keywords.getSelectedValuesList(), sList);
                    }
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Jobname ")).setFont(new Font("Arial", 1, 16));
            box.add(this.plotFileName).setMaximumSize(new Dimension(100, 30));
            box.setAlignmentX(0.5f);
            Box box2 = Box.createVerticalBox();
            box2.add(box);
            JLabel lab = new JLabel("(Plot files will be created with this name)");
            lab.setAlignmentX(0.5f);
            box2.add(lab);
            this.editBox.add(box2);
            box2 = Box.createHorizontalBox();
            box2.add(new JLabel("Keywords:  ")).setFont(new Font("Arial", 1, 16));
            final JPanel menu = this.menuNboKeywords();
            ButtonGroup bg = new ButtonGroup();
            JRadioButton btn = new JRadioButton("Menu Select");
            bg.add(btn);
            box2.add(btn);
            final JPanel manEdit = this.addManualEditor();
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    manEdit.setVisible(false);
                    menu.setVisible(true);
                }
            });
            btn.doClick();
            btn = new JRadioButton("Text Editor");
            bg.add(btn);
            box2.add(btn);
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    menu.setVisible(false);
                    manEdit.setVisible(true);
                }
            });
            this.editBox.add(box2);
            manEdit.setAlignmentX(0.5f);
            this.editBox.add(manEdit);
            this.editBox.add(menu);
        }
    }

    private JPanel menuNboKeywords() {
        JPanel menu = new JPanel();
        menu.setLayout(new BoxLayout(menu, 1));
        menu.setBorder(BorderFactory.createLoweredBevelBorder());
        this.keywordButtons = new JRadioButton[keywordList.length];
        for (int i = 0; i < this.keywordButtons.length; ++i) {
            this.keywordButtons[i] = new JRadioButton(keywordList[i]);
            if (this.nboKeywords.contains(keywordList[i].split(":")[0])) {
                this.keywordButtons[i].setSelected(true);
            }
            final int op = i;
            this.keywordButtons[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String key = keywordList[op].split(":")[0];
                    if (NBODialogRun.this.keywordButtons[op].isSelected()) {
                        NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords + key + " ";
                        NBODialogRun.this.log("Keyword added: " + key, 'i');
                    } else {
                        NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords.replaceAll(key + " ", "");
                        NBODialogRun.this.log("Keyword removed: " + key, 'i');
                    }
                }
            });
            this.keywordButtons[i].setAlignmentX(0.0f);
            menu.add(this.keywordButtons[i]);
        }
        JLabel lab2 = new JLabel("(Select one or more)");
        menu.add(lab2);
        menu.setAlignmentX(0.5f);
        menu.setMinimumSize(new Dimension(300, 250));
        menu.setVisible(false);
        return menu;
    }

    private JPanel addManualEditor() {
        JScrollPane sp = new JScrollPane();
        JPanel d = new JPanel(new BorderLayout());
        final JTextPane p = new JTextPane();
        sp.setPreferredSize(new Dimension(200, 200));
        sp.getViewport().add(p);
        d.add((Component)sp, "Center");
        p.setText("$NBO\nFile=" + this.plotFileName.getText() + " " + this.nboKeywords + "\n$END");
        p.setCaretPosition(7);
        JButton btn = new JButton("Save Changes");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = p.getText();
                String tmp = s.replace("$NBO", "").replace("$END", "");
                NBODialogRun.this.nboKeywords = "";
                for (String x : tmp.split("\\s+")) {
                    x = x.trim();
                    System.out.println(x);
                    if (x.length() == 0) continue;
                    if (x.indexOf("=") < 0) {
                        NBODialogRun.this.nboKeywords = NBODialogRun.this.nboKeywords + x + " ";
                        continue;
                    }
                    NBODialogRun.this.plotFileName.setText(x.substring(x.indexOf("=") + 1));
                }
                NBODialogRun.this.addNBOKeylist();
                NBODialogRun.this.editBox.repaint();
                NBODialogRun.this.editBox.revalidate();
            }
        });
        d.add((Component)btn, "South");
        d.setVisible(false);
        d.setMaximumSize(new Dimension(300, 200));
        return d;
    }

    protected void removeListParams(List<String> list, DefaultListModel<String> listModel) {
        this.log("Keyword(s) removed:", 'p');
        for (String x : list) {
            listModel.removeElement(x);
            if (!this.nboKeywords.toUpperCase().contains(x.toUpperCase())) continue;
            this.nboKeywords = this.nboKeywords.substring(0, this.nboKeywords.indexOf(x.toUpperCase())) + this.nboKeywords.substring(this.nboKeywords.indexOf(x.toUpperCase()) + x.length());
            this.log("  " + x, 'i');
        }
    }

    protected void runJob(String keywords, File inputFile, String ess) {
        int i;
        String jobName;
        if (this.fileData == null) {
            this.fileData = this.inputFileHandler.read47File();
            this.nboKeywords = this.fileData[1];
        }
        this.inputFileHandler.jobStem = this.inputFileHandler.jobStem.trim();
        String string = jobName = this.plotFileName == null ? this.inputFileHandler.jobStem : this.plotFileName.getText().trim();
        if (!jobName.equals(this.inputFileHandler.jobStem) && (i = JOptionPane.showConfirmDialog(null, "Warning! Plot files are being created with name \"" + jobName + "\", which does not match your file name \"" + this.inputFileHandler.jobStem + "\"\nDo you want to change that to \"" + this.inputFileHandler.jobStem + "\" so that all files related to this job are under the same name, and View will work correctly?", "Warning", 0)) == 0) {
            jobName = this.inputFileHandler.jobStem;
            this.plotFileName.setText(jobName);
        }
        for (String x : keywords.split(" ")) {
            if (this.nboKeywords.contains(x + " ")) continue;
            this.nboKeywords = this.nboKeywords + x + " ";
        }
        if (!this.nboKeywords.contains("PLOT")) {
            this.nboKeywords = this.nboKeywords + "PLOT";
        }
        if (this.inputFileHandler.useExt.equals("47") && !this.inputFileHandler.writeToFile(inputFile.getAbsolutePath(), this.getFileContents(jobName))) {
            this.logInfo("Could not create " + inputFile, 2);
            return;
        }
        SB sb = new SB();
        sb.append("GLOBAL C_PATH " + inputFile.getParent() + sep);
        sb.append("GLOBAL C_JOBSTEM " + this.inputFileHandler.jobStem + sep);
        sb.append("GLOBAL C_ESS " + ess.toLowerCase() + sep);
        sb.append("GLOBAL C_LABEL_1 FILE=" + (jobName.equals("") ? this.inputFileHandler.jobStem : jobName));
        this.nboService.rawCmdNew("r", sb, 20, null, "Running GenNBO...");
    }

    protected void notifyLoad_r() {
        if (this.vwr.ms.ac == 0) {
            return;
        }
        this.fileData = this.inputFileHandler.read47File();
        this.nboKeywords = this.cleanNBOKeylist(this.fileData[1]);
        if (this.inputFileHandler.useExt.equals("47")) {
            if (!this.inputFileHandler.getChooseList()) {
                File f = NBOFileHandler.newNBOFile(this.inputFileHandler.inputFile, "nbo");
                if (f.exists()) {
                    this.logInfo("Error reading $CHOOSE list", 2);
                }
            } else {
                this.setBonds(true);
            }
        }
        this.showAtomNums(true);
        this.addNBOKeylist();
        for (Component c : this.panel.getComponents()) {
            c.setVisible(true);
        }
        this.editBox.getParent().setVisible(true);
        this.editBox.setVisible(true);
        this.repaint();
        this.revalidate();
    }

    @Override
    protected void showConfirmationDialog(String st, File newFile, String ext) {
        int i = JOptionPane.showConfirmDialog(this, st, "Message", 0);
        if (i == 0) {
            JDialog d = new JDialog(this);
            d.setLayout(new BorderLayout());
            JTextPane tp = new JTextPane();
            d.add((Component)tp, "Center");
            d.setSize(new Dimension(500, 600));
            tp.setText(this.inputFileHandler.getFileData(NBOFileHandler.newNBOFile(newFile, "nbo").toString()));
            d.setVisible(true);
        }
    }

    class ChooseList {
        protected Hashtable<String, String> lv = new Hashtable();
        protected Hashtable<String, String> lv_b = new Hashtable();
        protected Hashtable<String, String> lonePairs = new Hashtable();
        protected Hashtable<String, String> lonePairs_b = new Hashtable();
        protected SB bonds = new SB();
        protected SB bonds_b = new SB();
        protected SB bonds3c = new SB();
        protected SB bonds3c_b = new SB();
    }

    class ArchiveViewer
    extends JDialog
    implements ActionListener {
        private JScrollPane archivePanel;
        private JButton selectAll;
        private JButton download;
        private JCheckBox[] jcLinks;
        private JTextField tfPath;
        private String baseDir;

        public ArchiveViewer(NBODialog d, String url) {
            super((Dialog)d, "NBO Archive Files");
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width = gd.getDisplayMode().getWidth() / 2 - 250;
            int height = gd.getDisplayMode().getHeight() / 2 - 120;
            this.setLocation(width, height);
            this.setSize(new Dimension(500, 240));
            this.setLayout(new BorderLayout());
            this.setResizable(false);
            this.archivePanel = new JScrollPane();
            this.archivePanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.add((Component)this.archivePanel, "Center");
            String[] links = this.getLinks(url);
            this.setLinks(links, null);
            Box bottom = Box.createHorizontalBox();
            this.tfPath = new JTextField(d.inputFileHandler.fileDir);
            bottom.add(new JLabel("  Download to: "));
            bottom.add(this.tfPath);
            if (ALLOW_SELECT_ALL) {
                this.selectAll = new JButton("Select All");
                this.selectAll.addActionListener(this);
                bottom.add(this.selectAll);
            }
            this.download = new JButton("Download");
            this.download.addActionListener(this);
            bottom.add(this.download);
            this.add((Component)bottom, "South");
        }

        private String[] getLinks(String baseDir) {
            String sep;
            String html;
            if (!baseDir.endsWith("/")) {
                baseDir = baseDir + "/";
            }
            this.baseDir = baseDir;
            String fileList = NBODialogRun.this.inputFileHandler.getFileData(baseDir + "47files.txt");
            if (fileList == null) {
                html = NBODialogRun.this.inputFileHandler.getFileData(baseDir);
                sep = "<a";
            } else {
                if (fileList.indexOf("{") == 0 || fileList.indexOf("[") == 0) {
                    ArrayList list;
                    Map<String, Object> map = new JSJSONParser().parseMap(fileList, true);
                    ArrayList arrayList = list = map == null ? null : (ArrayList)map.get("47files");
                    if (list == null || list.size() == 0) {
                        return new String[0];
                    }
                    String ext = ((String)list.get(0)).indexOf(".47") >= 0 ? "" : ".47";
                    String[] a = list.toArray(new String[0]);
                    for (int i = 0; i < list.size(); ++i) {
                        a[i] = baseDir + (String)list.get(i) + ext;
                    }
                    return a;
                }
                html = PT.rep(fileList, "\r", "");
                sep = "\n";
            }
            ArrayList<String> files = new ArrayList<String>();
            String[] toks = html.split(sep);
            for (int i = 1; i < toks.length; ++i) {
                String file = PT.getQuotedAttribute(toks[i], "href");
                if (file == null || !file.endsWith(".47")) continue;
                files.add(file);
            }
            return files.toArray(new String[0]);
        }

        private void setLinks(String[] links, String startsWith) {
            this.jcLinks = new JCheckBox[links.length];
            JPanel filePanel = new JPanel(new FlowLayout());
            if (startsWith == null) {
                startsWith = "";
            }
            ButtonGroup bg = ALLOW_SELECT_ALL ? null : new ButtonGroup();
            for (int i = 0; i < links.length; i += 6) {
                Box box = Box.createVerticalBox();
                for (int j = 0; j < 6 && i + j < this.jcLinks.length; ++j) {
                    this.jcLinks[i + j] = new JCheckBox(links[i + j]);
                    if (bg != null) {
                        bg.add(this.jcLinks[i + j]);
                    }
                    this.jcLinks[i + j].setBackground(Color.white);
                    box.add(this.jcLinks[i + j]);
                }
                filePanel.add(box);
            }
            filePanel.setBackground(Color.white);
            this.archivePanel.getViewport().add(filePanel);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.selectAll) {
                int i;
                boolean didCheck = false;
                for (i = 0; i < this.jcLinks.length; ++i) {
                    if (this.jcLinks[i].isSelected()) continue;
                    didCheck = true;
                    this.jcLinks[i].setSelected(true);
                }
                if (!didCheck) {
                    for (i = 0; i < this.jcLinks.length; ++i) {
                        this.jcLinks[i].setSelected(false);
                    }
                }
                this.repaint();
            } else if (e.getSource() == this.download) {
                this.downloadFiles();
            }
        }

        public void downloadFiles() {
            File f = null;
            NBODialogRun.this.logInfo("saving to " + this.tfPath.getText().trim(), 4);
            int n = 0;
            for (int i = 0; i < this.jcLinks.length; ++i) {
                int j;
                if (!this.jcLinks[i].isSelected()) continue;
                String path = this.tfPath.getText().trim();
                path = path.endsWith("/") || path.endsWith("\\") ? path + this.jcLinks[i].getText() : path + "/" + this.jcLinks[i].getText();
                f = new File(path);
                if (f.exists() && (j = JOptionPane.showConfirmDialog(null, "File " + f.getAbsolutePath() + " already exists, do you want to overwrite contents?", "Warning", 0)) == 1) {
                    return;
                }
                String s = this.baseDir + this.jcLinks[i].getText();
                try {
                    String fileData = NBODialogRun.this.vwr.getAsciiFileOrNull(s);
                    if (fileData == null) {
                        NBODialogRun.this.logInfo("Error reading " + s, 2);
                        break;
                    }
                    if (NBODialogRun.this.inputFileHandler.writeToFile(path, fileData)) {
                        NBODialogRun.this.logInfo(f.getName() + " (" + fileData.length() + " bytes)", 4);
                        ++n;
                        continue;
                    }
                    NBODialogRun.this.logInfo("Error writing to " + f, 2);
                }
                catch (Throwable e) {
                    NBODialogRun.this.alertError("Error reading " + s + ": " + e);
                }
                break;
            }
            NBODialogRun.this.logInfo("saved " + n + "file" + (n == 1 ? "" : "s"), 4);
            if (f == null) {
                return;
            }
            NBODialogRun.this.inputFileHandler.setInputFile(f);
            NBODialogRun.this.rbLocal.doClick();
            this.setVisible(false);
            this.dispose();
        }
    }
}

