/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropException;

public final class ArityException
extends InteropException {
    private static final long serialVersionUID = 1857745390734085182L;
    private final int expectedArity;
    private final int actualArity;

    private ArityException(int expectedArity, int actualArity) {
        super("Arity error - expected: " + expectedArity + " actual: " + actualArity);
        this.expectedArity = expectedArity;
        this.actualArity = actualArity;
    }

    public int getExpectedArity() {
        return this.expectedArity;
    }

    public int getActualArity() {
        return this.actualArity;
    }

    public static RuntimeException raise(int expectedArity, int actualArity) {
        CompilerDirectives.transferToInterpreter();
        return ArityException.silenceException(RuntimeException.class, new ArityException(expectedArity, actualArity));
    }
}

