/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.languagetool.FakeLanguage;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;

public class SentenceWhitespaceRuleTest {
    @Test
    public void testMatch() throws Exception {
        SentenceWhitespaceRule rule = new SentenceWhitespaceRule(TestTools.getEnglishMessages());
        JLanguageTool languageTool = new JLanguageTool((Language)new FakeLanguage());
        languageTool.addRule((Rule)rule);
        this.assertGood("This is a text. And there's the next sentence.", rule, languageTool);
        this.assertGood("This is a text! And there's the next sentence.", rule, languageTool);
        this.assertGood("This is a text\nAnd there's the next sentence.", rule, languageTool);
        this.assertGood("This is a text\n\nAnd there's the next sentence.", rule, languageTool);
        this.assertBad("This is a text.And there's the next sentence.", rule, languageTool);
        this.assertBad("This is a text!And there's the next sentence.", rule, languageTool);
        this.assertBad("This is a text?And there's the next sentence.", rule, languageTool);
    }

    private void assertGood(String text, SentenceWhitespaceRule rule, JLanguageTool languageTool) throws IOException {
        MatcherAssert.assertThat((Object)languageTool.check(text).size(), (Matcher)CoreMatchers.is((Object)0));
        rule.reset();
    }

    private void assertBad(String text, SentenceWhitespaceRule rule, JLanguageTool languageTool) throws IOException {
        MatcherAssert.assertThat((Object)languageTool.check(text).size(), (Matcher)CoreMatchers.is((Object)1));
        rule.reset();
    }
}

