/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.compiler;

import java.io.Serializable;
import org.mvel2.ParserContext;
import org.mvel2.compiler.Accessor;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.OptimizerFactory;

public class CompiledAccExpression
implements ExecutableStatement,
Serializable {
    private char[] expression;
    private transient Accessor accessor;
    private ParserContext context;
    private Class ingressType;

    public CompiledAccExpression(char[] expression, Class ingressType, ParserContext context) {
        this.expression = expression;
        this.context = context;
        this.ingressType = ingressType != null ? ingressType : Object.class;
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory vrf, Object value) {
        if (this.accessor == null) {
            if (this.ingressType == Object.class && value != null) {
                this.ingressType = value.getClass();
            }
            this.accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeSetAccessor(this.context, this.expression, ctx, ctx, vrf, false, value, this.ingressType);
        } else {
            this.accessor.setValue(ctx, elCtx, vrf, value);
        }
        return value;
    }

    public Object getValue(Object staticContext, VariableResolverFactory factory) {
        if (this.accessor == null) {
            this.accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeAccessor(this.context, this.expression, staticContext, staticContext, factory, false, this.ingressType);
        }
        return this.accessor.getValue(staticContext, staticContext, factory);
    }

    public void setKnownIngressType(Class type) {
        this.ingressType = type;
    }

    public void setKnownEgressType(Class type) {
    }

    public Class getKnownIngressType() {
        return this.ingressType;
    }

    public Class getKnownEgressType() {
        return null;
    }

    public boolean isConvertableIngressEgress() {
        return false;
    }

    public void computeTypeConversionRule() {
    }

    public boolean intOptimized() {
        return false;
    }

    public boolean isLiteralOnly() {
        return false;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (this.accessor == null) {
            this.accessor = OptimizerFactory.getThreadAccessorOptimizer().optimizeAccessor(this.context, this.expression, ctx, elCtx, variableFactory, false, this.ingressType);
        }
        return this.accessor.getValue(ctx, elCtx, variableFactory);
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public boolean isEmptyStatement() {
        return this.accessor == null;
    }

    public boolean isExplicitCast() {
        return false;
    }
}

