/*
 * Decompiled with CFR 0.152.
 */
package esmska.persistence;

import esmska.data.Config;
import esmska.data.Contact;
import esmska.data.DeprecatedGateway;
import esmska.data.Gateway;
import esmska.data.GatewayConfig;
import esmska.data.Gateways;
import esmska.data.History;
import esmska.data.SMS;
import esmska.data.Signature;
import esmska.data.Signatures;
import esmska.persistence.ContactParser;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ImportManager {
    private static final Logger logger = Logger.getLogger(ImportManager.class.getName());

    private ImportManager() {
    }

    public static ArrayList<Contact> importContacts(File file, ContactParser.ContactType type) throws Exception {
        logger.finer("Importing contacts of type " + (Object)((Object)type) + " from file: " + file.getAbsolutePath());
        ContactParser parser = new ContactParser(file, type);
        parser.execute();
        ArrayList contacts = (ArrayList)parser.get();
        logger.finer("Imported " + contacts.size() + " contacts");
        return (ArrayList)parser.get();
    }

    /*
     * Exception decompiling
     */
    public static ArrayList<SMS> importQueue(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static ArrayList<History.Record> importHistory(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static TreeSet<Gateway> importGateways(String resource) throws IOException, IntrospectionException {
        logger.finer("Importing gateways from resource: " + resource);
        URL gatewayBase = ImportManager.class.getResource(resource);
        if (gatewayBase == null || !gatewayBase.getProtocol().equals("jar")) {
            throw new IOException("Could not find jar gateway resource: " + resource);
        }
        HashSet<URL> gatewayURLs = new HashSet<URL>();
        JarURLConnection con = (JarURLConnection)gatewayBase.openConnection();
        Enumeration<JarEntry> entries = con.getJarFile().entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            String absoluteName = name.startsWith("/") ? name : "/" + name;
            if (!absoluteName.startsWith(resource) || !absoluteName.endsWith(".gateway")) continue;
            gatewayURLs.add(new URL("jar:" + con.getJarFileURL() + "!/" + name));
        }
        return ImportManager.importGateways(gatewayURLs, false);
    }

    public static TreeSet<Gateway> importGateways(File directory, boolean deleteOnFail) throws IOException, IntrospectionException {
        File[] files;
        logger.finer("Importing gateways from directory: " + directory.getAbsolutePath());
        if (!directory.canRead() || !directory.isDirectory()) {
            throw new IOException("Invalid gateway directory: " + directory.getAbsolutePath());
        }
        HashSet<URL> gatewayURLs = new HashSet<URL>();
        for (File f : files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".gateway") && pathname.canRead();
            }
        })) {
            gatewayURLs.add(f.toURI().toURL());
        }
        return ImportManager.importGateways(gatewayURLs, deleteOnFail);
    }

    private static TreeSet<Gateway> importGateways(Set<URL> gatewayURLs, boolean deleteOnFail) throws IntrospectionException {
        logger.log(Level.FINER, "Importing gateways from set of {0} URLs", gatewayURLs.size());
        TreeSet<Gateway> gateways = new TreeSet<Gateway>();
        for (URL gatewayURL : gatewayURLs) {
            try {
                Gateway gateway = new Gateway(gatewayURL);
                if (Config.compareProgramVersions(Config.getLatestVersion(), gateway.getMinProgramVersion()) < 0) {
                    logger.log(Level.INFO, "Gateway {0} requires program of version at least {1}, skipping.", new Object[]{gateway.getName(), gateway.getMinProgramVersion()});
                    continue;
                }
                if (gateways.contains(gateway)) {
                    Iterator<Gateway> it = gateways.iterator();
                    while (it.hasNext()) {
                        Gateway op = it.next();
                        if (!op.equals(gateway) || op.getVersion().compareTo(gateway.getVersion()) >= 0) continue;
                        it.remove();
                    }
                }
                gateways.add(gateway);
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Problem accessing gateway resource: " + gatewayURL.toExternalForm(), ex);
            }
            catch (IntrospectionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Ivalid gateway resource: " + gatewayURL.toExternalForm(), ex);
                if (!deleteOnFail) continue;
                try {
                    logger.log(Level.FINE, "Deleting invalid gateway file: {0}", gatewayURL);
                    File gwFile = new File(gatewayURL.toURI());
                    gwFile.delete();
                }
                catch (Exception exc) {
                    logger.log(Level.WARNING, "Can't delete gateway: " + gatewayURL, exc);
                }
            }
        }
        logger.log(Level.FINER, "Imported {0} gateways", gateways.size());
        return gateways;
    }

    public static HashSet<DeprecatedGateway> importDeprecatedGateways(String resource) throws IOException, SAXException {
        logger.finer("Importing deprecated gateways from resource: " + resource);
        URL deprecFile = ImportManager.class.getResource(resource);
        if (deprecFile == null || !deprecFile.getProtocol().equals("jar")) {
            throw new IOException("Could not find jar gateway resource: " + resource);
        }
        return ImportManager.importDeprecatedGateways(deprecFile);
    }

    public static HashSet<DeprecatedGateway> importDeprecatedGateways(File file) throws IOException, SAXException {
        logger.finer("Importing deprecated gateways from file: " + file.getAbsolutePath());
        if (!file.canRead() || !file.isFile()) {
            throw new IOException("Invalid deprecated gateway file: " + file.getAbsolutePath());
        }
        return ImportManager.importDeprecatedGateways(file.toURI().toURL());
    }

    public static HashSet<DeprecatedGateway> importDeprecatedGateways(URL url) throws IOException, SAXException {
        logger.finer("Importing deprecated gateways from URL: " + url);
        HashSet<DeprecatedGateway> deprecated = new HashSet<DeprecatedGateway>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xpath = xpf.newXPath();
            Document doc = db.parse(url.openStream());
            NodeList gateways = doc.getElementsByTagName("deprecatedGateway");
            for (int i = 0; i < gateways.getLength(); ++i) {
                Node gateway = gateways.item(i);
                String name = xpath.evaluate("name/text()", gateway);
                String version = xpath.evaluate("version/text()", gateway);
                String reason = xpath.evaluate("reason/text()", gateway);
                DeprecatedGateway depr = new DeprecatedGateway(name, version, reason);
                deprecated.add(depr);
            }
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex);
        }
        catch (XPathExpressionException ex) {
            throw new SAXException(ex);
        }
        return deprecated;
    }

    /*
     * Exception decompiling
     */
    public static void importKeyring(File file) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importGlobalConfig(File file) throws IOException {
        logger.finer("Importing global configuration from file: " + file.getAbsolutePath());
        Config.GlobalConfig globalConfig = Config.GlobalConfig.getInstance();
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            Properties props = new Properties();
            props.load(reader);
            String prop = props.getProperty("announceProgramUpdates");
            if ("yes".equals(prop)) {
                globalConfig.setAnnounceProgramUpdates(true);
            } else if ("no".equals(prop)) {
                globalConfig.setAnnounceProgramUpdates(false);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        logger.finer("Imported global configuration");
    }

    public static void importGatewayProperties(File file) throws IOException {
        JSONObject jsonGwConfigs;
        JSONArray jsonSignatures;
        logger.log(Level.FINER, "Importing gateway properties from file: {0}", file.getAbsolutePath());
        String jsonString = FileUtils.readFileToString(file, "UTF-8");
        JSONObject obj = JSONObject.fromObject(jsonString);
        JSONObject jsonDefSig = (JSONObject)obj.get("default signature");
        if (jsonDefSig != null) {
            try {
                Signature defSig = (Signature)JSONObject.toBean(jsonDefSig, Signature.class);
                Signature.DEFAULT.setUserName(defSig.getUserName());
                Signature.DEFAULT.setUserNumber(defSig.getUserNumber());
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Could not load default signature", ex);
            }
        }
        if ((jsonSignatures = (JSONArray)obj.get("signatures")) != null) {
            try {
                for (int i = 0; i < jsonSignatures.size(); ++i) {
                    JSONObject sigObj = jsonSignatures.getJSONObject(i);
                    Signature signature = (Signature)JSONObject.toBean(sigObj, Signature.class);
                    Signatures.getInstance().add(signature);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Could not load user signatures", ex);
            }
        }
        if ((jsonGwConfigs = (JSONObject)obj.get("configs")) != null) {
            try {
                Iterator it = jsonGwConfigs.keys();
                while (it.hasNext()) {
                    String gwName = (String)it.next();
                    GatewayConfig gwConfig = (GatewayConfig)JSONObject.toBean(jsonGwConfigs.getJSONObject(gwName), GatewayConfig.class);
                    Gateway gateway = Gateways.getInstance().get(gwName);
                    if (gateway == null) continue;
                    gateway.setConfig(gwConfig);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Could not load gateway configs", ex);
            }
        }
        logger.finer("Imported gateway properties");
    }
}

