/*
 * Decompiled with CFR 0.152.
 */
package esmska.transfer;

import esmska.data.CountryPrefix;
import esmska.data.SMS;
import esmska.data.Tuple;
import esmska.transfer.GatewayConnector;
import esmska.transfer.ImageCodeManager;
import esmska.utils.L10N;
import esmska.utils.LogSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class GatewayExecutor {
    private static final Problem[] needParams = new Problem[]{Problem.CUSTOM_MESSAGE, Problem.FIX_IN_PROGRESS, Problem.GATEWAY_MESSAGE, Problem.INTERNAL_MESSAGE, Problem.UNUSABLE};
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Logger logger = Logger.getLogger(GatewayExecutor.class.getName());
    public static final String INFO_FREE_SMS_REMAINING = l10n.getString("GatewayExecutor.INFO_FREE_SMS_REMAINING") + " ";
    public static final String INFO_CREDIT_REMAINING = l10n.getString("GatewayExecutor.INFO_CREDIT_REMAINING") + " ";
    public static final String INFO_STATUS_NOT_PROVIDED = l10n.getString("GatewayExecutor.INFO_STATUS_NOT_PROVIDED");
    private final GatewayConnector connector = new GatewayConnector();
    private final SMS sms;
    private String referer;
    private String lastTextContent;

    public GatewayExecutor(SMS sms) {
        this.sms = sms;
    }

    public void forgetCookie(String name, String domain, String path) {
        this.connector.forgetCookie(name, domain, path);
    }

    public Object getURL(String url, String[] params) throws IOException {
        try {
            this.connector.setConnection(url, params, false, null);
            this.connector.setReferer(this.referer);
            boolean ok = this.connector.connect();
            if (!ok) {
                throw new IOException("Could not connect to URL");
            }
            if (this.connector.isTextContent()) {
                this.lastTextContent = this.connector.getTextContent();
                return this.connector.getTextContent();
            }
            this.lastTextContent = null;
            return this.connector.getBinaryContent();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not execute getURL", ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "Could not execute getURL", ex);
            throw ex;
        }
    }

    public Object postURL(String url, String[] params, String[] postData) throws IOException {
        try {
            this.connector.setConnection(url, params, true, postData);
            this.connector.setReferer(this.referer);
            boolean ok = this.connector.connect();
            if (!ok) {
                throw new IOException("Could not connect to URL");
            }
            if (this.connector.isTextContent()) {
                this.lastTextContent = this.connector.getTextContent();
                return this.connector.getTextContent();
            }
            this.lastTextContent = null;
            return this.connector.getBinaryContent();
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Could not execute postURL", ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.log(Level.WARNING, "Could not execute postURL", ex);
            throw ex;
        }
    }

    public String recognizeImage(byte[] imageBytes, String hint) throws InterruptedException, InvocationTargetException, ExecutionException {
        logger.fine("Resolving security code...");
        if (imageBytes == null && StringUtils.isEmpty(hint)) {
            return "";
        }
        ImageIcon image = imageBytes == null ? null : new ImageIcon(imageBytes);
        this.sms.setImage(image);
        this.sms.setImageHint(hint);
        boolean resolved = ImageCodeManager.getResolver().resolveImageCode(this.sms);
        if (!resolved) {
            logger.info("Could not resolve security code or resolving cancelled");
        }
        return StringUtils.defaultString(this.sms.getImageCode());
    }

    public void setProblem(Object problem) {
        this.setProblem(problem, null);
    }

    public void setProblem(Object problem, String param) {
        Problem prob = problem instanceof String ? Problem.valueOf((String)problem) : (Problem)((Object)problem);
        if (ArrayUtils.contains((Object[])needParams, (Object)prob) && StringUtils.isEmpty(param)) {
            throw new IllegalArgumentException("Missing additional parameter for provided problem " + (Object)((Object)prob));
        }
        if (prob == Problem.UNKNOWN) {
            this.logCrash();
        }
        this.sms.setProblem(new Tuple<Problem, String>(prob, param));
    }

    public void setSupplementalMessage(String supplMessage) {
        this.sms.setSupplMsg(supplMessage);
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public void sleep(long milliseconds) throws InterruptedException {
        logger.log(Level.FINE, "Sleeping for {0} ms...", milliseconds);
        if (milliseconds <= 0L) {
            return;
        }
        Thread.sleep(milliseconds);
    }

    public String extractCountryPrefix(String phoneNumber) {
        return StringUtils.defaultString(CountryPrefix.extractCountryPrefix(phoneNumber));
    }

    void setPreferredLanguage(String language) {
        this.connector.setLanguage(language);
    }

    private void logCrash() {
        if (this.lastTextContent == null) {
            return;
        }
        Level level = LogSupport.getEsmskaLogger().getLevel();
        if (level.equals(Level.ALL)) {
            return;
        }
        LogSupport.getEsmskaLogger().setLevel(Level.ALL);
        logger.log(Level.FINEST, "#### WEB CONTENT START ####\n{0}\n#### WEB CONTENT END ####", this.lastTextContent);
        LogSupport.getEsmskaLogger().setLevel(level);
    }

    public static enum Problem {
        CUSTOM_MESSAGE,
        FIX_IN_PROGRESS,
        GATEWAY_MESSAGE,
        INTERNAL_MESSAGE,
        LIMIT_REACHED,
        LONG_TEXT,
        NO_CREDIT,
        NO_REASON,
        SIGNATURE_NEEDED,
        UNKNOWN,
        UNUSABLE,
        WRONG_AUTH,
        WRONG_CODE,
        WRONG_NUMBER,
        WRONG_SIGNATURE;

    }
}

