/*
 * Decompiled with CFR 0.152.
 */
package a_vcard.android.syncml.pim;

import a_vcard.android.content.ContentValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyNode {
    public String propName;
    public String propValue;
    public List<String> propValue_vector;
    public byte[] propValue_bytes;
    public ContentValues paramMap;
    public Set<String> paramMap_TYPE;
    public Set<String> propGroupSet;

    public PropertyNode() {
        this.propName = "";
        this.propValue = "";
        this.propValue_vector = new ArrayList<String>();
        this.paramMap = new ContentValues();
        this.paramMap_TYPE = new HashSet<String>();
        this.propGroupSet = new HashSet<String>();
    }

    public PropertyNode(String propName, String propValue, List<String> propValue_vector, byte[] propValue_bytes, ContentValues paramMap, Set<String> paramMap_TYPE, Set<String> propGroupSet) {
        this.propName = propName != null ? propName : "";
        this.propValue = propValue != null ? propValue : "";
        this.propValue_vector = propValue_vector != null ? propValue_vector : new ArrayList<String>();
        this.propValue_bytes = propValue_bytes;
        this.paramMap = paramMap != null ? paramMap : new ContentValues();
        this.paramMap_TYPE = paramMap_TYPE != null ? paramMap_TYPE : new HashSet<String>();
        this.propGroupSet = propGroupSet != null ? propGroupSet : new HashSet<String>();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PropertyNode)) {
            return false;
        }
        PropertyNode node = (PropertyNode)obj;
        if (this.propName == null || !this.propName.equals(node.propName)) {
            return false;
        }
        if (!this.paramMap.equals(node.paramMap)) {
            return false;
        }
        if (!((Object)this.paramMap_TYPE).equals(node.paramMap_TYPE)) {
            return false;
        }
        if (!((Object)this.propGroupSet).equals(node.propGroupSet)) {
            return false;
        }
        if (this.propValue_bytes != null && Arrays.equals(this.propValue_bytes, node.propValue_bytes)) {
            return true;
        }
        if (!this.propValue.equals(node.propValue)) {
            return false;
        }
        return ((Object)this.propValue_vector).equals(node.propValue_vector) || this.propValue_vector.size() == 1 || node.propValue_vector.size() == 1;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("propName: ");
        builder.append(this.propName);
        builder.append(", paramMap: ");
        builder.append(this.paramMap.toString());
        builder.append(", propmMap_TYPE: ");
        builder.append(this.paramMap_TYPE.toString());
        builder.append(", propGroupSet: ");
        builder.append(this.propGroupSet.toString());
        if (this.propValue_vector != null && this.propValue_vector.size() > 1) {
            builder.append(", propValue_vector size: ");
            builder.append(this.propValue_vector.size());
        }
        if (this.propValue_bytes != null) {
            builder.append(", propValue_bytes size: ");
            builder.append(this.propValue_bytes.length);
        }
        builder.append(", propValue: ");
        builder.append(this.propValue);
        return builder.toString();
    }

    public String encode() {
        int i;
        int size;
        StringBuilder builder = new StringBuilder();
        if (this.propName.length() > 0) {
            builder.append("propName:[");
            builder.append(this.propName);
            builder.append("],");
        }
        if ((size = this.propGroupSet.size()) > 0) {
            Set<String> set = this.propGroupSet;
            builder.append("propGroup:[");
            i = 0;
            for (String string : set) {
                builder.append(string);
                if (i < size - 1) {
                    builder.append(",");
                }
                ++i;
            }
            builder.append("],");
        }
        if (this.paramMap.size() > 0 || this.paramMap_TYPE.size() > 0) {
            ContentValues values = this.paramMap;
            builder.append("paramMap:[");
            size = this.paramMap.size();
            i = 0;
            for (Map.Entry entry : values.valueSet()) {
                builder.append((String)entry.getKey());
                builder.append("=");
                builder.append(entry.getValue().toString().replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,"));
                if (i < size - 1) {
                    builder.append(",");
                }
                ++i;
            }
            Set<String> set = this.paramMap_TYPE;
            size = this.paramMap_TYPE.size();
            if (i > 0 && size > 0) {
                builder.append(",");
            }
            i = 0;
            for (String type : set) {
                builder.append("TYPE=");
                builder.append(type.replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,"));
                if (i < size - 1) {
                    builder.append(",");
                }
                ++i;
            }
            builder.append("],");
        }
        if ((size = this.propValue_vector.size()) > 0) {
            builder.append("propValue:[");
            List<String> list = this.propValue_vector;
            for (i = 0; i < size; ++i) {
                builder.append(list.get(i).replaceAll("\\\\", "\\\\\\\\").replaceAll(",", "\\\\,"));
                if (i >= size - 1) continue;
                builder.append(",");
            }
            builder.append("],");
        }
        return builder.toString();
    }

    public static PropertyNode decode(String encodedString) {
        String[] elems;
        PropertyNode propertyNode = new PropertyNode();
        String trimed = encodedString.trim();
        if (trimed.length() == 0) {
            return propertyNode;
        }
        for (String elem : elems = trimed.split("],")) {
            int index = elem.indexOf(91);
            String name = elem.substring(0, index - 1);
            Pattern pattern = Pattern.compile("(?<!\\\\),");
            String[] values = pattern.split(elem.substring(index + 1), -1);
            if (name.equals("propName")) {
                propertyNode.propName = values[0];
                continue;
            }
            if (name.equals("propGroupSet")) {
                for (String value : values) {
                    propertyNode.propGroupSet.add(value);
                }
                continue;
            }
            if (name.equals("paramMap")) {
                ContentValues paramMap = propertyNode.paramMap;
                Set<String> paramMap_TYPE = propertyNode.paramMap_TYPE;
                for (String value : values) {
                    String[] tmp = value.split("=", 2);
                    String mapKey = tmp[0];
                    String mapValue = tmp[1].replaceAll("\\\\,", ",").replaceAll("\\\\\\\\", "\\\\");
                    if (mapKey.equalsIgnoreCase("TYPE")) {
                        paramMap_TYPE.add(mapValue);
                        continue;
                    }
                    paramMap.put(mapKey, mapValue);
                }
                continue;
            }
            if (!name.equals("propValue")) continue;
            StringBuilder builder = new StringBuilder();
            List<String> list = propertyNode.propValue_vector;
            int length = values.length;
            for (int i = 0; i < length; ++i) {
                String normValue = values[i].replaceAll("\\\\,", ",").replaceAll("\\\\\\\\", "\\\\");
                list.add(normValue);
                builder.append(normValue);
                if (i >= length - 1) continue;
                builder.append(";");
            }
            propertyNode.propValue = builder.toString();
        }
        String encoding = propertyNode.paramMap.getAsString("ENCODING");
        if (encoding != null && (encoding.equalsIgnoreCase("BASE64") || encoding.equalsIgnoreCase("B"))) {
            propertyNode.propValue_bytes = Base64.decodeBase64((byte[])propertyNode.propValue_vector.get(0).getBytes());
        }
        return propertyNode;
    }
}

